/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableVersion;

public class Version
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = -4345025177285348717L;
    private String value;

    public Version(String value) {
        super(PropertyName.VERSION.toString());
        this.value = value;
    }

    private Version(ParameterList params, String value) {
        super(PropertyName.VERSION.toString(), params);
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ValidationResult validate() throws ValidationException {
        return PropertyValidatorSupport.VERSION.validate((Object)this);
    }

    protected PropertyFactory<Version> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Version> {
        public Factory() {
            super(new String[]{PropertyName.VERSION.toString()});
        }

        public Version createProperty(ParameterList params, String value) {
            if (params.getAll().isEmpty() && ImmutableVersion.VERSION_4_0.getValue().equalsIgnoreCase(value)) {
                return ImmutableVersion.VERSION_4_0;
            }
            return new Version(params, value);
        }

        @Override
        public Version createProperty(Group group, ParameterList params, String value) {
            throw new UnsupportedOperationException();
        }
    }
}

