/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.parameter.Value;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.Agent;
import net.fortuna.ical4j.vcard.property.Anniversary;
import net.fortuna.ical4j.vcard.property.BDay;
import net.fortuna.ical4j.vcard.property.Birth;
import net.fortuna.ical4j.vcard.property.CalAdrUri;
import net.fortuna.ical4j.vcard.property.CalUri;
import net.fortuna.ical4j.vcard.property.Categories;
import net.fortuna.ical4j.vcard.property.Clazz;
import net.fortuna.ical4j.vcard.property.ClientPidMap;
import net.fortuna.ical4j.vcard.property.ContactBy;
import net.fortuna.ical4j.vcard.property.ContactUri;
import net.fortuna.ical4j.vcard.property.Created;
import net.fortuna.ical4j.vcard.property.DDay;
import net.fortuna.ical4j.vcard.property.Death;
import net.fortuna.ical4j.vcard.property.DefLanguage;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.FbUrl;
import net.fortuna.ical4j.vcard.property.Fn;
import net.fortuna.ical4j.vcard.property.Gender;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.GramGender;
import net.fortuna.ical4j.vcard.property.Impp;
import net.fortuna.ical4j.vcard.property.Key;
import net.fortuna.ical4j.vcard.property.Kind;
import net.fortuna.ical4j.vcard.property.Label;
import net.fortuna.ical4j.vcard.property.Lang;
import net.fortuna.ical4j.vcard.property.Logo;
import net.fortuna.ical4j.vcard.property.Mailer;
import net.fortuna.ical4j.vcard.property.Member;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Name;
import net.fortuna.ical4j.vcard.property.Nickname;
import net.fortuna.ical4j.vcard.property.Note;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Photo;
import net.fortuna.ical4j.vcard.property.ProdId;
import net.fortuna.ical4j.vcard.property.Pronouns;
import net.fortuna.ical4j.vcard.property.Related;
import net.fortuna.ical4j.vcard.property.Revision;
import net.fortuna.ical4j.vcard.property.Role;
import net.fortuna.ical4j.vcard.property.SocialProfile;
import net.fortuna.ical4j.vcard.property.SortString;
import net.fortuna.ical4j.vcard.property.Sound;
import net.fortuna.ical4j.vcard.property.Source;
import net.fortuna.ical4j.vcard.property.Telephone;
import net.fortuna.ical4j.vcard.property.Title;
import net.fortuna.ical4j.vcard.property.Tz;
import net.fortuna.ical4j.vcard.property.Uid;
import net.fortuna.ical4j.vcard.property.Url;
import net.fortuna.ical4j.vcard.property.Version;
import net.fortuna.ical4j.vcard.property.Xml;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableKind;
import net.fortuna.ical4j.vcard.property.immutable.ImmutableVersion;

public interface PropertyValidatorSupport {
    public static final ValidationRule<Property> TEXT_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.TEXT.equals(v.get());
    }, "MUST be specified as TEXT:", new String[]{"VALUE"});
    public static final ValidationRule<Property> URI_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.URI.equals(v.get());
    }, "MUST be specified as a URI:", new String[]{"VALUE"});
    public static final ValidationRule<Property> DATE_AND_OR_TIME_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.DATE_AND_OR_TIME.equals(v.get());
    }, "MUST be specified as a DATE and/or TIME:", new String[]{"VALUE"});
    public static final ValidationRule<Property> LANGUAGE_TAG_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.LANGUAGE_TAG.equals(v.get());
    }, "MUST be specified as a LANGUAGE TAG:", new String[]{"VALUE"});
    public static final ValidationRule<Property> UTC_OFFSET_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.UTC_OFFSET.equals(v.get());
    }, "MUST be specified as a UTC OFFSET:", new String[]{"VALUE"});
    public static final ValidationRule<Property> TIMESTAMP_VALUE = new ValidationRule(ValidationRule.ValidationType.None, prop -> {
        Optional v = prop.getParameter("VALUE");
        return v.isPresent() && !Value.TIMESTAMP.equals(v.get());
    }, "MUST be specified as a TIMESTAMP:", new String[]{"VALUE"});
    public static final Validator<Address> ADDRESS = new PropertyValidator(PropertyName.ADR.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.VALUE.toString(), ParameterName.LABEL.toString(), ParameterName.LANGUAGE.toString(), ParameterName.GEO.toString(), ParameterName.TZ.toString(), ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<Agent> AGENT = new PropertyValidator(PropertyName.AGENT.toString(), new ValidationRule[0]);
    public static final Validator<Anniversary<?>> ANNIVERSARY_DATE = new PropertyValidator(PropertyName.ANNIVERSARY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.CALSCALE.toString()}), DATE_AND_OR_TIME_VALUE});
    public static final Validator<Anniversary<?>> ANNIVERSARY_TEXT = new PropertyValidator(PropertyName.ANNIVERSARY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<BDay<?>> BDAY_DATE = new PropertyValidator(PropertyName.BDAY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.CALSCALE.toString()}), DATE_AND_OR_TIME_VALUE});
    public static final Validator<BDay<?>> BDAY_TEXT = new PropertyValidator(PropertyName.BDAY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Birth> BIRTH = new PropertyValidator(PropertyName.BIRTH.toString(), new ValidationRule[0]);
    public static final Validator<CalAdrUri> CALADRURI = new PropertyValidator(PropertyName.CALADRURI.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<CalUri> CALURI = new PropertyValidator(PropertyName.CALURI.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<ContactUri> CONTACT_URI = new PropertyValidator(PropertyName.CONTACT_URI.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Categories> CATEGORIES = new PropertyValidator(PropertyName.CATEGORIES.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Clazz> CLASS = new PropertyValidator(PropertyName.CLASS.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.None, Arrays.stream(ParameterName.values()).map(ParameterName::toString).collect(Collectors.toList()).toArray(new String[0]))});
    public static final Validator<ClientPidMap> CLIENTPIDMAP = new PropertyValidator(PropertyName.CLIENTPIDMAP.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.None, new String[]{ParameterName.PID.toString()})});
    public static final Validator<ContactBy> CONTACT_BY_VALIDATOR = new PropertyValidator(PropertyName.CONTACT_BY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.TYPE.toString(), ParameterName.PREF.toString()}), new ValidationRule(ValidationRule.ValidationType.ValueMatch, new String[]{"(?i)" + String.join((CharSequence)"|", "ADR", "EMAIL", "IMPP", "TEL", "X-[A-Z0-9-]+")})});
    public static final Validator<Created> CREATED_VALIDATOR = new PropertyValidator(PropertyName.CREATED.toString(), new ValidationRule[]{TIMESTAMP_VALUE});
    public static final Validator<DDay> DDAY = new PropertyValidator(PropertyName.DDAY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.VALUE.toString()})});
    public static final Validator<Death> DEATH = new PropertyValidator(PropertyName.DEATH.toString(), new ValidationRule[0]);
    public static final Validator<DefLanguage> DEF_LANGUAGE_VALIDATOR = new PropertyValidator(PropertyName.DEFLANGUAGE.toString(), new ValidationRule[0]);
    public static final Validator<Email> EMAIL = new PropertyValidator(PropertyName.EMAIL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<FbUrl> FBURL = new PropertyValidator(PropertyName.FBURL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Fn> FN = new PropertyValidator(PropertyName.FN.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.LANGUAGE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Gender> GENDER = new PropertyValidator(PropertyName.GENDER.toString(), new ValidationRule[]{TEXT_VALUE, new ValidationRule(ValidationRule.ValidationType.ValueMatch, new String[]{"(?i)" + String.join((CharSequence)"|", "N", "F", "M", "O", "U")})});
    public static final Validator<Geo> GEO = new PropertyValidator(PropertyName.GEO.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<GramGender> GRAM_GENDER_VALIDATOR = new PropertyValidator(PropertyName.GRAMGENDER.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.ValueMatch, new String[]{"(?i)" + String.join((CharSequence)"|", "animate", "common", "feminine", "inanimate", "masculine", "neuter", "X-[A-Z0-9-]+")})});
    public static final Validator<Impp> IMPP = new PropertyValidator(PropertyName.IMPP.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString(), ParameterName.ALTID.toString()}), URI_VALUE});
    public static final Validator<Key> KEY_URI = new PropertyValidator(PropertyName.KEY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString(), ParameterName.ALTID.toString()}), URI_VALUE});
    public static final Validator<Key> KEY_TEXT = new PropertyValidator(PropertyName.KEY.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Kind> KIND = new PropertyValidator(PropertyName.KIND.toString(), new ValidationRule[]{TEXT_VALUE, new ValidationRule(ValidationRule.ValidationType.ValueMatch, new String[]{"(?i)" + String.join((CharSequence)"|", ImmutableKind.INDIVIDUAL.getValue(), ImmutableKind.GROUP.getValue(), ImmutableKind.ORG.getValue(), ImmutableKind.LOCATION.getValue(), ImmutableKind.APPLICATION.getValue(), ImmutableKind.DEVICE.getValue())})});
    public static final Validator<Label> LABEL = new PropertyValidator(PropertyName.LABEL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.VALUE.toString(), ParameterName.TYPE.toString()})});
    public static final Validator<Lang> LANG = new PropertyValidator(PropertyName.LANG.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.ALTID.toString()}), LANGUAGE_TAG_VALUE});
    public static final Validator<Logo> LOGO = new PropertyValidator(PropertyName.LOGO.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.LANGUAGE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Mailer> MAILER = new PropertyValidator(PropertyName.MAILER.toString(), new ValidationRule[0]);
    public static final Validator<Member> MEMBER = new PropertyValidator(PropertyName.MEMBER.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<N> N = new PropertyValidator(PropertyName.N.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.SORT_AS.toString(), ParameterName.LANGUAGE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Name> NAME = new PropertyValidator(PropertyName.NAME.toString(), new ValidationRule[0]);
    public static final Validator<Nickname> NICKNAME = new PropertyValidator(PropertyName.NICKNAME.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.TYPE.toString(), ParameterName.LANGUAGE.toString(), ParameterName.ALTID.toString(), ParameterName.PREF.toString()}), TEXT_VALUE});
    public static final Validator<Note> NOTE = new PropertyValidator(PropertyName.NOTE.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.LANGUAGE.toString(), ParameterName.ALTID.toString()}), TEXT_VALUE});
    public static final Validator<Org> ORG = new PropertyValidator(PropertyName.ORG.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.SORT_AS.toString(), ParameterName.LANGUAGE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<Photo> PHOTO = new PropertyValidator(PropertyName.PHOTO.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString(), ParameterName.PREF.toString(), ParameterName.PID.toString()}), URI_VALUE});
    public static final Validator<ProdId> PRODID = new PropertyValidator(PropertyName.PRODID.toString(), new ValidationRule[]{TEXT_VALUE});
    public static final Validator<Pronouns> PRONOUNS_VALIDATOR = new PropertyValidator(PropertyName.PRONOUNS.toString(), new ValidationRule[]{TEXT_VALUE, new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.LANGUAGE.toString()})});
    public static final Validator<Related> RELATED_TEXT = new PropertyValidator(PropertyName.RELATED.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.LANGUAGE.toString()}), TEXT_VALUE});
    public static final Validator<Related> RELATED_URI = new PropertyValidator(PropertyName.RELATED.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Revision> REV = new PropertyValidator(PropertyName.REV.toString(), new ValidationRule[]{TIMESTAMP_VALUE});
    public static final Validator<Role> ROLE = new PropertyValidator(PropertyName.ROLE.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.LANGUAGE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<SocialProfile> SOCIAL_PROFILE_TEXT_VALIDATOR = new PropertyValidator(PropertyName.TEL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.VALUE.toString()}), TEXT_VALUE});
    public static final Validator<SocialProfile> SOCIAL_PROFILE_URI_VALIDATOR = new PropertyValidator(PropertyName.TEL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.VALUE.toString()}), URI_VALUE});
    public static final Validator<SortString> SORT_STRING = new PropertyValidator(PropertyName.SORT_STRING.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.VALUE.toString()})});
    public static final Validator<Sound> SOUND = new PropertyValidator(PropertyName.SOUND.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.LANGUAGE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Source> SOURCE = new PropertyValidator(PropertyName.SOURCE.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Telephone> TEL_TEXT = new PropertyValidator(PropertyName.TEL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<Telephone> TEL_URI = new PropertyValidator(PropertyName.TEL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.MEDIATYPE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString()}), URI_VALUE});
    public static final Validator<Title> TITLE = new PropertyValidator(PropertyName.TITLE.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.LANGUAGE.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.ALTID.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<Tz> TZ_TEXT = new PropertyValidator(PropertyName.TZ.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString()}), TEXT_VALUE});
    public static final Validator<Tz> TZ_URI = new PropertyValidator(PropertyName.TZ.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Tz> TZ_UTC_OFFSET = new PropertyValidator(PropertyName.TZ.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString()}), UTC_OFFSET_VALUE});
    public static final Validator<Uid> UID_URI = new PropertyValidator(PropertyName.UID.toString(), new ValidationRule[]{URI_VALUE});
    public static final Validator<Uid> UID_TEXT = new PropertyValidator(PropertyName.UID.toString(), new ValidationRule[]{TEXT_VALUE});
    public static final Validator<Url> URL = new PropertyValidator(PropertyName.URL.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString(), ParameterName.PID.toString(), ParameterName.PREF.toString(), ParameterName.TYPE.toString(), ParameterName.MEDIATYPE.toString()}), URI_VALUE});
    public static final Validator<Version> VERSION = new PropertyValidator(PropertyName.VERSION.toString(), new ValidationRule[]{TEXT_VALUE, new ValidationRule(ValidationRule.ValidationType.ValueMatch, new String[]{"(?i)" + ImmutableVersion.VERSION_4_0.getValue()})});
    public static final Validator<Xml> XML_VALIDATOR = new PropertyValidator(PropertyName.XML.toString(), new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneOrLess, new String[]{ParameterName.ALTID.toString()}), TEXT_VALUE});
}

