/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterBuilder;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.vcard.GroupRegistry;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilderContext;
import net.fortuna.ical4j.vcard.VCardList;

public final class VCardBuilder {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern VCARD_BEGIN = Pattern.compile("^BEGIN:VCARD$", 2);
    private static final Pattern RELAXED_VCARD_BEGIN = Pattern.compile("^BEGIN:VCARD\\s*$", 2);
    private static final Pattern VCARD_END = Pattern.compile("^END:VCARD$", 2);
    private static final Pattern RELAXED_VCARD_END = Pattern.compile("^END:VCARD\\s*$", 2);
    static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^(([a-zA-Z-\\d]+\\.)?[a-zA-Z]+(?=[;:]))|(([a-zA-Z-\\d]+\\.)?[Xx]-[a-zA-Z-]+(?=[;:]))");
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("(?<=[:]).*$");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("(?<=[;])[^:]*(?=[:])");
    private static final int BUFFER_SIZE = 1024;
    private final BufferedReader reader;
    private final GroupRegistry groupRegistry;
    private final VCardBuilderContext vCardBuilderContext;
    private final boolean relaxedParsing;

    public VCardBuilder(InputStream in) {
        this(new InputStreamReader(in, DEFAULT_CHARSET));
    }

    public VCardBuilder(Reader in) {
        this(in, new GroupRegistry(), new VCardBuilderContext());
    }

    @Deprecated
    public VCardBuilder(Reader in, GroupRegistry registry, PropertyFactoryRegistry propertyFactoryRegistry, ParameterFactoryRegistry parameterFactoryRegistry) {
        this(in, registry, new VCardBuilderContext());
    }

    public VCardBuilder(Reader in, GroupRegistry registry, VCardBuilderContext vCardBuilderContext) {
        this.reader = new BufferedReader((Reader)new UnfoldingReader(in, 1024), 1024);
        this.groupRegistry = registry;
        this.vCardBuilderContext = vCardBuilderContext;
        this.relaxedParsing = CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed");
    }

    public VCard build() throws IOException, ParserException {
        return this.build(true);
    }

    public VCardList buildAll() throws IOException, ParserException {
        VCard card;
        ArrayList<VCard> cards = new ArrayList<VCard>();
        while ((card = this.build(false)) != null) {
            cards.add(card);
        }
        return new VCardList(Collections.unmodifiableList(cards));
    }

    private VCard build(boolean single) throws IOException, ParserException {
        VCard vcard = null;
        String line = null;
        String lastLine = null;
        int nonBlankLineNo = 0;
        int totalLineNo = 0;
        boolean end = false;
        Pattern beginPattern = null;
        Pattern endPattern = null;
        if (this.relaxedParsing) {
            beginPattern = RELAXED_VCARD_BEGIN;
            endPattern = RELAXED_VCARD_END;
        } else {
            beginPattern = VCARD_BEGIN;
            endPattern = VCARD_END;
        }
        while ((single || !end) && (line = this.reader.readLine()) != null) {
            ++totalLineNo;
            if (line.trim().isEmpty()) continue;
            if (++nonBlankLineNo == 1) {
                if (!beginPattern.matcher(line).matches()) {
                    throw new ParserException(nonBlankLineNo);
                }
                vcard = new VCard();
            } else if (!endPattern.matcher(line).matches()) {
                Property property;
                try {
                    property = this.parseProperty(line);
                }
                catch (URISyntaxException e) {
                    throw new ParserException("Error parsing line", totalLineNo, (Throwable)e);
                }
                if (property != null) {
                    vcard.add(property);
                }
            } else if (endPattern.matcher(line).matches()) {
                end = true;
            }
            if (line.trim().isEmpty()) continue;
            lastLine = line;
        }
        if (single && (nonBlankLineNo <= 1 || !endPattern.matcher(lastLine).matches())) {
            throw new ParserException(totalLineNo);
        }
        return vcard;
    }

    private Property parseProperty(String line) throws URISyntaxException {
        PropertyBuilder propertyBuilder = new PropertyBuilder(this.vCardBuilderContext.getPropertyFactorySupplier().get());
        Matcher matcher = PROPERTY_NAME_PATTERN.matcher(line);
        if (matcher.find()) {
            propertyBuilder.name(matcher.group().toUpperCase());
            matcher = PROPERTY_VALUE_PATTERN.matcher(line);
            if (matcher.find()) {
                propertyBuilder.value(matcher.group(0));
                ParameterList params = this.parseParameters(line);
                params.get(new String[0]).forEach(arg_0 -> ((PropertyBuilder)propertyBuilder).parameter(arg_0));
            }
            return propertyBuilder.build();
        }
        return null;
    }

    private boolean isExtendedName(String name) {
        return name.startsWith("X-");
    }

    private ParameterList parseParameters(String line) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Matcher matcher = PARAMETERS_PATTERN.matcher(line);
        if (matcher.find()) {
            String[] params;
            ParameterBuilder parameterBuilder = new ParameterBuilder(this.vCardBuilderContext.getParameterFactorySupplier().get());
            for (String param : params = matcher.group().split(";")) {
                String[] vals = param.split("=");
                parameterBuilder.name(vals[0]);
                if (vals.length > 1) {
                    parameterBuilder.value(vals[1]);
                }
                parameters.add(parameterBuilder.build());
            }
        }
        return new ParameterList(parameters);
    }
}

