/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Type;

public class ContactUri
extends Property
implements PropertyValidatorSupport {
    private URI uri;

    public ContactUri(URI uri, Type ... types) {
        super(PropertyName.CALURI.toString());
        this.uri = uri;
        for (Type type : types) {
            this.add(type);
        }
    }

    public ContactUri(ParameterList params, String value) {
        super(PropertyName.CALURI.toString());
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        return Strings.valueOf((Object)this.uri);
    }

    public void setValue(String aValue) {
        try {
            this.uri = new URI(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return CONTACT_URI.validate((Object)this);
    }

    protected PropertyFactory<ContactUri> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<ContactUri> {
        public Factory() {
            super(new String[]{PropertyName.CONTACT_URI.toString()});
        }

        public ContactUri createProperty(ParameterList params, String value) {
            return new ContactUri(params, value);
        }
    }
}

