/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupProperty;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import org.apache.commons.lang3.StringUtils;

public class Telephone
extends Property
implements PropertyValidatorSupport,
GroupProperty {
    private static final long serialVersionUID = -7747040131815077325L;
    public static Type TYPE_TEXT = new Type("text");
    public static Type TYPE_VOICE = new Type("voice");
    public static Type TYPE_FAX = new Type("fax");
    public static Type TYPE_CELL = new Type("cell");
    public static Type TYPE_VIDEO = new Type("video");
    public static Type TYPE_PAGER = new Type("pager");
    public static Type TYPE_TEXTPHONE = new Type("textphone");
    private static final String TEL_SCHEME = "tel";
    private URI uri;
    private String value;

    public Telephone(URI uri, Type ... types) {
        super((Enum)PropertyName.TEL);
        this.uri = this.normalise(uri);
        this.add(Value.URI);
        for (Type type : types) {
            this.add(type);
        }
    }

    @Deprecated
    public Telephone(Group group, URI uri, Type ... types) {
        this(uri, types);
        this.setGroup(group);
    }

    public Telephone(String value, Type ... types) {
        super((Enum)PropertyName.TEL);
        this.value = value;
        for (Type type : types) {
            this.add(type);
        }
    }

    public Telephone(ParameterList params, String value) {
        super((Enum)PropertyName.TEL, params);
        this.setValue(value);
    }

    @Deprecated
    public Telephone(Group group, ParameterList params, String value) {
        this(params, value);
        this.setGroup(group);
    }

    private URI normalise(URI uri) {
        URI retVal;
        if (uri.getScheme() == null && StringUtils.isNotEmpty((CharSequence)uri.getSchemeSpecificPart())) {
            try {
                retVal = new URI(TEL_SCHEME, uri.getSchemeSpecificPart(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                retVal = uri;
            }
        } else {
            retVal = uri;
        }
        return retVal;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getValue() {
        if (this.uri != null) {
            return Strings.valueOf((Object)this.uri);
        }
        return this.value;
    }

    public void setValue(String value) {
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            try {
                this.uri = this.normalise(new URI(value.trim().replaceAll("\\s+", "-")));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.value = value;
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return TEL_URI.validate((Object)this);
        }
        return TEL_TEXT.validate((Object)this);
    }

    protected PropertyFactory<Telephone> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Telephone> {
        public Factory() {
            super(new String[]{PropertyName.TEL.toString()});
        }

        public Telephone createProperty(ParameterList params, String value) {
            return new Telephone(params, value);
        }

        @Override
        public Telephone createProperty(Group group, ParameterList params, String value) {
            return new Telephone(group, params, value);
        }
    }
}

