/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ZoneOffsetAdapter;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Value;

public class Tz
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 930436197799477318L;
    private ZoneOffsetAdapter offset;
    private String text;

    public Tz(ZoneOffset offset) {
        super((Enum)PropertyName.TZ);
        this.offset = new ZoneOffsetAdapter(offset);
    }

    public Tz(String text) {
        super((Enum)PropertyName.TZ);
        this.text = text;
        this.add(Value.TEXT);
    }

    public Tz(ParameterList params, String value) {
        super((Enum)PropertyName.TZ, params);
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            this.text = value;
        } else {
            this.offset = new ZoneOffsetAdapter(ZoneOffset.of(value));
        }
    }

    public ZoneOffset getOffset() {
        return this.offset.getOffset();
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        String value = null;
        if (Optional.of(Value.TEXT).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            value = this.text;
        } else if (this.offset != null) {
            value = this.offset.toString();
        }
        return value;
    }

    public void setValue(String aValue) {
        try {
            this.offset = new ZoneOffsetAdapter(ZoneOffset.of(aValue));
            this.text = null;
            this.remove(Value.TEXT);
        }
        catch (DateTimeException e) {
            this.text = aValue;
            this.offset = null;
            this.replace(Value.TEXT);
        }
    }

    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return TZ_URI.validate((Object)this);
        }
        if (Optional.of(Value.UTC_OFFSET).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            return TZ_UTC_OFFSET.validate((Object)this);
        }
        return TZ_TEXT.validate((Object)this);
    }

    protected PropertyFactory<Tz> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Tz> {
        public Factory() {
            super(new String[]{PropertyName.TZ.toString()});
        }

        public Tz createProperty(ParameterList params, String value) {
            return new Tz(params, value);
        }

        @Override
        public Tz createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

