/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.ParameterName;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.PropertyName;
import net.fortuna.ical4j.vcard.PropertyValidatorSupport;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.parameter.Value;
import net.fortuna.ical4j.vcard.property.Photo;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logo
extends Property
implements PropertyValidatorSupport {
    private static final long serialVersionUID = 7255763733402012595L;
    private final Logger log = LoggerFactory.getLogger(Photo.class);
    private URI uri;
    private byte[] binary;

    public Logo(URI uri) {
        super((Enum)PropertyName.LOGO);
        this.uri = uri;
        this.add(Value.URI);
    }

    public Logo(byte[] binary) {
        this(binary, null);
    }

    public Logo(byte[] binary, Type contentType) {
        super((Enum)PropertyName.LOGO);
        this.binary = binary;
        this.add(Encoding.B);
        if (contentType != null) {
            this.add(contentType);
        }
    }

    public Logo(ParameterList params, String value) {
        super((Enum)PropertyName.LOGO, params);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public String getValue() {
        String stringValue = null;
        if (Optional.of(Value.URI).equals(this.getParameter(ParameterName.VALUE.toString()))) {
            stringValue = Strings.valueOf((Object)this.uri);
        } else if (this.binary != null) {
            try {
                Base64 encoder = new Base64();
                stringValue = new String(encoder.encode(this.binary));
            }
            catch (EncoderException ee) {
                this.log.error("Error encoding binary data", (Throwable)ee);
            }
        }
        return stringValue;
    }

    public void setValue(String value) {
        Optional valueParameter = this.getParameter(ParameterName.VALUE.toString());
        if (valueParameter.isPresent() && "URL".equalsIgnoreCase(((Parameter)valueParameter.get()).getValue())) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Base64 decoder = new Base64();
        try {
            this.binary = decoder.decode(value.getBytes());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationResult validate() throws ValidationException {
        return LOGO.validate((Object)this);
    }

    protected PropertyFactory<Logo> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Logo> {
        public Factory() {
            super(new String[]{PropertyName.LOGO.toString()});
        }

        public Logo createProperty(ParameterList params, String value) {
            return new Logo(params, value);
        }

        @Override
        public Logo createProperty(Group group, ParameterList params, String value) {
            return null;
        }
    }
}

