package org.mobicents.ussdgateway.rules;

import java.io.Serializable;

/**
 * Acts as Fact for Rules
 * 
 * @author amit bhayani
 * 
 */
public class Call implements Serializable {
	// Initial string, its like #123*
	private String ussdString;

	private boolean isSip;
	private boolean isHttp;
	private boolean isSmpp;

	private String sipProxy;
	private String sipTo;
	private int sipPort;

	// to be used with other protocols
	private String genericUrl;

	public Call(String ussdString) {
		this.ussdString = ussdString;
	}

	public String getUssdString() {
		return ussdString;
	}

	public boolean isSip() {
		return isSip;
	}

	public void setSip(boolean isSip) {
		this.isSip = isSip;
	}

	public boolean isHttp() {
		return isHttp;
	}

	public void setHttp(boolean isHttp) {
		this.isHttp = isHttp;
	}

	public boolean isSmpp() {
		return isSmpp;
	}

	public void setSmpp(boolean isSmpp) {
		this.isSmpp = isSmpp;
	}

	public String getSipProxy() {
		return sipProxy;
	}

	public void setSipProxy(String sipProxy) {
		this.sipProxy = sipProxy;
	}

	public String getSipTo() {
		return sipTo;
	}

	public void setSipTo(String sipTo) {
		this.sipTo = sipTo;
	}

	public int getSipPort() {
		return sipPort;
	}

	public void setSipPort(int sipPort) {
		this.sipPort = sipPort;
	}

	/**
	 * @return the genericUrl
	 */
	public String getGenericUrl() {
		return genericUrl;
	}

	/**
	 * @param genericUrl
	 *            the genericUrl to set
	 */
	public void setGenericUrl(String genericUrl) {
		this.genericUrl = genericUrl;
	}
}
