package org.mobicents.ussdgateway.slee;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;

import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MapServiceFactory;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSIndication;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.resource.map.DialogAccept;
import org.mobicents.slee.resource.map.DialogClose;
import org.mobicents.slee.resource.map.DialogDelimiter;
import org.mobicents.slee.resource.map.DialogNotice;
import org.mobicents.slee.resource.map.DialogProviderAbort;
import org.mobicents.slee.resource.map.DialogReject;
import org.mobicents.slee.resource.map.DialogUserAbort;
import org.mobicents.slee.resource.map.MAPContextInterfaceFactory;
import org.mobicents.ussdgateway.ObjectFactory;
import org.mobicents.ussdgateway.USSDAbort;
import org.mobicents.ussdgateway.USSDRequest;
import org.mobicents.ussdgateway.USSDResponse;
import org.mobicents.ussdgateway.rules.Call;

public abstract class ChildSbb implements Sbb,ChildInterface{

	protected SbbContextExt sbbContext;

	// /////////////////
	// MAP RA Stuff //
	// /////////////////

	protected static final ResourceAdaptorTypeID mapRATypeID = new ResourceAdaptorTypeID("MAPResourceAdaptorType", "org.mobicents", "2.0");
	protected static final String mapRaLink = "MAPRA";
	
	

	protected MAPContextInterfaceFactory mapAcif;
	protected MAPProvider mapProvider;
	protected MapServiceFactory mapServiceFactory;

	////////////////
	// JAXB STUFF //
	////////////////
	protected static final JAXBContext jAXBContext = initJAXBContext();
	protected static final ObjectFactory objectFactory = new ObjectFactory();
	protected Tracer logger;

	
	
	////////////////////////
	// MAP Stuff handlers //
	////////////////////////
	
	/**
	 * MAP USSD Event Handlers
	 */

	public void onProcessUnstructuredSSRequest(ProcessUnstructuredSSIndication evt, ActivityContextInterface aci) {

		try {

			long invokeId = evt.getInvokeId();
			// this.setInvokeId(invokeId);

			String ussdString = evt.getUSSDString().getString();
			// this.setUssdString(ussdString);

			int codingScheme = evt.getUSSDDataCodingScheme() & 0xFF;
			String msisdn = evt.getMSISDNAddressString().getAddress();

			if (this.checkProtocolConnection()) {
				if (this.logger.isFineEnabled()) {
					this.logger.fine("Received PROCESS_UNSTRUCTURED_SS_REQUEST_INDICATION for MAP Dialog Id " + evt.getMAPDialog().getDialogId()+", with active session, terminating both.");
				}
				MAPUserAbortChoice mapUsrAbrtCho = this.mapServiceFactory.createMAPUserAbortChoice();
				mapUsrAbrtCho.setUserSpecificReason();

				try {
					evt.getMAPDialog().abort(mapUsrAbrtCho);
				} catch (MAPException e) {
					this.logger.severe("Error while aborting MAPDialog ", e);
				}
				terminateProtocolConnection();
			} else {
				if (this.logger.isFineEnabled()) {
					this.logger.fine("Received PROCESS_UNSTRUCTURED_SS_REQUEST_INDICATION for MAP Dialog Id " + evt.getMAPDialog().getDialogId());
				}

				USSDRequest req = this.objectFactory.createUSSDRequest();
				req.setInvokeId((int) invokeId);
				req.setMsisdn(msisdn);
				req.setUssdCoding(codingScheme);
				req.setUssdString(ussdString);
				MAPDialogSupplementary mapDialog = evt.getMAPDialog();
				req.setDialogId(mapDialog.getDialogId());
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				// akward
				JAXBElement<USSDRequest> jxb = this.objectFactory.createRequest(req);
				jAXBContext.createMarshaller().marshal(jxb, bos);

				String xmlRequest = new String(bos.toByteArray());

				this.sendUssdData(xmlRequest,req);
			}

		} catch (Exception e) {
			logger.severe("Error while sending SIP message", e);
		}

	}

	
	public void onUnstructuredSSRequest(UnstructuredSSIndication evt,
			ActivityContextInterface aci) {

		if (this.logger.isFineEnabled()) {
			this.logger
					.fine("Received UNSTRUCTURED_SS_REQUEST_INDICATION for MAP Dialog Id "
							+ evt.getMAPDialog().getDialogId());
		}

		MAPDialog mapDialog = evt.getMAPDialog();
		USSDString ussdStrObj = evt.getUSSDString();
		
		if (!this.checkProtocolConnection()) {
			if (this.logger.isWarningEnabled()) {
				this.logger
						.warning("Received UnstructuredSSIndication event with USSDString = "
								+ ussdStrObj.getString()
								+ ", but there is no corresponding Session");
			}
			MAPUserAbortChoice mapUsrAbrtCho = this.mapServiceFactory
					.createMAPUserAbortChoice();
			mapUsrAbrtCho.setUserSpecificReason();

			try {
				mapDialog.abort(mapUsrAbrtCho);
			} catch (MAPException e) {
				this.logger.severe("Error while aborting MAPDialog ", e);
			}
			terminateProtocolConnection();
		} else {
			try {
				long invokeId = evt.getInvokeId();
				String ussdString = evt.getUSSDString().getString();
				int codingScheme = evt.getUSSDDataCodingScheme() & 0xFF;


				USSDRequest req = this.objectFactory.createUSSDRequest();
				req.setInvokeId((int) invokeId);
				req.setUssdCoding(codingScheme);
				req.setUssdString(ussdString);
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				// akward
				JAXBElement<USSDRequest> jxb = this.objectFactory
						.createRequest(req);
				jAXBContext.createMarshaller().marshal(jxb, bos);

				String xmlRequest = new String(bos.toByteArray());

				sendUssdData(xmlRequest,req);
			} catch (Exception e) {
				this.logger.severe("Error while sending INFO SIP Request", e);
			}
		}

	}

	/**
	 * MAP Dialog Event Handlers
	 */

	public void onDialogDelimiter(DialogDelimiter evt,
			ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogDelimiter" + evt);
		}
	}

	public void onDialogAccept(DialogAccept evt, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogAccept" + evt);
		}
	}

	public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogReject" + evt);
		}

		// TODO : Should we add any xml content?
		this.terminateProtocolConnection();
	}

	public void onDialogUserAbort(DialogUserAbort evt,
			ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogUserAbort" + evt);
		}

		// TODO : Should we add any xml content?
		this.terminateProtocolConnection();
	}

	public void onDialogProviderAbort(DialogProviderAbort evt,
			ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogProviderAbort" + evt);
		}

		// TODO : Should we add any xml content?
		this.terminateProtocolConnection();
	}

	public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogClose" + evt);
		}

		// TODO : Should we add any xml content?
		this.terminateProtocolConnection();
	}

	public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
		if (logger.isInfoEnabled()) {
			this.logger.info("Rx :  onDialogNotice" + evt);
		}
	}
	
	
	////////////////////////////
	// Abstract child methods //
	////////////////////////////
	/**
	 * Termiantes specific protocol connection if any exists.
	 */
	protected abstract void terminateProtocolConnection();
	/**
	 * Creates connection to other side via specific protocol if one does not exist and sends request
	 * @param xmlRequest
	 * @throws Exception 
	 */
	protected abstract void sendUssdData(String ussdData,USSDRequest req) throws Exception;

	/**
	 * Checks if there is specific protocol connection alive.
	 * @return
	 */
	protected abstract boolean checkProtocolConnection();
	
	// /////////////////
	// Sbb callbacks //
	// /////////////////
	public void setSbbContext(SbbContext sbbContext) {
		this.sbbContext = (SbbContextExt) sbbContext;
		this.logger = sbbContext
				.getTracer("USSD-CHILD-" + getClass().getName());

		try {


			this.mapAcif = (MAPContextInterfaceFactory) this.sbbContext.getActivityContextInterfaceFactory(mapRATypeID);
			this.mapProvider = (MAPProvider) this.sbbContext.getResourceAdaptorInterface(mapRATypeID, mapRaLink);
			this.mapServiceFactory = this.mapProvider.getMapServiceFactory();

		} catch (Exception ne) {
			logger.severe("Could not set SBB context:", ne);
		}
	}

	public void unsetSbbContext() {
		this.sbbContext = null;
		this.logger = null;
	}

	public void sbbCreate() throws CreateException {
	}

	public void sbbPostCreate() throws CreateException {
	}

	public void sbbActivate() {
	}

	public void sbbPassivate() {
	}

	public void sbbLoad() {
	}

	public void sbbStore() {
	}

	public void sbbRemove() {
	}

	public void sbbExceptionThrown(Exception exception, Object object,
			ActivityContextInterface activityContextInterface) {
	}

	public void sbbRolledBack(RolledBackContext rolledBackContext) {
	}

	// ///////
	// CMP //
	// ///////

	public abstract void setCall(Call call);

	public abstract Call getCall();

	// //////////////////
	// SBB LO methods //
	// //////////////////

	public void setCallFact(Call call) {
		this.setCall(call);
	}
	
	/////////////////////////////////////////////////
	// protected child stuff, to be used in parent //
	/////////////////////////////////////////////////

	protected void abort(USSDAbort ussdAbort) {
		// TODO get the reason
		MAPUserAbortChoice mapUserAbortChoice = this.mapServiceFactory
				.createMAPUserAbortChoice();
		// As of now hardcoded
		mapUserAbortChoice.setUserSpecificReason();
		try {
			this.getMAPDialog().abort(mapUserAbortChoice);
		} catch (MAPException e) {
			logger.severe("Error while aborting MAPDialog ", e);
		}
	}
	

	protected void addUnstructuredSSRequest(USSDRequest req)
			throws ParseException {

		byte ussdDataCodingScheme;
		USSDString ussdString;
		
		ussdString = this.mapServiceFactory.createUSSDString(req
				.getUssdString());
		ussdDataCodingScheme = (byte) (req.getUssdCoding() & 0xFF);
		
		boolean response = req.isResult();
		boolean lastResponse = req.isLastResult();
		
		try {
			if(!response)
			{
			// FIXME: msisdn ?
			((MAPDialogSupplementary) this.getMAPDialog())
					.addUnstructuredSSRequest(ussdDataCodingScheme, ussdString);

			this.getMAPDialog().send();
			}else
			{
				((MAPDialogSupplementary) this.getMAPDialog())
				.addUnstructuredSSResponse(req.getInvokeId()
						, lastResponse, ussdDataCodingScheme, ussdString);
				
				
			}
		} catch (MAPException e) {
			logger.severe("Error while sending UnstructuredSSRequest ", e);
		}

	}

	protected void addUnstructuredSSResponse(USSDResponse res)
			throws ParseException {
		//called for response which ends dialog.
		long invokeId;
		boolean lastResult;
		byte ussdDataCodingScheme;
		USSDString ussdString;

		invokeId = res.getInvokeId() & 0xFF;
		lastResult = true; // is this true always ?
		
		ussdDataCodingScheme = (byte) (res.getUssdCoding() & 0xFF);
		ussdString = this.mapServiceFactory.createUSSDString(res
				.getUssdString());

		try {
			 this.getMAPDialog().addUnstructuredSSResponse(invokeId, lastResult,
							ussdDataCodingScheme, ussdString);

			// check for end condition
		
				this.getMAPDialog().send();
				//this.getMAPDiallog().close(true); ?? lol
		} catch (MAPException e) {
			logger.severe("Error while sending UnstructuredSSRequest ", e);
		}

	}
	
	protected MAPDialogSupplementary getMAPDialog() {
		MAPDialogSupplementary mapDialog = null;

		ActivityContextInterface[] acis = this.sbbContext.getActivities();
		for (ActivityContextInterface aci : acis) {
			Object activity = aci.getActivity();
			if (activity instanceof MAPDialogSupplementary) {
				return (MAPDialogSupplementary) activity;
			}
		}

		return mapDialog;
	}


	protected static JAXBContext initJAXBContext() {
		try {
			return JAXBContext.newInstance("org.mobicents.ussdgateway");
		} catch (JAXBException e) {
			// logger.severe("unable to init jaxb context",e);
			e.printStackTrace();
			return null;
		}
	}

}
