package org.mobicents.ussdgateway.slee;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;

import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.runtime.StatelessKnowledgeSession;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSIndication;
import org.mobicents.protocols.ss7.map.api.service.supplementary.USSDString;
import org.mobicents.slee.resource.map.DialogRequest;
import org.mobicents.ussdgateway.rules.Call;

/**
 * 
 * @author amit bhayani
 */
public abstract class ParentSbb implements Sbb {

	private SbbContext sbbContext;

	private Tracer logger;

	private KnowledgeBase kbase;
	private KnowledgeAgent kagent;

	/** Creates a new instance of CallSbb */
	public ParentSbb() {
	}

	public void setSbbContext(SbbContext sbbContext) {
		this.sbbContext = sbbContext;
		this.logger = sbbContext.getTracer("USSD-Parent");
		try {
			Context ctx = (Context) new InitialContext();
			kagent = (KnowledgeAgent) ctx.lookup("java:/mobicents/ussdgateway/rulesservice");
		} catch (Exception ne) {
			logger.severe("Could not set SBB context:", ne);
		}
	}

	// THIS IS USED FOR TESTING
	// public void onServiceStarted(ServiceStartedEvent evt,
	// ActivityContextInterface aci) {
	// logger.info("Received ServiceStartedEvent ");
	// Call call = new Call();
	// call.setUssdString("*123#");
	//
	// StatelessKnowledgeSession statelessksession = this.kbase
	// .newStatelessKnowledgeSession();
	//
	// statelessksession.execute(call);
	//
	// logger.info("Call Type = " + call.isSip());
	// logger.info("Proxy IP = " + call.getSipProxy());
	// logger.info("SIP To = " + call.getSipTo());
	// }

	public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
		if (logger.isFineEnabled()) {
			this.logger.fine("New MAP Dialog. Received event MAPOpenInfo " + evt);
		}
	}

	public void onProcessUnstructuredSSRequest(ProcessUnstructuredSSIndication evt, ActivityContextInterface aci) {

		try {

			USSDString ussdStrObj = evt.getUSSDString();
			String ussdStr = ussdStrObj.getString();

			if (this.logger.isFineEnabled()) {
				this.logger.fine("Received PROCESS_UNSTRUCTURED_SS_REQUEST_INDICATION event USSDString = " + ussdStr);
			}

			Call call = new Call(ussdStr);

			StatelessKnowledgeSession statelessksession = this.kbase.newStatelessKnowledgeSession();

			statelessksession.execute(call);

			if (call.isSip()) {
				// Create child of SIP SBB and call local method
				
				ChildRelation relation = this.getSipSbb();
				ChildSbbLocalObject child = (ChildSbbLocalObject) relation.create();
				child.setCallFact(call);
				forwardEvent(child, aci, evt);
			} else if (call.isHttp()) {
				// Create child of Http SBB and call local method
				
				ChildRelation relation = this.getHttpClientSbb();
				ChildSbbLocalObject child = (ChildSbbLocalObject) relation.create();
				child.setCallFact(call);
				forwardEvent(child, aci, evt);
			} else if (call.isSmpp()) {
				
				// Create child of SMPP SBB and call local method
				// TODO :
			} else {
				// TODO : Decline
				
			}
		} catch (Exception e) {
			logger.severe("Unexpected error: ", e);
		}

	}

	private void forwardEvent(SbbLocalObject child, ActivityContextInterface aci, ProcessUnstructuredSSIndication evt) {
		try {
			aci.attach(child);
			aci.detach(sbbContext.getSbbLocalObject());
		} catch (Exception e) {
			logger.severe("Unexpected error: ", e);
		}
	}

	public abstract ChildRelation getSipSbb();

	public abstract ChildRelation getHttpClientSbb();

	public void unsetSbbContext() {
		this.sbbContext = null;
		this.logger = null;
	}

	public void sbbCreate() throws CreateException {
		kbase = kagent.getKnowledgeBase();
		if (this.logger.isFineEnabled()) {
			this.logger.fine("Created KnowledgeBase");
		}
	}

	public void sbbPostCreate() throws CreateException {

	}

	public void sbbActivate() {
	}

	public void sbbPassivate() {
	}

	public void sbbLoad() {
	}

	public void sbbStore() {
	}

	public void sbbRemove() {
	}

	public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
	}

	public void sbbRolledBack(RolledBackContext rolledBackContext) {
	}
}
