package org.mobicents.ussdgateway.slee.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.slee.ActivityContextInterface;
import javax.slee.SbbContext;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import net.java.client.slee.resource.http.HttpClientActivity;
import net.java.client.slee.resource.http.HttpClientActivityContextInterfaceFactory;
import net.java.client.slee.resource.http.HttpClientResourceAdaptorSbbInterface;
import net.java.client.slee.resource.http.event.ResponseEvent;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.mobicents.ussdgateway.USSDAbort;
import org.mobicents.ussdgateway.USSDRequest;
import org.mobicents.ussdgateway.USSDResponse;
import org.mobicents.ussdgateway.rules.Call;
import org.mobicents.ussdgateway.slee.ChildSbb;

/**
 * 
 * @author amit bhayani
 */
public abstract class HttpClientSbb  extends ChildSbb{

	// ///////////////////////
	// Query params we put //
	// ///////////////////////
	public static final String QUERY_ID = "id";
	public static final String QUERY_CODING = "coding";
	public static final String QUERY_MSISDN = "msisdn";
	public static final String QUERY_IMSI = "IMSI";

	private static final String CONTENT_TYPE = "text";
	private static final String CONTENT_SUB_TYPE = "xml";

	private static final String ACCEPTED_CONTENT_TYPE = CONTENT_TYPE + "/" + CONTENT_SUB_TYPE;




	// /////////////////
	// HTTP RA Stuff //
	// /////////////////
	private static final ResourceAdaptorTypeID httpRATypeID = new ResourceAdaptorTypeID("HttpClientResourceAdaptorType", "org.mobicents", "4.0");
	private static final String httpRaLink = "HttpClientResourceAdaptor";

	private HttpClientActivityContextInterfaceFactory httpClientActivityContextInterfaceFactory;
	private HttpClientResourceAdaptorSbbInterface httpProvider;



	/** Creates a new instance of CallSbb */
	public HttpClientSbb() {
	}

	// /////////////////
	// HTTP Handlers //
	// /////////////////

	public void onResponseEvent(ResponseEvent event, ActivityContextInterface aci) {
		HttpResponse response = event.getHttpResponse();
		StatusLine statusLine = response.getStatusLine();

		int statusCode = statusLine.getStatusCode();
		HttpClientActivity httpClientActivity = ((HttpClientActivity)aci.getActivity());
		switch (statusCode) {

		case 200:
			try {
				byte[] xmlContent = null;
				if (response.getEntity() != null) {
					xmlContent = getResultData(response.getEntity());
					logger.info("Received answer content: \n"+new String(xmlContent));
				}
				if (xmlContent != null) {

					Unmarshaller um = this.jAXBContext.createUnmarshaller();
					JAXBElement o = (JAXBElement) um.unmarshal(new ByteArrayInputStream(xmlContent));
					if (o.getDeclaredType().equals(USSDRequest.class)) {
						this.addUnstructuredSSRequest((USSDRequest) o.getValue());
					} else if (o.getDeclaredType().equals(USSDResponse.class)) {
						httpClientActivity.endActivity();
						aci.detach(this.sbbContext.getSbbLocalObject());
						this.addUnstructuredSSResponse((USSDResponse) o.getValue());
						//finished, need to kill session?
						
					} else if (o.getDeclaredType().equals(USSDAbort.class)) {
						httpClientActivity.endActivity();
						this.abort((USSDAbort) o.getValue());
						//finsihed, need to kill session?
						
					}

				}

			} catch (Exception e) {
				super.logger.severe("Error while processing 2xx", e);
			}
			break;

		default:
			
			httpClientActivity.endActivity();
			aci.detach(this.sbbContext.getSbbLocalObject());
			USSDAbort abort = this.objectFactory.createUSSDAbort();
			this.abort(abort);
			
			break;

		}

	}

	public void setSbbContext(SbbContext sbbContext) {
		super.setSbbContext(sbbContext);
		try {
			this.httpClientActivityContextInterfaceFactory = (HttpClientActivityContextInterfaceFactory) this.sbbContext
					.getActivityContextInterfaceFactory(httpRATypeID);
			this.httpProvider = (HttpClientResourceAdaptorSbbInterface) this.sbbContext.getResourceAdaptorInterface(httpRATypeID, httpRaLink);

			
		} catch (Exception ne) {
			super.logger.severe("Could not set SBB context:", ne);
		}
	}

	public void unsetSbbContext() {
		this.sbbContext = null;
		super.unsetSbbContext();
	}


	private HttpClientActivity getHTTPClientActivity() {
		ActivityContextInterface[] acis = this.sbbContext.getActivities();
		for (ActivityContextInterface aci : acis) {
			Object activity = aci.getActivity();
			if (activity instanceof HttpClientActivity) {
				return (HttpClientActivity) activity;
			}
		}
		return null;
	}

	private void doPost(HttpClientActivity httpClientActivity, String url, long dialogId, int coding, String msisdn, String imsi, byte[] content) {

		// make life easier, encode part of ussd data in query params, so REST
		// can do better job :)
		Map<String, String> queryParameters = new HashMap<String, String>();
		queryParameters.put(QUERY_ID, Long.toString(dialogId));
//		queryParameters.put(QUERY_CODING, Integer.toString(coding));
//		if (msisdn != null)
//			queryParameters.put(QUERY_MSISDN, msisdn);
//		if (imsi != null)
//			queryParameters.put(QUERY_IMSI, imsi);
		HttpPost uriRequest = createRequest(url, queryParameters, ACCEPTED_CONTENT_TYPE, null);

		// NOTE: here we assume that its text/xml utf8 encoded... bum.
		pushContent(uriRequest, ACCEPTED_CONTENT_TYPE, "utf-8", new ByteArrayInputStream(content));

		httpClientActivity.execute(uriRequest,null);
	}

	private String encode(String url, Map<String, String> queryParameters) {
		// seriously... 
		if (queryParameters == null && queryParameters.size() == 0)
			return url;

		url = url + "?";
		int encCount = 0;
		Iterator<Map.Entry<String, String>> vks = queryParameters.entrySet().iterator();
		while (vks.hasNext()) {

			Map.Entry<String, String> e = vks.next();
			url += e.getKey() + "=" + e.getValue();
			encCount++;
			if (encCount < queryParameters.size()) {
				url += "&";
			}

		}

		return url;
	}

	/**
	 * @param method
	 * @param restID
	 * @param uri
	 * @param queryParameters
	 * @param acceptedContent
	 * @param headers
	 * @return
	 */
	private HttpPost createRequest(String uri, Map<String, String> queryParameters, String acceptedContent, Header[] headers) {

		if (uri == null) {
			throw new NullPointerException("URI mst not be null.");
		}
		String requestURI = uri;
		if (queryParameters != null) {
			requestURI = encode(requestURI, queryParameters);
		}
		HttpPost request = new HttpPost(uri);

		if (acceptedContent != null) {
			BasicHeader acceptedContentHeader = new BasicHeader("Accept", acceptedContent);
			request.addHeader(acceptedContentHeader);
		}
		if (headers != null) {
			for (Header h : headers) {
				request.addHeader(h);
			}
		}

		return request;
	}

	private void pushContent(HttpUriRequest request, String contentType, String contentEncoding, InputStream content) {

		// TODO: check other preconditions?
		if (contentType != null && content != null && request instanceof HttpEntityEnclosingRequest) {
			BasicHttpEntity entity = new BasicHttpEntity();
			entity.setContent(content);
			if (contentEncoding != null)
				entity.setContentEncoding(contentEncoding);
			entity.setContentType(contentType);
			HttpEntityEnclosingRequest rr = (HttpEntityEnclosingRequest) request;
			rr.setEntity(entity);
		}

	}

	private byte[] getResultData(HttpEntity entity) {

//		try {
//			
//			ByteArrayOutputStream bos = new ByteArrayOutputStream();
//			if(entity.isStreaming())
//			{
//				entity.writeTo(bos);
//			}else
//			{
//				InputStream is = entity.getContent();
//				
//				while (is.available() > 0) {
//					byte[] b = new byte[is.available()];
//					is.read(b);
//					 bos.write(b);
//				}
//			}
//			
//
//			
//			return bos.toByteArray();
//		} catch (Exception e) {
//			super.logger.severe("Failed to fetcg", e);
//		}
//		return null;
		try {
			return EntityUtils.toByteArray(entity);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	///////////////////////////
	// Client abstract stuff //
	///////////////////////////
	
	@Override
	protected boolean checkProtocolConnection() {
		return this.getHTTPClientActivity()!=null;
	}

	@Override
	protected void sendUssdData(String ussdData,USSDRequest req) throws Exception {
		HttpClientActivity httpClientActivity = this.getHTTPClientActivity();
		if(httpClientActivity == null)
		{
			
			httpClientActivity= this.httpProvider.createHttpClientActivity(false,null);
			// combo
			this.httpClientActivityContextInterfaceFactory.getActivityContextInterface(httpClientActivity).attach(this.sbbContext.getSbbLocalObject());
			logger.info("Created HTTP Activity '"+httpClientActivity+"' ");
		}
		
		int codingScheme = req.getUssdCoding() & 0xFF;
		String msisdn = req.getMsisdn();
		String imsi = null;
		
		Call call = this.getCall();
		
		// combo
		this.httpClientActivityContextInterfaceFactory.getActivityContextInterface(httpClientActivity).attach(this.sbbContext.getSbbLocalObject());
		String url = call.getGenericUrl();

		doPost(httpClientActivity, url, getMAPDialog().getDialogId(), codingScheme, msisdn, imsi, ussdData.getBytes() );
	}

	@Override
	protected void terminateProtocolConnection() {
		if(this.getHTTPClientActivity()!=null)
		{
			this.getHTTPClientActivity().endActivity();
		}
	}
	
	

}
