package org.mobicents.ussdgateway.slee.sip;

import gov.nist.javax.sip.header.Via;

import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.util.ArrayList;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbContext;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;

import org.mobicents.ussdgateway.USSDAbort;
import org.mobicents.ussdgateway.USSDRequest;
import org.mobicents.ussdgateway.USSDResponse;
import org.mobicents.ussdgateway.rules.Call;
import org.mobicents.ussdgateway.slee.ChildSbb;

/**
 * 
 * @author amit bhayani
 */
public abstract class SipSbb extends ChildSbb {

	// Get the transport
	private final String TRANSPORT = "udp";

	private static final String FROM = "11111";
	private static final String FROM_DISPLAY_NAME = "MobicentsUSSDGateway";

	private static final String CONTENT_TYPE = "text";
	private static final String CONTENT_SUB_TYPE = "xml";

	private static String ipAddress;
	private static int port;
	private static Address fromAddress;

	// /////////////////
	// MAP RA Stuff //
	// /////////////////

	private static final ResourceAdaptorTypeID sipRATypeID = new ResourceAdaptorTypeID(
			"JAIN SIP", "javax.sip", "1.2");
	private static final String sipRALink = "SipRA";
	private SleeSipProvider provider;

	private AddressFactory addressFactory;
	private HeaderFactory headerFactory;
	private MessageFactory messageFactory;
	private SipActivityContextInterfaceFactory sipActConIntFac;

	/** Creates a new instance of CallSbb */
	public SipSbb() {
	}

	// //////////////////////
	// SIP Event handlers //
	// //////////////////////

	public void onTryingRespEvent(ResponseEvent event,
			ActivityContextInterface aci) {
		if (this.logger.isFineEnabled()) {
			this.logger.fine("Received the TRYING Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}
	}

	public void onProvisionalRespEvent(ResponseEvent event,
			ActivityContextInterface aci) {
		if (this.logger.isFineEnabled()) {
			this.logger.fine("Received the PROVISIONAL Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}
	}

	public void onSuccessRespEvent(ResponseEvent event,
			ActivityContextInterface aci) {

		if (this.logger.isFineEnabled()) {
			this.logger.fine("Received the SUCCESS Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}

		try {

			Response response = event.getResponse();
			Dialog dialog = event.getDialog();
			int status = response.getStatusCode();

			if (logger.isFineEnabled()) {
				logger.fine("Received success response event " + status);
			}
			CSeqHeader cseq = (CSeqHeader) response.getHeader(CSeqHeader.NAME);

			if (cseq.getMethod().equals(Request.INVITE)) {
				// Send ACK
				Request ack = dialog.createAck(dialog.getLocalSeqNumber());
				dialog.sendAck(ack);
			}

			byte[] xmlContent = response.getRawContent();
			if (xmlContent != null) {

				Unmarshaller um = this.jAXBContext.createUnmarshaller();
				JAXBElement o = (JAXBElement) um
						.unmarshal(new ByteArrayInputStream(xmlContent));
				if (o.getDeclaredType().equals(USSDRequest.class)) {
					this.addUnstructuredSSRequest((USSDRequest) o.getValue());
				} else if (o.getDeclaredType().equals(USSDResponse.class)) {
					this.addUnstructuredSSResponse((USSDResponse) o.getValue());
				} else if (o.getDeclaredType().equals(USSDAbort.class)) {
					this.abort((USSDAbort) o.getValue());
				}

			}

		} catch (Exception e) {
			logger.severe("Error while processing 2xx", e);
		}
	}

	public void onGlobalFailureRespEvent(ResponseEvent event,
			ActivityContextInterface aci) {
		if (this.logger.isWarningEnabled()) {
			this.logger.warning("Received GLOBAL_FAILURE Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}
		// TODO: Add the MAPuserChoice
		USSDAbort abort = this.objectFactory.createUSSDAbort();
		this.abort(abort);
	}

	public void onClientErrorRespEvent(ResponseEvent event,
			ActivityContextInterface ac) {
		if (this.logger.isWarningEnabled()) {
			this.logger.warning("Received CLIENT_ERROR Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}
		// TODO: Add the MAPuserChoice
		USSDAbort abort = this.objectFactory.createUSSDAbort();
		this.abort(abort);
	}

	public void onServerErrorRespEvent(ResponseEvent event,
			ActivityContextInterface ac) {
		if (this.logger.isWarningEnabled()) {
			this.logger.warning("Received SERVER_ERROR Response "
					+ event.getResponse().getStatusCode()
					+ " For SIP Dialog Id " + this.getDialog().getDialogId());
		}
		// TODO: Add the MAPuserChoice
		USSDAbort abort = this.objectFactory.createUSSDAbort();
		this.abort(abort);
	}

	public void onCallTerminated(RequestEvent evt, ActivityContextInterface aci) {

		if (this.logger.isFineEnabled()) {
			this.logger.fine("Received BYE Request For SIP Dialog Id "
					+ this.getDialog().getDialogId());
		}

		ServerTransaction tx = evt.getServerTransaction();
		Request request = evt.getRequest();

		try {
			Response response = messageFactory.createResponse(Response.OK,
					request);
			tx.sendResponse(response);
		} catch (Exception e) {
			logger.severe("Error while sending DLCX ", e);
		}
	}

	

	private DialogActivity getDialog() {
		ActivityContextInterface[] acis = this.sbbContext.getActivities();
		for (ActivityContextInterface aci : acis) {
			if (aci.getActivity() instanceof DialogActivity) {
				return (DialogActivity) aci.getActivity();
			}
		}

		return null;
	}

//	private void respond(RequestEvent evt, int cause) {
//		//TODO: use this ??
//		Request request = evt.getRequest();
//		ServerTransaction tx = evt.getServerTransaction();
//		try {
//			Response response = messageFactory.createResponse(cause, request);
//			tx.sendResponse(response);
//		} catch (Exception e) {
//			logger.warning("Unexpected error: ", e);
//		}
//	}
//
//	private ServerTransaction getServerTransaction() {
//		ActivityContextInterface[] activities = sbbContext.getActivities();
//		for (ActivityContextInterface activity : activities) {
//			if (activity.getActivity() instanceof ServerTransaction) {
//				return (ServerTransaction) activity.getActivity();
//			}
//		}
//		return null;
//	}

	public void setSbbContext(SbbContext sbbContext) {
		super.setSbbContext(sbbContext);

		try {


			// initialize SIP API
			this.sipActConIntFac =  (SipActivityContextInterfaceFactory)super.sbbContext.getActivityContextInterfaceFactory(sipRATypeID);
			this.provider =  (SleeSipProvider) super.sbbContext.getResourceAdaptorInterface(sipRATypeID, sipRALink);
			this.mapServiceFactory = this.mapProvider.getMapServiceFactory();

			this.ipAddress = this.provider.getListeningPoint(TRANSPORT)
					.getIPAddress();
			this.port = this.provider.getListeningPoint(TRANSPORT).getPort();

			addressFactory = provider.getAddressFactory();
			headerFactory = provider.getHeaderFactory();
			messageFactory = provider.getMessageFactory();
			

			// some vars

			SipURI fromSipUri = addressFactory.createSipURI(FROM,
					this.ipAddress);

			fromAddress = addressFactory.createAddress(fromSipUri);
			fromAddress.setDisplayName(FROM_DISPLAY_NAME);

		} catch (Exception ne) {
			logger.severe("Could not set SBB context:", ne);
		}
	}

	private String generateTag() {
		String tag = new Integer((int) (Math.random() * 10000)).toString();
		return tag;
	}

	private ViaHeader getLocalVia(String branch) throws ParseException,
			InvalidArgumentException {
		ViaHeader viaHeader = headerFactory.createViaHeader(this.ipAddress,
				this.port, TRANSPORT, branch);
		viaHeader.setParameter(Via.RPORT, "5060");
		return viaHeader;
	}

	private ContactHeader createLocalContactHeader() throws ParseException {
		SipURI contactURI = this.addressFactory.createSipURI(FROM,
				this.ipAddress);
		contactURI.setPort(this.port);
		Address contactAddress = this.addressFactory.createAddress(contactURI);
		contactAddress.setDisplayName(FROM_DISPLAY_NAME);
		ContactHeader contactHeader = this.headerFactory
				.createContactHeader(contactAddress);
		return contactHeader;
	}

	private Request buildInvite(Call call, String content) throws Exception {
		SipURI toSipUri = addressFactory.createSipURI(call.getSipTo(),
				call.getSipProxy());

		Address toAddress = this.addressFactory.createAddress(toSipUri);

		// From Header:
		FromHeader fromHeader = headerFactory.createFromHeader(fromAddress,
				generateTag());

		// To header:
		ToHeader toHeader = headerFactory.createToHeader(toAddress, null);

		// Set the sequence number for the invite
		CSeqHeader cseqHeader = headerFactory.createCSeqHeader(1l,
				Request.INVITE);

		// Create the Via header and add to an array list
		ArrayList viaHeadersList = new ArrayList();
		viaHeadersList.add(getLocalVia(null));

		MaxForwardsHeader maxForwardsHeader = headerFactory
				.createMaxForwardsHeader(70);

		CallIdHeader callIdHeader = this.provider.getNewCallId();

		Request request = this.messageFactory.createRequest(toSipUri,
				Request.INVITE, callIdHeader, cseqHeader, fromHeader, toHeader,
				viaHeadersList, maxForwardsHeader);

		ContactHeader contactHeader = createLocalContactHeader();
		request.setHeader(contactHeader);

		// Set Content
		ContentTypeHeader contentTypeHeader = this.headerFactory
				.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
		request.setContent(content, contentTypeHeader);

		ContentLengthHeader contentLengthHeader = headerFactory
				.createContentLengthHeader(content.length());
		request.setContentLength(contentLengthHeader);

		return request;
	}

	// //////////////////////////////
	// Child abstract implemented //
	// //////////////////////////////

	protected void terminateProtocolConnection() {
		Dialog sipDialog = this.getDialog();
		
		if(sipDialog == null){
			//Most probably the Dialog between the GW and application died!
			return;
		}
		
		try {
			Request byeRequest = sipDialog.createRequest(Request.BYE);
			ClientTransaction ct = this.provider
					.getNewClientTransaction(byeRequest);
			ActivityContextInterface calleeAci = this.sipActConIntFac
					.getActivityContextInterface(ct);
			calleeAci.attach(this.sbbContext.getSbbLocalObject());
			sipDialog.sendRequest(ct);
		} catch (SipException e) {
			this.logger.severe("Error while sending BYE Request ", e);
		}
	}

	@Override
	protected void sendUssdData(String ussdData,USSDRequest req) throws Exception{

		//check for error conditions should be done elsewhere.
		if(getDialog() == null)
		{
			//initial one
			// Setup session

			// Create INVITE Request
			Request inviteReq = this.buildInvite(getCall(), ussdData);

			// get new Client Tx
			ClientTransaction inviteCt = this.provider.getNewClientTransaction(inviteReq);

			// Attach this SBB to Client Tx Activity
			ActivityContextInterface calleeAci = this.sipActConIntFac.getActivityContextInterface(inviteCt);
			calleeAci.attach(this.sbbContext.getSbbLocalObject());

			// Get Dialog
			Dialog dialog = inviteCt.getDialog();
			if (dialog != null) {
				if (this.logger.isFineEnabled()) {
					this.logger.fine("Obtained dialog from ClientTransaction : automatic dialog support on");
				}
			} else {
				// Automatic dialog support turned off
				dialog = this.provider.getNewDialog(inviteCt);
				if (this.logger.isFineEnabled()) {
					this.logger.fine("Obtained dialog for INVITE request to callee with getNewDialog");
				}
			}

			// Attach this SBB to Dialog Activity
			ActivityContextInterface calleeDialogAci = this.sipActConIntFac.getActivityContextInterface((DialogActivity) dialog);
			calleeDialogAci.attach(this.sbbContext.getSbbLocalObject());

			dialog.terminateOnBye(true);

			// Send Request
			inviteCt.sendRequest();
		}else
		{
			//subsequent messages.
			Dialog sipDialogActivity = getDialog();
			Request infoRequest = sipDialogActivity
					.createRequest(Request.INFO);
			ContentTypeHeader cth = this.headerFactory
					.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
			infoRequest.setContent(ussdData, cth);
			ClientTransaction ctx = this.provider
					.getNewClientTransaction(infoRequest);
			ActivityContextInterface ctxAci = this.sipActConIntFac
					.getActivityContextInterface(ctx);
			ctxAci.attach(this.sbbContext.getSbbLocalObject());
			sipDialogActivity.sendRequest(ctx);
		}
		
	}

	@Override
	protected boolean checkProtocolConnection() {
		return getDialog()!=null;
	}
	
	
}
