/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.mss.extension;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.Manager;
import org.jboss.arquillian.container.mobicents.api.ContainerWrapper;
import org.jboss.arquillian.container.mobicents.api.MSSContainer;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.catalina.SipStandardService;

public class ContainerManagerTool
implements ContainerWrapper {
    private MSSContainer mssContainer;
    private DeployableContainer<?> deployableContainer;

    public ContainerManagerTool(DeployableContainer<?> deployableContainer) {
        this.deployableContainer = deployableContainer;
        if (deployableContainer instanceof MSSContainer) {
            this.mssContainer = (MSSContainer)deployableContainer;
        }
    }

    public void addSipConnector(String ipAddress, int port, String transport) throws LifecycleException {
        SipConnector sipConnector = this.mssContainer.createSipConnector(ipAddress, port, transport);
        this.mssContainer.addSipConnector(sipConnector);
    }

    public void removeSipConnector(String ipAddress, int port, String transport) throws LifecycleException {
        this.mssContainer.removeSipConnector(ipAddress, port, transport);
    }

    public void removeSipConnector(SipConnector sipConnector) throws LifecycleException {
        String ipAddress = sipConnector.getIpAddress();
        int port = sipConnector.getPort();
        String transport = sipConnector.getTransport();
        this.removeSipConnector(ipAddress, port, transport);
    }

    public List<SipConnector> getSipConnectors() {
        return this.mssContainer.getSipConnectors();
    }

    public List<SipConnector> getSipConnectors(String sipConnectorString) {
        return this.mssContainer.getSipConnectors();
    }

    public void startContainer() throws LifecycleException {
        if (!this.mssContainer.isStarted()) {
            this.deployableContainer.start();
        }
    }

    public void startContainer(Properties sipStackProperties) throws UnknownHostException, org.apache.catalina.LifecycleException, LifecycleException {
        if (!this.mssContainer.isStarted()) {
            this.mssContainer.startTomcatEmbedded(sipStackProperties);
        }
    }

    public void stopContainer() throws LifecycleException {
        if (this.mssContainer.isStarted()) {
            this.deployableContainer.stop();
        }
    }

    public void restartContainer() throws LifecycleException {
        this.stopContainer();
        this.startContainer();
    }

    public void restartContainer(Properties sipStackProperties) throws LifecycleException, UnknownHostException, org.apache.catalina.LifecycleException {
        this.stopContainer();
        this.startContainer(sipStackProperties);
    }

    public Properties getSipStackProperties() {
        SipStandardService sipService = this.mssContainer.getSipStandardService();
        return sipService.getSipStackProperties();
    }

    public void setSipStackProperties(Properties sipStackProperties) {
        SipStandardService sipService = this.mssContainer.getSipStandardService();
        sipService.setSipStackProperties(sipStackProperties);
    }

    public Manager getSipStandardManager() {
        return this.mssContainer.getSipStandardManager();
    }

    public SipStandardService getSipStandardService() {
        return this.mssContainer.getSipStandardService();
    }

    public void reloadContext() throws DeploymentException {
        Archive archive = this.mssContainer.getArchive();
        this.deployableContainer.undeploy(archive);
        this.deployableContainer.deploy(archive);
    }
}

