/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.mss.extension;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.mobicents.api.SipServletsEmbeddedContainer;
import org.jboss.arquillian.container.mobicents.api.annotations.GetDeployableContainer;
import org.jboss.arquillian.container.mss.extension.ContainerManagerTool;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class ContainerProducer {
    private boolean isGetDeployableContainerAnnoPresent = false;
    private List<Field> deployableContainerFields = new ArrayList<Field>();
    private DeployableContainer<?> deployableContainer;
    private Object testInstance;

    public void executeBeforeClass(@Observes BeforeClass event, TestClass testClass) {
        Field[] fields;
        testClass = event.getTestClass();
        for (Field field : fields = testClass.getJavaClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(GetDeployableContainer.class) || !field.getType().isAssignableFrom(ContainerManagerTool.class)) continue;
            this.isGetDeployableContainerAnnoPresent = true;
            this.deployableContainerFields.add(field);
        }
    }

    public void executeAfterSetup(@Observes AfterSetup event) {
        this.deployableContainer = event.getDeployableContainer();
    }

    public void executeBeforeTest(@Observes Before event, TestClass testClass) throws IllegalArgumentException, IllegalAccessException {
        this.testInstance = event.getTestInstance();
        if (this.isGetDeployableContainerAnnoPresent) {
            ContainerManagerTool containerWrapper = new ContainerManagerTool(this.deployableContainer);
            this.setContainer(this.testInstance, containerWrapper, this.deployableContainerFields);
        }
    }

    public void setContainer(Object testInstance, ContainerManagerTool containerWrapper, List<Field> fields) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : fields) {
            Boolean flag = field.isAccessible();
            field.setAccessible(true);
            SipServletsEmbeddedContainer fieldValue = (SipServletsEmbeddedContainer)field.get(testInstance);
            if (fieldValue == null) {
                field.set(testInstance, containerWrapper);
            } else {
                field.set(testInstance, null);
            }
            field.setAccessible(flag);
        }
    }
}

