/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.mss.extension.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.mobicents.api.annotations.BeforeDeploy;
import org.jboss.arquillian.container.mobicents.api.annotations.BeforeUnDeploy;
import org.jboss.arquillian.container.mobicents.api.annotations.ConcurrencyControlMode;
import org.jboss.arquillian.container.mobicents.api.annotations.ContextParam;
import org.jboss.arquillian.container.mobicents.api.annotations.ContextParamMap;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;

public class LifecycleExecuter {
    private DeployableContainer<?> deployableContainer;
    private Object testInstance;
    @Inject
    private Instance<ArquillianDescriptor> descriptor;
    @Inject
    private Instance<ContainerController> containerController;
    private Annotation contextParam;
    private Annotation contextParamMap;
    private Annotation concurencyControl;

    public void executeBeforeDeploy(@Observes org.jboss.arquillian.container.spi.event.container.BeforeDeploy event, TestClass testClass) {
        this.execute(testClass.getMethods(BeforeDeploy.class));
    }

    public void executeAfterDeploy(@Observes AfterDeploy event, TestClass testClass) throws IllegalArgumentException, IllegalAccessException {
        this.execute(testClass.getMethods(org.jboss.arquillian.container.mobicents.api.annotations.AfterDeploy.class));
    }

    public void executeBeforeUnDeploy(@Observes org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy event, TestClass testClass) {
        this.execute(testClass.getMethods(BeforeUnDeploy.class));
    }

    public void executeAfterUnDeploy(@Observes AfterUnDeploy event, TestClass testClass) throws IllegalArgumentException, IllegalAccessException {
        this.execute(testClass.getMethods(org.jboss.arquillian.container.mobicents.api.annotations.AfterUnDeploy.class));
    }

    public void executeAfterSetup(@Observes AfterSetup event) {
        this.deployableContainer = event.getDeployableContainer();
    }

    public void executeBeforeTest(@Observes Before event, TestClass testClass) throws IllegalArgumentException, IllegalAccessException {
        boolean paramsEmpty = false;
        this.testInstance = event.getTestInstance();
        Map<Object, Object> parameters = new HashMap();
        List containerDefs = ((ArquillianDescriptor)this.descriptor.get()).getContainers();
        Iterator iter = containerDefs.iterator();
        if (this.checkForAnnotations(event)) {
            parameters = this.getParameters(event);
        }
        if (parameters.isEmpty()) {
            parameters = this.resetParameters();
            paramsEmpty = true;
        }
        while (iter.hasNext()) {
            ContainerDef containerDef = (ContainerDef)iter.next();
            String containerName = containerDef.getContainerName();
            boolean containerInManualMode = containerDef.getMode().equalsIgnoreCase("manual");
            if (!containerInManualMode && !paramsEmpty) {
                throw new UnsupportedOperationException("Container not in manual mode");
            }
            if (!containerInManualMode) continue;
            if (paramsEmpty) {
                ((ContainerController)this.containerController.get()).start(containerName, parameters);
                continue;
            }
            ((ContainerController)this.containerController.get()).start(containerName, parameters);
        }
    }

    private Map<String, String> resetParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String paramSeparator = "---";
        String valueSeparator = "-%%-";
        parameters.put("paramSeparator", paramSeparator);
        parameters.put("valueSeparator", valueSeparator);
        String paramName = "ignore_" + UUID.randomUUID().toString();
        String paramValue = "ignore_" + UUID.randomUUID().toString();
        parameters.put("contextParam", paramName + valueSeparator + paramValue);
        return parameters;
    }

    public void executeAfterTest(@Observes After event, TestClass testClass) throws IllegalArgumentException, IllegalAccessException {
        List containerDefs = ((ArquillianDescriptor)this.descriptor.get()).getContainers();
        for (ContainerDef containerDef : containerDefs) {
            if (!containerDef.getMode().equalsIgnoreCase("manual")) {
                return;
            }
            String containerName = containerDef.getContainerName();
            ((ContainerController)this.containerController.get()).stop(containerName);
        }
    }

    private boolean checkForAnnotations(Before event) {
        Boolean result = false;
        this.contextParam = event.getTestMethod().getAnnotation(ContextParam.class);
        this.contextParamMap = event.getTestMethod().getAnnotation(ContextParamMap.class);
        this.concurencyControl = event.getTestMethod().getAnnotation(ConcurrencyControlMode.class);
        if (this.contextParam != null || this.contextParamMap != null || this.concurencyControl != null) {
            result = true;
        }
        return result;
    }

    private Map<String, String> getParameters(Before event) {
        String contextParamName = null;
        String contextParamValue = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String paramSeparator = "---";
        String valueSeparator = "-%%-";
        parameters.put("paramSeparator", paramSeparator);
        parameters.put("valueSeparator", valueSeparator);
        HashMap paramMap = new HashMap();
        if (this.contextParamMap != null) {
            Field[] fields;
            String mapName = ((ContextParamMap)this.contextParamMap).value();
            for (Field field : fields = event.getTestClass().getJavaClass().getDeclaredFields()) {
                if (field.getAnnotation(ContextParamMap.class) == null || !field.getAnnotation(ContextParamMap.class).value().equals(mapName)) continue;
                try {
                    Boolean flag = field.isAccessible();
                    field.setAccessible(true);
                    paramMap = (HashMap)field.get(event.getTestInstance());
                    field.setAccessible(flag);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (paramMap.isEmpty()) {
                throw new UnsupportedOperationException("There is no declared field in the class with annotation @ContextParam\u039cap(\"" + mapName + "\") as in the test method: " + event.getTestMethod().getName());
            }
        }
        StringBuffer values = new StringBuffer();
        if (this.contextParam != null) {
            contextParamName = ((ContextParam)this.contextParam).name();
            contextParamValue = ((ContextParam)this.contextParam).value();
            values.append(contextParamName + valueSeparator + contextParamValue + paramSeparator);
        }
        if (!paramMap.isEmpty()) {
            Iterator iterator = paramMap.keySet().iterator();
            String firstKey = (String)iterator.next();
            values.append(firstKey + valueSeparator + (String)paramMap.get(firstKey));
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                values.append(paramSeparator + key + valueSeparator + (String)paramMap.get(key));
            }
        }
        if (this.contextParam != null || !paramMap.isEmpty()) {
            parameters.put("contextParam", values.toString());
        }
        if (this.concurencyControl != null) {
            parameters.put("concurrencyControl", ((ConcurrencyControlMode)this.concurencyControl).value().toString());
        }
        return parameters;
    }

    private void execute(Method[] methods) {
        if (methods == null) {
            return;
        }
        for (Method method : methods) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute method: " + method, e);
            }
        }
    }
}

