/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.arquillian.mss.mediaserver.extension;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.mobicents.arquillian.mediaserver.api.EmbeddedMediaserver;
import org.mobicents.arquillian.mediaserver.api.EndpointType;
import org.mobicents.arquillian.mediaserver.api.MediaserverStatus;
import org.mobicents.arquillian.mediaserver.api.MgcpEventListener;
import org.mobicents.arquillian.mss.mediaserver.extension.mgcp.controller.ext.MgcpControllerExt;
import org.mobicents.arquillian.mss.mediaserver.extension.mgcp.controller.ext.MgcpProviderExt;
import org.mobicents.media.core.ResourcesPool;
import org.mobicents.media.core.Server;
import org.mobicents.media.core.endpoints.impl.BridgeEndpoint;
import org.mobicents.media.core.endpoints.impl.ConferenceEndpoint;
import org.mobicents.media.core.endpoints.impl.IvrEndpoint;
import org.mobicents.media.core.endpoints.impl.PacketRelayEndpoint;
import org.mobicents.media.server.component.DspFactoryImpl;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.mgcp.controller.Controller;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.DefaultClock;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaServer;
import org.mobicents.media.server.spi.dsp.DspFactory;
import org.mobicents.media.server.spi.listener.TooManyListenersException;

public class EmbeddedMediaserverImpl
implements EmbeddedMediaserver {
    private Logger logger = Logger.getLogger(EmbeddedMediaserverImpl.class);
    protected Clock clock;
    protected Scheduler scheduler;
    protected ChannelsManager channelsManager;
    protected UdpManager udpManager;
    protected DspFactoryImpl dspFactory;
    private Controller controller;
    private ResourcesPool resourcesPool;
    private List<Endpoint> endpoints;
    private List<MgcpEventListener> mgcpEventListeners;
    private Server server;
    private String bindAddress = "127.0.0.1";
    private int controllerPort = 2427;
    private boolean isServerStarted;
    private int ivrCounter;
    private int confCounter;
    private int relayCounter;
    private int bridgeCounter;
    private MediaserverStatus status = MediaserverStatus.CREATED;
    private String id;

    public void init() throws IOException {
        if (this.status != MediaserverStatus.CREATED) {
            this.destroy();
        }
        this.clock = new DefaultClock();
        this.mgcpEventListeners = new CopyOnWriteArrayList<MgcpEventListener>();
        this.dspFactory = new DspFactoryImpl();
        this.scheduler = new Scheduler();
        this.udpManager = new UdpManager(this.scheduler);
        this.channelsManager = new ChannelsManager(this.udpManager);
        this.resourcesPool = new ResourcesPool(this.scheduler, this.channelsManager, (DspFactory)this.dspFactory);
        this.server = new Server();
        this.controller = new MgcpControllerExt();
        this.status = MediaserverStatus.INITIALIZED;
    }

    public void destroy() {
        this.clock = null;
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            for (Endpoint endpoint : this.endpoints) {
                endpoint.stop();
            }
            this.endpoints = null;
        }
        if (!this.mgcpEventListeners.isEmpty()) {
            for (MgcpEventListener listener : this.mgcpEventListeners) {
                this.unregisterListener(listener);
            }
        }
        this.endpoints = null;
        this.dspFactory = null;
        this.scheduler.stop();
        this.scheduler = null;
        this.udpManager.stop();
        this.udpManager = null;
        this.channelsManager = null;
        this.resourcesPool = null;
        this.controller.stop();
        this.controller = null;
        this.server.stop();
        this.server = null;
        this.status = MediaserverStatus.STOPPED;
    }

    public void startServer() throws Exception {
        this.logger.info((Object)"Starting server");
        if (this.status != MediaserverStatus.INITIALIZED) {
            this.init();
        }
        this.endpoints = new CopyOnWriteArrayList<Endpoint>();
        this.dspFactory.addCodec("org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Encoder");
        this.dspFactory.addCodec("org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Decoder");
        this.dspFactory.addCodec("org.mobicents.media.server.impl.dsp.audio.g711.alaw.Encoder");
        this.dspFactory.addCodec("org.mobicents.media.server.impl.dsp.audio.g711.alaw.Decoder");
        this.scheduler.setClock(this.clock);
        this.scheduler.start();
        this.udpManager.setBindAddress(this.bindAddress);
        this.udpManager.start();
        this.channelsManager.setScheduler(this.scheduler);
        this.resourcesPool = new ResourcesPool(this.scheduler, this.channelsManager, (DspFactory)this.dspFactory);
        this.server.setClock(this.clock);
        this.server.setScheduler(this.scheduler);
        this.server.setUdpManager(this.udpManager);
        this.server.setResourcesPool(this.resourcesPool);
        this.controller.setUdpInterface(this.udpManager);
        this.controller.setPort(this.controllerPort);
        this.controller.setScheduler(this.scheduler);
        this.controller.setServer((MediaServer)this.server);
        this.controller.setConfigurationByURL(this.getClass().getResource("/mgcp-conf.xml"));
        this.controller.start();
        this.isServerStarted = true;
        this.status = MediaserverStatus.STARTED;
    }

    public void registerListener(MgcpEventListener listener) {
        MgcpProviderExt provider = ((MgcpControllerExt)this.controller).getProvider();
        try {
            provider.addMgcpEventListener(listener);
            ((MgcpControllerExt)this.controller).addMgcpEventListener(listener);
            this.mgcpEventListeners.add(listener);
        }
        catch (TooManyListenersException e) {
            this.logger.debug((Object)e);
            this.stopServer();
            this.status = MediaserverStatus.FAILED;
        }
    }

    public void unregisterListener(MgcpEventListener listener) {
        MgcpProviderExt provider = ((MgcpControllerExt)this.controller).getProvider();
        try {
            provider.removeMgcpEventListener(listener);
            ((MgcpControllerExt)this.controller).removeMgcpEventListener(listener);
            this.mgcpEventListeners.remove(listener);
        }
        catch (Exception e) {
            this.logger.debug((Object)e);
            this.stopServer();
            this.status = MediaserverStatus.FAILED;
        }
    }

    public void stopServer() {
        this.logger.info((Object)"Stopping server");
        this.destroy();
        this.status = MediaserverStatus.STOPPED;
    }

    public synchronized void installEndpoint(Endpoint endpoint) {
        this.server.install(endpoint, null);
        this.endpoints.add(endpoint);
    }

    public synchronized void installEndpoint(EndpointType type, int count) {
        switch (type) {
            case IVR: {
                for (int i = 0; i < count; ++i) {
                    ++this.ivrCounter;
                    IvrEndpoint ivr = new IvrEndpoint("mobicents/ivr/" + this.ivrCounter);
                    this.installEndpoint((Endpoint)ivr);
                }
                this.status = MediaserverStatus.CONFIGURED;
                break;
            }
            case CONFERENCE: {
                for (int i = 0; i < count; ++i) {
                    ++this.confCounter;
                    ConferenceEndpoint conf = new ConferenceEndpoint("mobicents/cnf/" + this.confCounter);
                    this.installEndpoint((Endpoint)conf);
                }
                this.status = MediaserverStatus.CONFIGURED;
                break;
            }
            case PACKETRELAY: {
                for (int i = 0; i < count; ++i) {
                    ++this.relayCounter;
                    PacketRelayEndpoint relay = new PacketRelayEndpoint("mobicents/relay/" + this.relayCounter);
                    this.installEndpoint((Endpoint)relay);
                }
                this.status = MediaserverStatus.CONFIGURED;
                break;
            }
            case BRIDGE: {
                for (int i = 0; i < count; ++i) {
                    ++this.bridgeCounter;
                    BridgeEndpoint bridge = new BridgeEndpoint("mobicents/bridge/" + this.bridgeCounter);
                    this.installEndpoint((Endpoint)bridge);
                }
                break;
            }
        }
    }

    public Collection<Endpoint> getEndpoints() {
        return this.server.getEndpoints();
    }

    public synchronized void removeEndpoint(Endpoint endpoint) {
        this.server.uninstalls(endpoint.getLocalName());
        endpoint.stop();
        this.endpoints.remove(endpoint);
    }

    public synchronized void removeAllEndpoints() {
        ListIterator<Endpoint> iterator = this.endpoints.listIterator();
        while (iterator.hasNext()) {
            Endpoint endpoint = (Endpoint)iterator.next();
            this.removeEndpoint(endpoint);
        }
        this.status = MediaserverStatus.UNCONFIGURED;
    }

    public Server getServer() {
        return this.server;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setControllerPort(int controllerPort) throws RuntimeException {
        if (this.isServerStarted) {
            throw new RuntimeException("Server already started");
        }
        this.controllerPort = controllerPort;
    }

    public boolean isStarted() {
        return this.isServerStarted;
    }

    public String getStatus() {
        return this.status.name();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

