/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.arquillian.mss.mediaserver.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.mobicents.arquillian.mediaserver.api.EmbeddedMediaserver;
import org.mobicents.arquillian.mediaserver.api.EndpointType;
import org.mobicents.arquillian.mediaserver.api.MediaserverConfMode;
import org.mobicents.arquillian.mediaserver.api.annotations.Mediaserver;
import org.mobicents.arquillian.mss.mediaserver.extension.EmbeddedMediaserverException;
import org.mobicents.arquillian.mss.mediaserver.extension.EmbeddedMediaserverImpl;

public class MediaServerProducer {
    private Logger logger = Logger.getLogger(MediaServerProducer.class);
    private Boolean isMediaserverAnnotationPresentField = false;
    private Boolean isMediaserverAnnotationPresentClass = false;
    private Boolean isMediaserverAnnotationPresentMethod = false;
    private List<Field> deployableServerFields = new ArrayList<Field>();
    private List<Method> deployableServerMethods = new ArrayList<Method>();
    private Object testInstance = null;
    private EmbeddedMediaserver embeddedMediaserver;

    private EmbeddedMediaserver getServer() {
        if (this.embeddedMediaserver == null) {
            this.embeddedMediaserver = new EmbeddedMediaserverImpl();
        }
        return this.embeddedMediaserver;
    }

    public void executeBeforeClass(@Observes BeforeClass event, TestClass testClass) throws Exception {
        Method[] methods;
        Field[] fields;
        testClass = event.getTestClass();
        if (testClass.isAnnotationPresent(Mediaserver.class)) {
            this.isMediaserverAnnotationPresentClass = true;
        }
        for (Field field : fields = testClass.getJavaClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Mediaserver.class) || !field.getType().isAssignableFrom(EmbeddedMediaserver.class)) continue;
            this.isMediaserverAnnotationPresentField = true;
            this.deployableServerFields.add(field);
        }
        for (Method method : methods = testClass.getMethods(Mediaserver.class)) {
            if (!method.isAnnotationPresent(Mediaserver.class)) continue;
            this.isMediaserverAnnotationPresentMethod = true;
            this.deployableServerMethods.add(method);
        }
        if (this.deployableServerFields.size() > 1) {
            throw new EmbeddedMediaserverException("MediaServer annotation specified many times!");
        }
        if (this.isMediaserverAnnotationPresentField.booleanValue() && (this.isMediaserverAnnotationPresentClass.booleanValue() || this.isMediaserverAnnotationPresentMethod.booleanValue()) || this.isMediaserverAnnotationPresentClass.booleanValue() && this.isMediaserverAnnotationPresentMethod.booleanValue()) {
            throw new EmbeddedMediaserverException("MediaServer annotation specified many times!");
        }
        if (this.isMediaserverAnnotationPresentClass.booleanValue()) {
            this.startAndConfigureServer((Mediaserver)testClass.getAnnotation(Mediaserver.class));
        }
    }

    public void executeBeforeTestMethod(@Observes Before event, TestClass testClass) throws Exception {
        if (!this.getServer().isStarted()) {
            this.testInstance = event.getTestInstance();
            if (this.isMediaserverAnnotationPresentField.booleanValue()) {
                this.setMediaserver(this.testInstance, this.deployableServerFields);
            }
            if (this.isMediaserverAnnotationPresentClass.booleanValue()) {
                // empty if block
            }
            if (this.isMediaserverAnnotationPresentMethod.booleanValue() && this.deployableServerMethods.contains(event.getTestMethod())) {
                this.startAndConfigureServer(event.getTestMethod().getAnnotation(Mediaserver.class));
            }
        }
    }

    public void executeAfterClass(@Observes AfterClass event, TestClass testClass) {
        if (this.getServer().isStarted() && this.isMediaserverAnnotationPresentClass.booleanValue()) {
            this.embeddedMediaserver.stopServer();
            this.embeddedMediaserver = null;
        }
        this.deployableServerFields.clear();
        this.isMediaserverAnnotationPresentField = false;
        this.isMediaserverAnnotationPresentClass = false;
        this.isMediaserverAnnotationPresentMethod = false;
    }

    public void executeAfterTestMethod(@Observes After event, TestClass testClass) {
        if (this.getServer().isStarted() && (this.isMediaserverAnnotationPresentMethod.booleanValue() || this.isMediaserverAnnotationPresentField.booleanValue())) {
            this.embeddedMediaserver.stopServer();
            this.embeddedMediaserver = null;
        }
    }

    private void setMediaserver(Object testInstance, List<Field> fields) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : fields) {
            Boolean flag = field.isAccessible();
            field.setAccessible(true);
            EmbeddedMediaserver fieldValue = (EmbeddedMediaserver)field.get(testInstance);
            if (fieldValue == null) {
                field.set(testInstance, this.getServer());
            } else {
                field.set(testInstance, null);
            }
            field.setAccessible(flag);
            try {
                this.startAndConfigureServer(field.getAnnotation(Mediaserver.class));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startAndConfigureServer(Mediaserver anno) throws Exception {
        if (anno.ConfMode() == MediaserverConfMode.MANUAL) {
            if (this.isMediaserverAnnotationPresentField.booleanValue()) {
                this.logger.info((Object)"Mediaserver defined in a Field level annotation, in manual mode. Skipping configuration");
                return;
            }
            throw new EmbeddedMediaserverException("Mediaserver in MANUAL mode is allowed only in Feild level annotation!");
        }
        EmbeddedMediaserver mediaserver = this.getServer();
        mediaserver.startServer();
        mediaserver.installEndpoint(EndpointType.IVR, anno.IVR());
        mediaserver.installEndpoint(EndpointType.CONFERENCE, anno.CONF());
        mediaserver.installEndpoint(EndpointType.PACKETRELAY, anno.RELAY());
        mediaserver.installEndpoint(EndpointType.BRIDGE, anno.BRIDGE());
        if (anno.ID() != null) {
            mediaserver.setId(anno.ID());
        } else {
            mediaserver.setId(mediaserver.toString());
        }
    }
}

