/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.arquillian.mss.mediaserver.extension.mgcp.controller.ext;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.arquillian.mediaserver.api.MgcpEventListener;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.TooManyListenersException;

public class MgcpProviderExt
extends MgcpProvider {
    List<MgcpEventListener> mgcpEventListeners = new ArrayList<MgcpEventListener>();

    public void addMgcpEventListener(MgcpEventListener listener) throws TooManyListenersException {
        this.mgcpEventListeners.add(listener);
    }

    public void removeMgcpEventListener(MgcpEventListener listener) {
        this.mgcpEventListeners.remove(listener);
    }

    public MgcpProviderExt(UdpManager udpManager, int port, Scheduler scheduler) {
        super(udpManager, port, scheduler);
    }

    protected MgcpProviderExt(String name, UdpManager udpManager, int port, Scheduler scheduler) {
        super(name, udpManager, port, scheduler);
    }

    public void activate() {
        super.activate();
    }

    public void send(MgcpEvent event) throws IOException {
        super.send(event);
        for (MgcpEventListener listener : this.mgcpEventListeners) {
            listener.process((Event)event);
        }
    }

    public void send(MgcpMessage message, SocketAddress destination) throws IOException {
        super.send(message, destination);
        for (MgcpEventListener listener : this.mgcpEventListeners) {
            listener.process((Event)message);
        }
    }

    public void send(MgcpEvent event, SocketAddress destination) throws IOException {
        super.send(event, destination);
        for (MgcpEventListener listener : this.mgcpEventListeners) {
            listener.process((Event)event);
        }
    }
}

