/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.startup.ExpandWar;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.container.mobicents.api.MSSContainer;
import org.jboss.arquillian.container.mobicents.api.SipServletsEmbeddedContainer;
import org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7.EmbeddedContextConfig;
import org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7.MobicentsSipServletsConfiguration;
import org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7.MobicentsSipServletsEmbeddedImpl;
import org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7.SipContext;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.mobicents.servlet.sip.api.ShrinkWrapSipStandardContext;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.catalina.SipStandardService;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.core.session.SipStandardManager;
import org.mobicents.servlet.sip.startup.SipStandardContext;

public class MobicentsSipServletsContainer
implements DeployableContainer<MobicentsSipServletsConfiguration>,
MSSContainer {
    private static final Logger log = Logger.getLogger(MobicentsSipServletsContainer.class.getName());
    private static final String ENV_VAR = "${env.";
    private static final String TMPDIR_SYS_PROP = "java.io.tmpdir";
    private static final String SIP_PROTOCOL = "sip";
    protected List<SipConnector> sipConnectors;
    private SipServletsEmbeddedContainer embedded;
    private SipStandardContext context;
    private Engine engine;
    private Host standardHost;
    private File appBase;
    private MobicentsSipServletsConfiguration configuration;
    private SipStandardService sipStandardService;
    private String serverName;
    private String bindAddress;
    private int bindPort;
    private boolean wasStarted;
    @Inject
    @DeploymentScoped
    private InstanceProducer<SipStandardContext> sipStandardContextProducer;
    private Archive<?> archive;
    private Manager sipStandardManager;

    public Class<MobicentsSipServletsConfiguration> getConfigurationClass() {
        return MobicentsSipServletsConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(MobicentsSipServletsConfiguration configuration) {
        this.configuration = configuration;
        this.bindAddress = this.configuration.getBindAddress();
        this.bindPort = this.configuration.getBindHttpPort();
        this.sipConnectors = this.getSipConnectors(this.configuration.getSipConnectors());
        this.serverName = this.configuration.getServerName();
    }

    public List<SipConnector> getSipConnectors(String sipConnectorString) {
        ArrayList<SipConnector> connectors = new ArrayList<SipConnector>();
        StringTokenizer tokenizer = new StringTokenizer(sipConnectorString, ",");
        while (tokenizer.hasMoreTokens()) {
            String bindSipTransport;
            int bindSipPort;
            String connectorString = tokenizer.nextToken();
            int indexOfColumn = connectorString.indexOf(":");
            int indexOfSlash = connectorString.indexOf("/");
            if (indexOfColumn == -1) {
                throw new IllegalArgumentException("sipConnectors configuration should be a comma separated list of <ip_address>:<port>/<transport>");
            }
            String bindSipAddress = indexOfColumn == 0 ? this.bindAddress : connectorString.substring(0, indexOfColumn);
            if (indexOfSlash != -1) {
                bindSipPort = Integer.parseInt(connectorString.substring(indexOfColumn + 1, indexOfSlash));
                bindSipTransport = connectorString.substring(indexOfSlash + 1);
            } else {
                bindSipPort = Integer.parseInt(connectorString.substring(indexOfColumn + 1));
                bindSipTransport = "UDP";
            }
            SipConnector sipConnector = this.createSipConnector(bindSipAddress, bindSipPort, bindSipTransport);
            connectors.add(sipConnector);
        }
        return connectors;
    }

    public void startTomcatEmbedded() throws UnknownHostException, org.apache.catalina.LifecycleException, LifecycleException {
        this.startTomcatEmbedded(null);
    }

    public void startTomcatEmbedded(Properties sipStackProperties) throws UnknownHostException, org.apache.catalina.LifecycleException, LifecycleException {
        Engine engine;
        System.setProperty("javax.servlet.sip.ar.spi.SipApplicationRouterProvider", this.configuration.getSipApplicationRouterProviderClassName());
        if (this.bindAddress != null) {
            System.setProperty("org.mobicents.testsuite.testhostaddr", this.bindAddress);
        } else {
            System.setProperty("org.mobicents.testsuite.testhostaddr", "127.0.0.1");
        }
        String darConfiguration = Thread.currentThread().getContextClassLoader().getResource("test-dar.properties").toString();
        if (darConfiguration != null) {
            System.setProperty("javax.servlet.sip.dar", Thread.currentThread().getContextClassLoader().getResource("test-dar.properties").toString());
        } else {
            System.setProperty("javax.servlet.sip.dar", Thread.currentThread().getContextClassLoader().getResource("empty-dar.properties").toString());
        }
        MobicentsSipServletsEmbeddedImpl embedded = new MobicentsSipServletsEmbeddedImpl();
        this.embedded = embedded;
        this.sipStandardService = (SipStandardService)embedded.getService();
        this.sipStandardService.setSipApplicationDispatcherClassName(SipApplicationDispatcherImpl.class.getCanonicalName());
        this.sipStandardService.setCongestionControlCheckingInterval(-1L);
        this.sipStandardService.setAdditionalParameterableHeaders("additionalParameterableHeader");
        this.sipStandardService.setUsePrettyEncoding(true);
        this.sipStandardService.setName(this.serverName);
        if (sipStackProperties != null) {
            this.sipStandardService.setSipStackProperties(sipStackProperties);
        }
        String tomcatHome = this.configuration.getTomcatHome();
        File tomcatHomeFile = null;
        if (tomcatHome != null) {
            if (tomcatHome.startsWith(ENV_VAR)) {
                String sysVar = tomcatHome.substring(ENV_VAR.length(), tomcatHome.length() - 1);
                if ((tomcatHome = System.getProperty(sysVar)) != null && tomcatHome.length() > 0 && new File(tomcatHome).isAbsolute()) {
                    tomcatHomeFile = new File(tomcatHome);
                    log.info("Using tomcat home from environment variable: " + tomcatHome);
                }
            } else {
                tomcatHomeFile = new File(tomcatHome);
            }
        }
        if (tomcatHomeFile == null) {
            tomcatHomeFile = new File(System.getProperty(TMPDIR_SYS_PROP), "mss-tomcat-embedded-7");
        }
        tomcatHomeFile.mkdirs();
        embedded.setCatalinaBase(tomcatHomeFile.getAbsolutePath());
        embedded.setCatalinaHome(tomcatHomeFile.getAbsolutePath());
        this.engine = engine = embedded.createEngine();
        engine.setName(this.serverName);
        engine.setDefaultHost(this.bindAddress);
        engine.setService((Service)this.sipStandardService);
        this.sipStandardService.setContainer((Container)engine);
        embedded.addEngine(engine);
        this.appBase = new File(tomcatHomeFile, this.configuration.getAppBase());
        this.appBase.mkdirs();
        StandardHost host = (StandardHost)embedded.createHost(this.bindAddress, this.appBase.getAbsolutePath());
        this.standardHost = host;
        if (this.configuration.getTomcatWorkDir() != null) {
            host.setWorkDir(this.configuration.getTomcatWorkDir());
        }
        host.setUnpackWARs(this.configuration.isUnpackArchive());
        host.setDeployOnStartup(false);
        host.setAutoDeploy(false);
        embedded.getEngine().addChild((Container)host);
        try {
            File license;
            System.setProperty("telscale.license.dir", tomcatHomeFile.getPath());
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Class.class.getClassLoader();
            }
            if ((license = FileUtils.toFile((URL)classLoader.getResource("telestax-license.xml").toURI().toURL())) != null) {
                FileUtils.copyFileToDirectory((File)license, (File)tomcatHomeFile, (boolean)false);
            } else {
                try {
                    int bytesRead;
                    InputStream is = classLoader.getResourceAsStream("telestax-license.xml");
                    FileOutputStream os = new FileOutputStream(tomcatHomeFile + File.separator + "telestax-license.xml");
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, bytesRead);
                    }
                    is.close();
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Connector connector = embedded.createConnector(InetAddress.getByName(this.bindAddress), this.bindPort, false);
        embedded.setPort(this.bindPort);
        embedded.setHostname(this.bindAddress);
        embedded.addConnector(connector);
        embedded.setConnector(connector);
        embedded.enableNaming();
        embedded.start();
        embedded.getService().start();
        for (SipConnector sipConnector : this.sipConnectors) {
            this.addSipConnector(sipConnector);
        }
        this.wasStarted = true;
    }

    public void stopTomcatEmbedded() throws LifecycleException, org.apache.catalina.LifecycleException {
        this.embedded.stop();
        this.wasStarted = false;
    }

    public void deleteUnpackedWAR(StandardContext standardContext) {
        File unpackDir = new File(this.standardHost.getAppBase(), standardContext.getPath().substring(1));
        if (unpackDir.exists()) {
            ExpandWar.deleteDir((File)unpackDir);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.archive = archive;
        try {
            SipStandardContext sipStandardContext = (SipStandardContext)archive.as(ShrinkWrapSipStandardContext.class);
            sipStandardContext.setXmlNamespaceAware(true);
            this.setSipStandardManager((Manager)new SipStandardManager());
            sipStandardContext.setManager(this.getSipStandardManager());
            sipStandardContext.addLifecycleListener((LifecycleListener)new EmbeddedContextConfig());
            sipStandardContext.setUnpackWAR(this.configuration.isUnpackArchive());
            sipStandardContext.setJ2EEServer("MSS-Arquillian-" + UUID.randomUUID().toString());
            if (this.configuration.getContextParam() != null) {
                String[] params;
                log.info("Setting contextParameters from configuration");
                String paramSeparator = this.configuration.getParamSeparator();
                String valueSeparator = this.configuration.getValueSeparator();
                String contextParams = this.configuration.getContextParam();
                for (String param : params = contextParams.split(paramSeparator)) {
                    String name = param.split(valueSeparator)[0];
                    String value = param.split(valueSeparator)[1];
                    ApplicationParameter applicationParameter = new ApplicationParameter();
                    applicationParameter.setName(name);
                    applicationParameter.setValue(value);
                    sipStandardContext.addApplicationParameter(applicationParameter);
                }
            }
            if (this.configuration.getConcurrencyControl() != null) {
                sipStandardContext.setConcurrencyControlMode(ConcurrencyControlMode.valueOf((String)this.configuration.getConcurrencyControl()));
            }
            sipStandardContext.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            if (sipStandardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR((StandardContext)sipStandardContext);
            }
            this.standardHost.addChild((Container)sipStandardContext);
            this.context = sipStandardContext;
            this.sipStandardContextProducer.set((Object)sipStandardContext);
            String contextPath = sipStandardContext.getPath();
            SipContext sipContext = new SipContext(this.bindAddress, this.bindPort);
            for (String mapping : sipStandardContext.findServletMappings()) {
                sipContext.add(new Servlet(sipStandardContext.findServletMapping(mapping), contextPath));
            }
            return new ProtocolMetaData().addContext((Object)sipContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy " + archive.getName(), (Throwable)e);
        }
    }

    public void start() throws LifecycleException {
        try {
            this.startTomcatEmbedded();
        }
        catch (Exception e) {
            throw new LifecycleException("Bad shit happened", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (this.wasStarted) {
            try {
                this.stopTomcatEmbedded();
            }
            catch (org.apache.catalina.LifecycleException e) {
                throw new LifecycleException("An unexpected error occurred", (Throwable)e);
            }
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        SipStandardContext sipStandardContext = (SipStandardContext)this.sipStandardContextProducer.get();
        if (sipStandardContext != null) {
            this.standardHost.removeChild((Container)sipStandardContext);
            if (sipStandardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR((StandardContext)sipStandardContext);
            }
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<SipConnector> getSipConnectors() {
        return this.sipConnectors;
    }

    public boolean isStarted() {
        return this.wasStarted;
    }

    public void addSipConnector(SipConnector sipConnector) throws LifecycleException {
        try {
            this.sipStandardService.addSipConnector(sipConnector);
        }
        catch (Exception e) {
            throw new LifecycleException("Couldn't create the sip connector " + sipConnector, (Throwable)e);
        }
    }

    public SipConnector createSipConnector(String ipAddress, int port, String transport) {
        SipConnector sipConnector = new SipConnector();
        sipConnector.setIpAddress(ipAddress);
        sipConnector.setPort(port);
        sipConnector.setTransport(transport);
        return sipConnector;
    }

    public void removeSipConnector(String ipAddress, int port, String transport) throws LifecycleException {
        try {
            this.sipStandardService.removeSipConnector(ipAddress, port, transport);
        }
        catch (Exception e) {
            throw new LifecycleException("Couldn't remove the sip connector " + ipAddress + ":" + port + "/" + transport, (Throwable)e);
        }
    }

    public Archive<?> getArchive() {
        return this.archive;
    }

    public SipStandardService getSipStandardService() {
        return this.sipStandardService;
    }

    public Manager getSipStandardManager() {
        return this.sipStandardManager;
    }

    public void setSipStandardManager(Manager sipStandardManager) {
        this.sipStandardManager = sipStandardManager;
    }
}

