/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.mobicents.servlet.sip.tomcat.embedded_7;

import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sip.SipFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.arquillian.container.mobicents.api.SipServletsEmbeddedContainer;
import org.mobicents.servlet.sip.catalina.SipProtocolHandler;
import org.mobicents.servlet.sip.catalina.SipStandardService;

public class MobicentsSipServletsEmbeddedImpl
extends Tomcat
implements SipServletsEmbeddedContainer {
    private static Log log = LogFactory.getLog(MobicentsSipServletsEmbeddedImpl.class);
    private StandardService service;
    protected boolean useNaming = true;
    protected boolean redirectStreams = true;
    protected Engine[] engines = new Engine[0];
    protected HashMap authenticators;
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    protected Realm realm = null;
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    protected boolean started = false;
    protected boolean await = false;
    protected StandardContext context;

    public MobicentsSipServletsEmbeddedImpl() {
        this.service = new SipStandardService();
    }

    public void setCatalinaHome(String s) {
        System.setProperty("catalina.home", s);
    }

    public void setCatalinaBase(String s) {
        System.setProperty("catalina.base", s);
    }

    public String getCatalinaHome() {
        return System.getProperty("catalina.home");
    }

    public String getCatalinaBase() {
        return System.getProperty("catalina.base");
    }

    public synchronized void addConnector(Connector connector) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding connector (" + connector.getInfo() + ")"));
        }
        if (this.engines.length < 1) {
            throw new IllegalStateException(sm.getString("embedded.noEngines"));
        }
        this.service.addConnector(connector);
    }

    public synchronized void addEngine(Engine engine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding engine (" + engine.getInfo() + ")"));
        }
        Engine[] results = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            results[i] = this.engines[i];
        }
        results[this.engines.length] = engine;
        this.engines = results;
        if (this.started && engine instanceof Lifecycle) {
            try {
                engine.start();
            }
            catch (LifecycleException e) {
                log.error((Object)"Engine.start", (Throwable)e);
            }
        }
        this.engine = engine;
        this.service.setContainer((Container)engine);
    }

    public Connector createConnector(InetAddress address, int port, boolean secure) {
        return this.createConnector(address != null ? address.toString() : null, port, secure);
    }

    public Connector createConnector(String address, int port, boolean secure) {
        String protocol = "http";
        if (secure) {
            protocol = "https";
        }
        return this.createConnector(address, port, protocol);
    }

    public Connector createConnector(InetAddress address, int port, String protocol) {
        return this.createConnector(address != null ? address.toString() : null, port, protocol);
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        Connector connector = null;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'"));
        }
        try {
            if (protocol.equals("ajp")) {
                connector = new Connector("org.apache.jk.server.JkCoyoteHandler");
            } else if (protocol.equals("memory")) {
                connector = new Connector("org.apache.coyote.memory.MemoryProtocolHandler");
            } else if (protocol.equals("http")) {
                connector = new Connector();
            } else if (protocol.equals("https")) {
                connector = new Connector();
                connector.setScheme("https");
                connector.setSecure(true);
                connector.setProperty("SSLEnabled", "true");
            } else {
                connector = new Connector(protocol);
            }
            if (address != null) {
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)("" + address));
            }
            IntrospectionUtils.setProperty((Object)connector, (String)"port", (String)("" + port));
        }
        catch (Exception e) {
            log.error((Object)"Couldn't create connector.");
        }
        return connector;
    }

    public Context createContext(String path, String docBase) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating context '" + path + "' with docBase '" + docBase + "'"));
        }
        this.context = new StandardContext();
        this.context.setDocBase(docBase);
        this.context.setPath(path);
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators((Map)this.authenticators);
        this.context.addLifecycleListener((LifecycleListener)config);
        return this.context;
    }

    public Engine createEngine() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating engine");
        }
        StandardEngine engine = new StandardEngine();
        engine.setRealm(this.realm);
        return engine;
    }

    public Host createHost(String name, String appBase) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating host '" + name + "' with appBase '" + appBase + "'"));
        }
        StandardHost host = new StandardHost();
        host.setAppBase(appBase);
        host.setName(name);
        return host;
    }

    public Loader createLoader(ClassLoader parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Loader with parent class loader '" + parent + "'"));
        }
        WebappLoader loader = new WebappLoader(parent);
        return loader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeContext(Context context) {
        boolean isContextExists;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing context[" + context.getPath() + "]"));
        }
        if (!(isContextExists = this.isContextExists(context))) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Context");
        }
        context.getParent().removeChild((Container)context);
    }

    private boolean isContextExists(Context context) {
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] contexts = hosts[j].findChildren();
                for (int k = 0; k < contexts.length; ++k) {
                    if (context != (Context)contexts[k]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void removeEngine(Engine engine) {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing engine (" + engine.getInfo() + ")"));
        }
        int j = -1;
        for (int i2 = 0; i2 < this.engines.length; ++i2) {
            if (engine != this.engines[i2]) continue;
            j = i2;
            break;
        }
        if (j < 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing related Containers");
        }
        while (true) {
            int n = -1;
            Connector[] connectors = this.service.findConnectors();
            for (i = 0; i < connectors.length; ++i) {
                if (connectors[i].getService().getContainer() != engine) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            this.service.removeConnector(connectors[n]);
        }
        if (engine instanceof Lifecycle) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Stopping this Engine");
            }
            try {
                engine.stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"Engine.stop", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Engine");
        }
        int k = 0;
        Engine[] results = new Engine[this.engines.length - 1];
        for (i = 0; i < this.engines.length; ++i) {
            if (i == j) continue;
            results[k++] = this.engines[i];
        }
        this.engines = results;
    }

    public synchronized void removeHost(Host host) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing host[" + host.getName() + "]"));
        }
        boolean found = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                if (host != (Host)hosts[j]) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Removing this Host");
        }
        host.getParent().removeChild((Container)host);
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        this.initBaseDir();
        System.setProperty("catalina.useNaming", "true");
        this.server = new StandardServer();
        this.server.setPort(-1);
        this.server.addService((Service)this.service);
        return this.server;
    }

    public Connector getConnector() {
        this.getServer();
        if (this.connector != null) {
            return this.connector;
        }
        this.connector = new Connector("HTTP/1.1");
        this.connector.setPort(this.port);
        this.service.addConnector(this.connector);
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.service != null) {
            try {
                this.service.stop();
                this.service.destroy();
            }
            catch (LifecycleException e) {
                log.error((Object)"service already stopped ", (Throwable)e);
            }
            SipFactory.getInstance().resetFactory();
        }
    }

    public void setService(StandardService service) {
        this.service = service;
    }

    public StandardService getService() {
        return this.service;
    }

    public Connector addSipConnector(String connectorName, String ipAddress, int port, String transport) throws Exception {
        Connector sipConnector = new Connector(SipProtocolHandler.class.getName());
        SipProtocolHandler sipProtocolHandler = (SipProtocolHandler)sipConnector.getProtocolHandler();
        sipProtocolHandler.setPort(port);
        sipProtocolHandler.setIpAddress(ipAddress);
        sipProtocolHandler.setSignalingTransport(transport);
        ((SipStandardService)this.service).addConnector(sipConnector);
        return sipConnector;
    }

    public List<Connector> getSipConnectors() {
        Connector[] conns;
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Connector conn : conns = this.service.findConnectors()) {
            if (!(conn.getProtocolHandler() instanceof SipProtocolHandler)) continue;
            connectors.add(conn);
        }
        return connectors;
    }

    public void removeConnector(Connector connector) {
        this.service.removeConnector(connector);
    }

    public Engine getEngine() {
        if (this.engine == null) {
            this.getServer();
            this.engine = this.createEngine();
        }
        return this.engine;
    }
}

