/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.TimerTaskData;

public class CancelTimerAfterTxCommitRunnable
implements Runnable {
    private static final Logger logger = Logger.getLogger(CancelTimerAfterTxCommitRunnable.class);
    private final FaultTolerantScheduler executor;
    private TimerTask task;

    CancelTimerAfterTxCommitRunnable(TimerTask task, FaultTolerantScheduler executor) {
        this.task = task;
        this.executor = executor;
    }

    public void run() {
        TimerTaskData taskData = this.task.getData();
        Serializable taskID = taskData.getTaskID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelling timer task for timer ID " + taskID));
        }
        this.executor.getLocalRunningTasksMap().remove(taskID);
        try {
            this.task.getScheduledFuture().cancel(false);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }
}

