/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers.timer;

import java.util.Date;
import java.util.Timer;
import java.util.UUID;
import javax.transaction.TransactionManager;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.PeriodicScheduleStrategy;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.timer.FaultTolerantTimerTimerTask;
import org.mobicents.timers.timer.FaultTolerantTimerTimerTaskData;
import org.mobicents.timers.timer.FaultTolerantTimerTimerTaskFactory;

public class FaultTolerantTimer
extends Timer {
    private final FaultTolerantScheduler scheduler;
    private final FaultTolerantTimerTimerTaskFactory timerTaskFactory = new FaultTolerantTimerTimerTaskFactory();

    public FaultTolerantTimer(String name, MobicentsCluster cluster, byte priority, TransactionManager txManager) {
        this.scheduler = new FaultTolerantScheduler(name, 16, cluster, priority, txManager, this.timerTaskFactory);
        this.timerTaskFactory.setScheduler(this.scheduler);
    }

    public FaultTolerantScheduler getScheduler() {
        return this.scheduler;
    }

    public void cancel() {
        this.scheduler.shutdownNow();
    }

    public int purge() {
        int count = 0;
        for (TimerTask timerTask : this.scheduler.getLocalRunningTasks()) {
            FaultTolerantTimerTimerTask ftTimerTask = (FaultTolerantTimerTimerTask)timerTask;
            if (!ftTimerTask.isCanceled()) continue;
            this.scheduler.cancel(ftTimerTask.getData().getTaskID());
            ++count;
        }
        return count;
    }

    public void schedule(java.util.TimerTask task, Date firstTime, long period) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), firstTime.getTime() - System.currentTimeMillis(), period, PeriodicScheduleStrategy.withFixedDelay));
        this.scheduler.schedule(taskWrapper);
    }

    public void schedule(java.util.TimerTask task, Date time) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), time.getTime() - System.currentTimeMillis(), -1L, null));
        this.scheduler.schedule(taskWrapper);
    }

    public void schedule(java.util.TimerTask task, long delay) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), System.currentTimeMillis() + delay, -1L, null));
        this.scheduler.schedule(taskWrapper);
    }

    public void schedule(java.util.TimerTask task, long delay, long period) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), System.currentTimeMillis() + delay, period, PeriodicScheduleStrategy.withFixedDelay));
        this.scheduler.schedule(taskWrapper);
    }

    public void scheduleAtFixedRate(java.util.TimerTask task, Date firstTime, long period) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), firstTime.getTime() - System.currentTimeMillis(), period, PeriodicScheduleStrategy.atFixedRate));
        this.scheduler.schedule(taskWrapper);
    }

    public void scheduleAtFixedRate(java.util.TimerTask task, long delay, long period) {
        TimerTask taskWrapper = this.timerTaskFactory.newTimerTask(new FaultTolerantTimerTimerTaskData(task, UUID.randomUUID(), System.currentTimeMillis() + delay, period, PeriodicScheduleStrategy.atFixedRate));
        this.scheduler.schedule(taskWrapper);
    }
}

