/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.util.concurrent.ScheduledFuture;
import org.mobicents.timers.SetTimerAfterTxCommitRunnable;
import org.mobicents.timers.TimerTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerTask
implements Runnable {
    private final TimerTaskData data;
    private ScheduledFuture<?> scheduledFuture;
    private SetTimerAfterTxCommitRunnable action;
    private transient boolean cancel;

    public TimerTask(TimerTaskData data) {
        this.data = data;
    }

    public TimerTaskData getData() {
        return this.data;
    }

    protected SetTimerAfterTxCommitRunnable getSetTimerTransactionalAction() {
        return this.action;
    }

    void setSetTimerTransactionalAction(SetTimerAfterTxCommitRunnable action) {
        this.action = action;
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
        if (this.cancel) {
            this.scheduledFuture.cancel(false);
        }
    }

    protected void cancel() {
        this.cancel = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    @Override
    public abstract void run();

    public void beforeRecover() {
        long now = System.currentTimeMillis();
        if (this.data.getStartTime() < now) {
            this.data.setStartTime(now);
        }
    }
}

