/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.PeriodicScheduleStrategy;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.TimerTaskData;

public class SetTimerAfterTxCommitRunnable
implements Runnable {
    private static final Logger logger = Logger.getLogger(SetTimerAfterTxCommitRunnable.class);
    private final TimerTask task;
    private final FaultTolerantScheduler scheduler;
    private boolean canceled = false;

    SetTimerAfterTxCommitRunnable(TimerTask task, FaultTolerantScheduler scheduler) {
        this.task = task;
        this.scheduler = scheduler;
    }

    public void run() {
        block10: {
            this.task.setSetTimerTransactionalAction(null);
            if (!this.canceled) {
                TimerTaskData taskData = this.task.getData();
                long delay = taskData.getStartTime() - System.currentTimeMillis();
                if (delay < 0L) {
                    delay = 0L;
                }
                try {
                    if (taskData.getPeriod() < 0L) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Scheduling one-shot timer with id " + this.task.getData().getTaskID()));
                        }
                        this.task.setScheduledFuture(this.scheduler.getExecutor().schedule(this.task, delay, TimeUnit.MILLISECONDS));
                        break block10;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Scheduling periodic timer with id " + this.task.getData().getTaskID()));
                    }
                    if (taskData.getPeriodicScheduleStrategy() == PeriodicScheduleStrategy.withFixedDelay) {
                        this.task.setScheduledFuture(this.scheduler.getExecutor().scheduleWithFixedDelay(this.task, delay, taskData.getPeriod(), TimeUnit.MILLISECONDS));
                        break block10;
                    }
                    this.task.setScheduledFuture(this.scheduler.getExecutor().scheduleAtFixedRate(this.task, delay, taskData.getPeriod(), TimeUnit.MILLISECONDS));
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    this.scheduler.remove(taskData.getTaskID(), true);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Canceled scheduling periodic timer with id " + this.task.getData().getTaskID()));
            }
        }
    }

    public void cancel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Canceling set timer action for task with timer id " + this.task.getData().getTaskID()));
        }
        this.canceled = true;
        this.scheduler.remove(this.task.getData().getTaskID(), true);
    }
}

