/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers.timer;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.timer.FaultTolerantTimerTimerTaskData;

public class FaultTolerantTimerTimerTask
extends TimerTask {
    private static final Logger logger = Logger.getLogger(FaultTolerantTimerTimerTask.class);
    private final FaultTolerantScheduler scheduler;
    private final FaultTolerantTimerTimerTaskData taskData;

    public FaultTolerantTimerTimerTask(FaultTolerantTimerTimerTaskData taskData, FaultTolerantScheduler scheduler) {
        super(taskData);
        this.taskData = taskData;
        this.scheduler = scheduler;
        this.setPeriod(taskData.getJavaUtilTimerTask(), taskData.getPeriod());
    }

    public void runTask() {
        if (this.isCanceled()) {
            this.scheduler.cancel(this.getData().getTaskID());
        } else {
            try {
                this.taskData.getJavaUtilTimerTask().run();
                if (this.taskData.getPeriodicScheduleStrategy() == null) {
                    this.scheduler.cancel(this.getData().getTaskID());
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"task data has a periodic schedule strategy, not cancelling the task");
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    public boolean isCanceled() {
        return this.getTaskStatus(this.taskData.getJavaUtilTimerTask()) == 3;
    }

    private int getTaskStatus(final java.util.TimerTask timerTask) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return FaultTolerantTimerTimerTask.this._getTaskStatus(timerTask);
                }
            });
        }
        return this._getTaskStatus(timerTask);
    }

    private Integer _getTaskStatus(java.util.TimerTask timerTask) {
        Class<java.util.TimerTask> cc = java.util.TimerTask.class;
        try {
            Field stateField = cc.getDeclaredField("state");
            stateField.setAccessible(true);
            Integer taskStatus = (Integer)stateField.get(this.taskData.getJavaUtilTimerTask());
            stateField.setAccessible(false);
            return taskStatus;
        }
        catch (Exception e) {
            throw new RuntimeException("Fialed to get status", e);
        }
    }

    private void setPeriod(final java.util.TimerTask javaUtilTimerTask, final long period) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FaultTolerantTimerTimerTask.this._setPeriod(javaUtilTimerTask, period);
                    return null;
                }
            });
        } else {
            this._setPeriod(javaUtilTimerTask, period);
        }
    }

    private void _setPeriod(java.util.TimerTask javaUtilTimerTask, long period) {
        Class<java.util.TimerTask> cc = java.util.TimerTask.class;
        try {
            Field stateField = cc.getDeclaredField("period");
            stateField.setAccessible(true);
            stateField.set(javaUtilTimerTask, new Long(period));
            stateField.setAccessible(false);
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to set task period", e);
        }
    }
}

