/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.cache.Fqn;
import org.jboss.cache.transaction.TransactionContext;
import org.jgroups.Address;
import org.mobicents.cluster.DataRemovalListener;
import org.mobicents.cluster.FailOverListener;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.cache.ClusteredCacheData;
import org.mobicents.cluster.election.ClientLocalListenerElector;
import org.mobicents.timers.CancelTimerAfterTxCommitRunnable;
import org.mobicents.timers.SetTimerAfterTxCommitRunnable;
import org.mobicents.timers.TimerTask;
import org.mobicents.timers.TimerTaskData;
import org.mobicents.timers.TimerTaskFactory;
import org.mobicents.timers.TransactionSynchronization;
import org.mobicents.timers.cache.FaultTolerantSchedulerCacheData;
import org.mobicents.timers.cache.TimerTaskCacheData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantScheduler {
    private static final Logger logger = Logger.getLogger(FaultTolerantScheduler.class);
    private final ScheduledThreadPoolExecutor executor;
    private final FaultTolerantSchedulerCacheData cacheData;
    private final TransactionManager txManager;
    private final ConcurrentHashMap<Serializable, TimerTask> localRunningTasks = new ConcurrentHashMap();
    private TimerTaskFactory timerTaskFactory;
    private final Fqn baseFqn;
    private final String name;
    private final MobicentsCluster cluster;
    private final ClientLocalListener clusterClientLocalListener;

    public FaultTolerantScheduler(String name, int corePoolSize, MobicentsCluster cluster, byte priority, TransactionManager txManager, TimerTaskFactory timerTaskFactory) {
        this.name = name;
        this.executor = new ScheduledThreadPoolExecutor(corePoolSize);
        this.baseFqn = Fqn.fromElements((Object[])new String[]{name});
        this.cluster = cluster;
        this.cacheData = new FaultTolerantSchedulerCacheData(this.baseFqn, cluster);
        if (!this.cacheData.exists()) {
            this.cacheData.create();
        }
        this.timerTaskFactory = timerTaskFactory;
        this.txManager = txManager;
        this.clusterClientLocalListener = new ClientLocalListener(priority);
        cluster.addFailOverListener((FailOverListener)this.clusterClientLocalListener);
        cluster.addDataRemovalListener((DataRemovalListener)this.clusterClientLocalListener);
    }

    public TimerTaskData getTimerTaskData(Serializable taskID) {
        TimerTaskCacheData timerTaskCacheData = new TimerTaskCacheData(taskID, this.baseFqn, this.cluster);
        if (timerTaskCacheData.exists()) {
            return timerTaskCacheData.getTaskData();
        }
        return null;
    }

    ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    ConcurrentHashMap<Serializable, TimerTask> getLocalRunningTasksMap() {
        return this.localRunningTasks;
    }

    public Set<TimerTask> getLocalRunningTasks() {
        return new HashSet<TimerTask>(this.localRunningTasks.values());
    }

    public TimerTask getLocalRunningTask(Serializable taskId) {
        return this.localRunningTasks.get(taskId);
    }

    public String getName() {
        return this.name;
    }

    public byte getPriority() {
        return this.clusterClientLocalListener.getPriority();
    }

    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    public TimerTaskFactory getTimerTaskFactory() {
        return this.timerTaskFactory;
    }

    public void schedule(TimerTask task) {
        this.schedule(task, true);
    }

    public void schedule(TimerTask task, boolean checkIfAlreadyPresent) {
        TimerTaskCacheData timerTaskCacheData;
        TimerTaskData taskData = task.getData();
        Serializable taskID = taskData.getTaskID();
        task.setScheduler(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduling task with id " + taskID));
        }
        if ((timerTaskCacheData = new TimerTaskCacheData(taskID, this.baseFqn, this.cluster)).create()) {
            timerTaskCacheData.setTaskData(taskData);
        } else if (checkIfAlreadyPresent) {
            throw new IllegalStateException("timer task " + taskID + " already scheduled");
        }
        final SetTimerAfterTxCommitRunnable setTimerAction = new SetTimerAfterTxCommitRunnable(task, this);
        if (this.txManager != null) {
            try {
                Transaction tx = this.txManager.getTransaction();
                if (tx != null) {
                    final TransactionContext tc = this.cluster.getMobicentsCache().getJBossCache().getInvocationContext().getTransactionContext();
                    Runnable beforeCommitAction = new Runnable(){

                        public void run() {
                            tc.getOrderedSynchronizationHandler().registerAtTail((Synchronization)new TransactionSynchronization(null, setTimerAction, null));
                        }
                    };
                    tx.registerSynchronization((Synchronization)new TransactionSynchronization(beforeCommitAction, null, null));
                    task.setSetTimerTransactionalAction(setTimerAction);
                }
                setTimerAction.run();
            }
            catch (Throwable e) {
                this.remove(taskID, true);
                throw new RuntimeException("Unable to register tx synchronization object", e);
            }
        } else {
            setTimerAction.run();
        }
    }

    public TimerTask cancel(Serializable taskID) {
        TimerTask task;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Canceling task with timer id " + taskID));
        }
        if ((task = this.localRunningTasks.get(taskID)) != null) {
            new TimerTaskCacheData(taskID, this.baseFqn, this.cluster).remove();
            SetTimerAfterTxCommitRunnable setAction = task.getSetTimerTransactionalAction();
            if (setAction != null) {
                setAction.cancel();
            } else {
                CancelTimerAfterTxCommitRunnable cancelAction = new CancelTimerAfterTxCommitRunnable(task, this);
                if (this.txManager != null) {
                    try {
                        TransactionContext tc = this.cluster.getMobicentsCache().getJBossCache().getInvocationContext().getTransactionContext();
                        if (tc != null) {
                            tc.getOrderedSynchronizationHandler().registerAtTail((Synchronization)new TransactionSynchronization(null, cancelAction, null));
                        }
                        cancelAction.run();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("unable to register tx synchronization object", e);
                    }
                } else {
                    cancelAction.run();
                }
            }
        } else {
            this.remove(taskID, true);
        }
        return task;
    }

    void remove(Serializable taskID, boolean removeFromCache) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove() : " + taskID + " - " + removeFromCache));
        }
        this.localRunningTasks.remove(taskID);
        if (removeFromCache) {
            new TimerTaskCacheData(taskID, this.baseFqn, this.cluster).remove();
        }
    }

    private void recover(TimerTaskData taskData) {
        TimerTask task = this.timerTaskFactory.newTimerTask(taskData);
        if (task != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Recovering task with id " + taskData.getTaskID()));
            }
            task.beforeRecover();
            this.schedule(task, false);
        }
    }

    public void shutdownNow() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Shutdown now.");
        }
        this.cluster.removeFailOverListener((FailOverListener)this.clusterClientLocalListener);
        this.cluster.removeDataRemovalListener((DataRemovalListener)this.clusterClientLocalListener);
        this.executor.shutdownNow();
        this.localRunningTasks.clear();
    }

    public String toString() {
        return "FaultTolerantScheduler [ name = " + this.name + " ]";
    }

    public String toDetailedString() {
        return "FaultTolerantScheduler [ name = " + this.name + " , local tasks = " + this.localRunningTasks.size() + " , all tasks " + this.cacheData.getTaskIDs().size() + " ]";
    }

    public void stop() {
        this.shutdownNow();
    }

    private class ClientLocalListener
    implements FailOverListener,
    DataRemovalListener {
        private final byte priority;

        public ClientLocalListener(byte priority) {
            this.priority = priority;
        }

        public Fqn getBaseFqn() {
            return FaultTolerantScheduler.this.baseFqn;
        }

        public ClientLocalListenerElector getElector() {
            return null;
        }

        public byte getPriority() {
            return this.priority;
        }

        public void failOverClusterMember(Address address) {
        }

        public void lostOwnership(ClusteredCacheData clusteredCacheData) {
        }

        public void wonOwnership(ClusteredCacheData clusteredCacheData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("wonOwnership( clusterCacheData = " + clusteredCacheData + ")"));
            }
            try {
                Serializable taskID = TimerTaskCacheData.getTaskID(clusteredCacheData);
                TimerTaskCacheData timerTaskCacheData = new TimerTaskCacheData(taskID, FaultTolerantScheduler.this.baseFqn, FaultTolerantScheduler.this.cluster);
                FaultTolerantScheduler.this.recover(timerTaskCacheData.getTaskData());
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }

        public void dataRemoved(Fqn clusteredCacheDataFqn) {
            TimerTask task;
            Object lastElement = clusteredCacheDataFqn.getLastElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("remote notification dataRemoved( clusterCacheDataFqn = " + clusteredCacheDataFqn + "), lastElement " + lastElement));
            }
            if ((task = (TimerTask)FaultTolerantScheduler.this.localRunningTasks.remove(lastElement)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("remote notification dataRemoved( task = " + task.getData().getTaskID() + " removed locally cancelling it"));
                }
                task.cancel();
            }
        }

        public String toString() {
            return FaultTolerantScheduler.this.toString();
        }
    }
}

