/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.cxdx;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.cxdx.ClientCxDxSession;
import org.jdiameter.api.cxdx.ClientCxDxSessionListener;
import org.jdiameter.api.cxdx.events.JLocationInfoAnswer;
import org.jdiameter.api.cxdx.events.JLocationInfoRequest;
import org.jdiameter.api.cxdx.events.JMultimediaAuthAnswer;
import org.jdiameter.api.cxdx.events.JMultimediaAuthRequest;
import org.jdiameter.api.cxdx.events.JPushProfileAnswer;
import org.jdiameter.api.cxdx.events.JPushProfileRequest;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationAnswer;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationRequest;
import org.jdiameter.api.cxdx.events.JServerAssignmentAnswer;
import org.jdiameter.api.cxdx.events.JServerAssignmentRequest;
import org.jdiameter.api.cxdx.events.JUserAuthorizationAnswer;
import org.jdiameter.api.cxdx.events.JUserAuthorizationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.cxdx.Event;
import org.jdiameter.client.impl.app.cxdx.IClientCxDxSessionData;
import org.jdiameter.common.api.app.cxdx.CxDxSessionState;
import org.jdiameter.common.api.app.cxdx.ICxDxMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.cxdx.CxDxSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxDxClientSessionImpl
extends CxDxSession
implements ClientCxDxSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(CxDxClientSessionImpl.class);
    private transient ClientCxDxSessionListener listener;
    protected long appId = -1L;
    protected IClientCxDxSessionData sessionData;

    public CxDxClientSessionImpl(IClientCxDxSessionData sessionData, ICxDxMessageFactory fct, ISessionFactory sf, ClientCxDxSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == CxDxSessionState.class ? this.sessionData.getCxDxSessionState() : null));
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void sendLocationInformationRequest(JLocationInfoRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendMultimediaAuthRequest(JMultimediaAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendServerAssignmentRequest(JServerAssignmentRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendUserAuthorizationRequest(JUserAuthorizationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendPushProfileAnswer(JPushProfileAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendRegistrationTerminationAnswer(JRegistrationTerminationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            try {
                this.sendAndStateLock.lock();
                if (!this.session.isValid()) {
                    var2_2 = false;
                    var6_5 = null;
                    this.sendAndStateLock.unlock();
                    return var2_2;
                }
                state = this.sessionData.getCxDxSessionState();
                newState = null;
                eventType = (Event.Type)event.getType();
                switch (1.$SwitchMap$org$jdiameter$common$api$app$cxdx$CxDxSessionState[state.ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$cxdx$Event$Type[eventType.ordinal()]) {
                            case 1: {
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                newState = CxDxSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.listener.doPushProfileRequest((ClientCxDxSession)this, (JPushProfileRequest)event.getData());
                                ** break;
                            }
                            case 2: {
                                newState = CxDxSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                this.listener.doRegistrationTerminationRequest((ClientCxDxSession)this, (JRegistrationTerminationRequest)event.getData());
                                ** break;
                            }
                            case 3: {
                                newState = CxDxSessionState.MESSAGE_SENT_RECEIVED;
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                this.setState(newState);
                                ** break;
                            }
                        }
                        CxDxClientSessionImpl.logger.error("Invalid Event Type {} for Cx/Dx Client Session at state {}.", (Object)eventType, (Object)this.sessionData.getCxDxSessionState());
                        ** break;
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$cxdx$Event$Type[eventType.ordinal()]) {
                            case 4: {
                                newState = CxDxSessionState.TIMEDOUT;
                                this.setState(newState);
                                ** break;
                            }
                            case 3: {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                newState = CxDxSessionState.TERMINATED;
                                this.setState(newState);
                                ** break;
                            }
                            case 5: {
                                newState = CxDxSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doLocationInformationAnswer((ClientCxDxSession)this, null, (JLocationInfoAnswer)event.getData());
                                ** break;
                            }
                            case 6: {
                                newState = CxDxSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doMultimediaAuthAnswer((ClientCxDxSession)this, null, (JMultimediaAuthAnswer)event.getData());
                                ** break;
                            }
                            case 7: {
                                newState = CxDxSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doServerAssignmentAnswer((ClientCxDxSession)this, null, (JServerAssignmentAnswer)event.getData());
                                ** break;
                            }
                            case 8: {
                                newState = CxDxSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doUserAuthorizationAnswer((ClientCxDxSession)this, null, (JUserAuthorizationAnswer)event.getData());
                                ** break;
                            }
                        }
                        throw new InternalException("Should not receive more messages after initial. Command: " + event.getData());
                    }
                    case 3: {
                        throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                    }
                    case 4: {
                        throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                    }
                }
                CxDxClientSessionImpl.logger.error("Cx/Dx Client FSM in wrong state: {}", (Object)state);
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
lbl81:
            // 10 sources

        }
        catch (Throwable var5_10) {
            var6_7 = null;
            this.sendAndStateLock.unlock();
            throw var5_10;
        }
        var6_6 = null;
        this.sendAndStateLock.unlock();
        return true;
    }

    protected void setState(CxDxSessionState newState) {
        CxDxSessionState oldState = this.sessionData.getCxDxSessionState();
        this.sessionData.setCxDxSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == CxDxSessionState.TERMINATED || newState == CxDxSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
                Object var4_3 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CxDxClientSessionImpl other = (CxDxClientSessionImpl)obj;
        return this.appId == other.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ClientCxDxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 300: {
                        CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_UAA, null, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createUserAuthorizationAnswer(this.answer)));
                        break;
                    }
                    case 301: {
                        CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SAA, null, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createServerAssignmentAnswer(this.answer)));
                        break;
                    }
                    case 303: {
                        CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_MAA, null, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createMultimediaAuthAnswer(this.answer)));
                        break;
                    }
                    case 302: {
                        CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_LIA, null, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createLocationInfoAnswer(this.answer)));
                        break;
                    }
                    default: {
                        CxDxClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientCxDxSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                if (this.request.getCommandCode() == 304) {
                    CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RTR, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createRegistrationTerminationRequest(this.request), null));
                } else if (this.request.getCommandCode() == 305) {
                    CxDxClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PPR, (AppEvent)CxDxClientSessionImpl.this.messageFactory.createPushProfileRequest(this.request), null));
                } else {
                    CxDxClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

