/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.s6a;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.s6a.ClientS6aSession;
import org.jdiameter.api.s6a.ClientS6aSessionListener;
import org.jdiameter.api.s6a.events.JAuthenticationInformationAnswer;
import org.jdiameter.api.s6a.events.JAuthenticationInformationRequest;
import org.jdiameter.api.s6a.events.JCancelLocationAnswer;
import org.jdiameter.api.s6a.events.JCancelLocationRequest;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JNotifyAnswer;
import org.jdiameter.api.s6a.events.JNotifyRequest;
import org.jdiameter.api.s6a.events.JPurgeUEAnswer;
import org.jdiameter.api.s6a.events.JPurgeUERequest;
import org.jdiameter.api.s6a.events.JResetAnswer;
import org.jdiameter.api.s6a.events.JResetRequest;
import org.jdiameter.api.s6a.events.JUpdateLocationAnswer;
import org.jdiameter.api.s6a.events.JUpdateLocationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.s6a.Event;
import org.jdiameter.client.impl.app.s6a.IClientS6aSessionData;
import org.jdiameter.common.api.app.s6a.IS6aMessageFactory;
import org.jdiameter.common.api.app.s6a.S6aSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.s6a.S6aSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aClientSessionImpl
extends S6aSession
implements ClientS6aSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(S6aClientSessionImpl.class);
    private transient ClientS6aSessionListener listener;
    protected long appId = -1L;
    protected IClientS6aSessionData sessionData;

    public S6aClientSessionImpl(IClientS6aSessionData sessionData, IS6aMessageFactory fct, ISessionFactory sf, ClientS6aSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == S6aSessionState.class ? this.sessionData.getS6aSessionState() : null));
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void sendAuthenticationInformationRequest(JAuthenticationInformationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendPurgeUERequest(JPurgeUERequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendNotifyRequest(JNotifyRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendUpdateLocationRequest(JUpdateLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendCancelLocationAnswer(JCancelLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendInsertSubscriberDataAnswer(JInsertSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendDeleteSubscriberDataAnswer(JDeleteSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendResetAnswer(JResetAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        block28: {
            this.sendAndStateLock.lock();
            if (this.session.isValid()) break block28;
            var2_2 = false;
            var9_5 = null;
            this.sendAndStateLock.unlock();
            return var2_2;
        }
        try {
            try {
                state = this.sessionData.getS6aSessionState();
                newState = null;
                localEvent = (Event)event;
                eventType = (Event.Type)event.getType();
                switch (1.$SwitchMap$org$jdiameter$common$api$app$s6a$S6aSessionState[state.ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$s6a$Event$Type[eventType.ordinal()]) {
                            case 1: {
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                newState = S6aSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.listener.doCancelLocationRequestEvent((ClientS6aSession)this, (JCancelLocationRequest)event.getData());
                                ** break;
                            }
                            case 2: {
                                newState = S6aSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                this.listener.doInsertSubscriberDataRequestEvent((ClientS6aSession)this, (JInsertSubscriberDataRequest)event.getData());
                                ** break;
                            }
                            case 3: {
                                newState = S6aSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                this.listener.doDeleteSubscriberDataRequestEvent((ClientS6aSession)this, (JDeleteSubscriberDataRequest)event.getData());
                                ** break;
                            }
                            case 4: {
                                newState = S6aSessionState.MESSAGE_SENT_RECEIVED;
                                this.setState(newState);
                                this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                                super.startMsgTimer();
                                this.listener.doResetRequestEvent((ClientS6aSession)this, (JResetRequest)event.getData());
                                ** break;
                            }
                            case 5: {
                                newState = S6aSessionState.MESSAGE_SENT_RECEIVED;
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                this.setState(newState);
                                ** break;
                            }
                        }
                        S6aClientSessionImpl.logger.error("Invalid Event Type {} for S6a Client Session at state {}.", (Object)eventType, (Object)this.sessionData.getS6aSessionState());
                        ** break;
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$s6a$Event$Type[eventType.ordinal()]) {
                            case 6: {
                                newState = S6aSessionState.TIMEDOUT;
                                this.setState(newState);
                                ** break;
                            }
                            case 5: {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                var7_11 = null;
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                ** break;
                            }
                            catch (Throwable var6_13) {
                                var7_12 = null;
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                throw var6_13;
                            }
                            case 7: {
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doUpdateLocationAnswerEvent((ClientS6aSession)this, (JUpdateLocationRequest)localEvent.getRequest(), (JUpdateLocationAnswer)localEvent.getAnswer());
                                ** break;
                            }
                            case 8: {
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doAuthenticationInformationAnswerEvent((ClientS6aSession)this, (JAuthenticationInformationRequest)localEvent.getRequest(), (JAuthenticationInformationAnswer)localEvent.getAnswer());
                                ** break;
                            }
                            case 9: {
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doPurgeUEAnswerEvent((ClientS6aSession)this, (JPurgeUERequest)localEvent.getRequest(), (JPurgeUEAnswer)localEvent.getAnswer());
                                ** break;
                            }
                            case 10: {
                                newState = S6aSessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doNotifyAnswerEvent((ClientS6aSession)this, (JNotifyRequest)localEvent.getRequest(), (JNotifyAnswer)localEvent.getAnswer());
                                ** break;
                            }
                        }
                        throw new InternalException("Unexpected/Unknown message received: " + event.getData());
                    }
                    case 3: {
                        throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                    }
                    case 4: {
                        throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                    }
                    default: {
                        S6aClientSessionImpl.logger.error("S6a Client FSM in wrong state: {}", (Object)state);
                    }
                }
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
lbl107:
            // 13 sources

            var9_6 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable var8_14) {
            var9_7 = null;
            this.sendAndStateLock.unlock();
            throw var8_14;
        }
        return true;
    }

    protected void setState(S6aSessionState newState) {
        S6aSessionState oldState = this.sessionData.getS6aSessionState();
        this.sessionData.setS6aSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == S6aSessionState.TERMINATED || newState == S6aSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
                Object var4_3 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S6aClientSessionImpl other = (S6aClientSessionImpl)obj;
        return this.appId == other.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ClientS6aSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 316: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ULA, (AppEvent)S6aClientSessionImpl.this.messageFactory.createUpdateLocationRequest(this.request), (AppEvent)S6aClientSessionImpl.this.messageFactory.createUpdateLocationAnswer(this.answer)));
                        break;
                    }
                    case 318: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AIA, (AppEvent)S6aClientSessionImpl.this.messageFactory.createAuthenticationInformationRequest(this.request), (AppEvent)S6aClientSessionImpl.this.messageFactory.createAuthenticationInformationAnswer(this.answer)));
                        break;
                    }
                    case 321: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUA, (AppEvent)S6aClientSessionImpl.this.messageFactory.createPurgeUERequest(this.request), (AppEvent)S6aClientSessionImpl.this.messageFactory.createPurgeUEAnswer(this.answer)));
                        break;
                    }
                    case 323: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_NOA, (AppEvent)S6aClientSessionImpl.this.messageFactory.createNotifyRequest(this.request), (AppEvent)S6aClientSessionImpl.this.messageFactory.createNotifyAnswer(this.answer)));
                        break;
                    }
                    default: {
                        S6aClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientS6aSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 317: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_CLR, (AppEvent)S6aClientSessionImpl.this.messageFactory.createCancelLocationRequest(this.request), null));
                        break;
                    }
                    case 319: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_IDR, (AppEvent)S6aClientSessionImpl.this.messageFactory.createInsertSubscriberDataRequest(this.request), null));
                        break;
                    }
                    case 320: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_DSR, (AppEvent)S6aClientSessionImpl.this.messageFactory.createDeleteSubscriberDataRequest(this.request), null));
                        break;
                    }
                    case 322: {
                        S6aClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RSR, (AppEvent)S6aClientSessionImpl.this.messageFactory.createResetRequest(this.request), null));
                        break;
                    }
                    default: {
                        S6aClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

