/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.sh;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.ClientShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.sh.Event;
import org.jdiameter.client.impl.app.sh.IShClientSessionData;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationRequestImpl;
import org.jdiameter.common.impl.app.sh.ShSession;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShClientSessionImpl
extends ShSession
implements ClientShSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private Logger logger = LoggerFactory.getLogger(ShClientSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IShMessageFactory factory = null;
    protected transient ClientShSessionListener listener;
    protected IShClientSessionData sessionData;

    public ShClientSessionImpl(IShClientSessionData sessionData, IShMessageFactory fct, ISessionFactory sf, ClientShSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.listener = lst;
        this.factory = fct;
        this.sessionData = sessionData;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public <E> E getState(Class<E> stateType) {
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            try {
                this.sendAndStateLock.lock();
                localEvent = (Event)event;
                switch (1.$SwitchMap$org$jdiameter$client$impl$app$sh$Event$Type[((Event.Type)localEvent.getType()).ordinal()]) {
                    case 1: {
                        this.listener.doPushNotificationRequestEvent((ClientShSession)this, (PushNotificationRequest)new PushNotificationRequestImpl((Request)localEvent.getRequest().getMessage()));
                        ** break;
                    }
                    case 2: {
                        this.listener.doProfileUpdateAnswerEvent((ClientShSession)this, null, (ProfileUpdateAnswer)new ProfileUpdateAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                        ** break;
                    }
                    case 3: {
                        this.listener.doUserDataAnswerEvent((ClientShSession)this, null, (UserDataAnswer)new UserDataAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                        ** break;
                    }
                    case 4: {
                        this.listener.doSubscribeNotificationsAnswerEvent((ClientShSession)this, null, (SubscribeNotificationsAnswer)new SubscribeNotificationsAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                        ** break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        m = null;
                        data = event.getData();
                        m = data instanceof AppEvent != false ? ((AppEvent)data).getMessage() : (Message)event.getData();
                        this.session.send(m, (EventListener)this);
                        ** break;
                    }
                    case 9: {
                        ** break;
                    }
                }
                this.logger.error("Wrong message type={} req={} ans={}", new Object[]{localEvent.getType(), localEvent.getRequest(), localEvent.getAnswer()});
            }
            catch (IllegalDiameterStateException idse) {
                throw new InternalException((Throwable)idse);
            }
            catch (RouteException re) {
                throw new InternalException((Throwable)re);
            }
lbl32:
            // 7 sources

            var6_7 = null;
            this.sendAndStateLock.unlock();
            return true;
        }
        catch (Throwable var5_9) {
            var6_8 = null;
            this.sendAndStateLock.unlock();
            throw var5_9;
        }
    }

    public void sendProfileUpdateRequest(ProfileUpdateRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PROFILE_UPDATE_REQUEST, (AppEvent)request, null);
    }

    public void sendPushNotificationAnswer(PushNotificationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PUSH_NOTIFICATION_ANSWER, null, (AppEvent)answer);
    }

    public void sendSubscribeNotificationsRequest(SubscribeNotificationsRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SUBSCRIBE_NOTIFICATIONS_REQUEST, (AppEvent)request, null);
    }

    public void sendUserDataRequest(UserDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_USER_DATA_REQUEST, (AppEvent)request, null);
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            block4: {
                try {
                    this.sendAndStateLock.lock();
                    if (type == null) break block4;
                    this.handleEvent(new Event(type, request, answer));
                }
                catch (Exception e) {
                    throw new InternalException((Throwable)e);
                }
            }
            Object var6_4 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            if (request.getApplicationId() == this.factory.getApplicationId()) {
                if (request.getCommandCode() == 307) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createProfileUpdateRequest(request), null));
                    return;
                }
                if (request.getCommandCode() == 306) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createUserDataRequest(request), null));
                    return;
                }
                if (request.getCommandCode() == 308) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createSubscribeNotificationsRequest(request), null));
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    this.logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            this.logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    public boolean isStateless() {
        return true;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public void onTimer(String timerName) {
    }

    private class AnswerDelivery
    implements Runnable {
        ClientShSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                block10: {
                    block9: {
                        try {
                            try {
                                ShClientSessionImpl.this.sendAndStateLock.lock();
                                if (this.request.getApplicationId() == ShClientSessionImpl.this.factory.getApplicationId()) {
                                    if (this.request.getCommandCode() == 307) {
                                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PROFILE_UPDATE_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createProfileUpdateRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createProfileUpdateAnswer(this.answer)));
                                        Object var3_1 = null;
                                        ShClientSessionImpl.this.sendAndStateLock.unlock();
                                        return;
                                    }
                                    if (this.request.getCommandCode() == 306) {
                                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_USER_DATA_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createUserDataRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createUserDataAnswer(this.answer)));
                                        break block9;
                                    }
                                    if (this.request.getCommandCode() == 308) {
                                        ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SUBSCRIBE_NOTIFICATIONS_ANSWER, (AppEvent)ShClientSessionImpl.this.factory.createSubscribeNotificationsRequest(this.request), (AppEvent)ShClientSessionImpl.this.factory.createSubscribeNotificationsAnswer(this.answer)));
                                        break block10;
                                    }
                                }
                                ShClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                                break block11;
                            }
                            catch (Exception e) {
                                ShClientSessionImpl.this.logger.debug("Failed to process success message", (Throwable)e);
                                Object var3_5 = null;
                                ShClientSessionImpl.this.sendAndStateLock.unlock();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_6 = null;
                            ShClientSessionImpl.this.sendAndStateLock.unlock();
                            throw throwable;
                        }
                    }
                    Object var3_2 = null;
                    ShClientSessionImpl.this.sendAndStateLock.unlock();
                    return;
                }
                Object var3_3 = null;
                ShClientSessionImpl.this.sendAndStateLock.unlock();
                return;
            }
            Object var3_4 = null;
            ShClientSessionImpl.this.sendAndStateLock.unlock();
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientShSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                if (this.request.getApplicationId() == ShClientSessionImpl.this.factory.getApplicationId() && this.request.getCommandCode() == 309) {
                    ShClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUSH_NOTIFICATION_REQUEST, (AppEvent)ShClientSessionImpl.this.factory.createPushNotificationRequest(this.request), null));
                    return;
                }
                ShClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
            }
            catch (Exception e) {
                ShClientSessionImpl.this.logger.debug("Failed to process request {}", (Object)this.request, (Object)e);
            }
        }
    }
}

