/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.controller;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.MetaData;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Peer;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.URI;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.api.validation.Dictionary;
import org.jdiameter.client.api.IAssembler;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IMetaData;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IPeerTable;
import org.jdiameter.client.api.fsm.IFsmFactory;
import org.jdiameter.client.api.io.ITransportLayerFactory;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.router.IRouter;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.client.impl.controller.PeerImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerTableImpl
implements IPeerTable {
    private static final Logger logger = LoggerFactory.getLogger(PeerTableImpl.class);
    protected ConcurrentHashMap<String, Peer> peerTable = new ConcurrentHashMap();
    protected boolean isStarted;
    protected long stopTimeOut;
    protected IAssembler assembler;
    protected IRouter router;
    protected MetaData metaData;
    protected IConcurrentFactory concurrentFactory;
    protected ISessionDatasource sessionDatasource;
    protected final Dictionary dictionary = DictionarySingleton.getDictionary();

    protected PeerTableImpl() {
    }

    public PeerTableImpl(Configuration globalConfig, MetaData metaData, IContainer stack, IRouter router, IFsmFactory fsmFactory, ITransportLayerFactory transportFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser) {
        this.init(stack, router, globalConfig, metaData, fsmFactory, transportFactory, statisticFactory, concurrentFactory, parser);
    }

    protected void init(IContainer stack, IRouter router, Configuration globalConfig, MetaData metaData, IFsmFactory fsmFactory, ITransportLayerFactory transportFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser) {
        logger.debug("Initializing Peer Table.");
        this.router = router;
        this.metaData = metaData;
        this.concurrentFactory = concurrentFactory;
        this.stopTimeOut = globalConfig.getLongValue(Parameters.StopTimeOut.ordinal(), ((Long)Parameters.StopTimeOut.defValue()).longValue());
        this.sessionDatasource = stack.getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        logger.debug("Populating peerTable from configuration");
        Configuration[] peers = globalConfig.getChildren(Parameters.PeerTable.ordinal());
        if (peers != null && peers.length > 0) {
            for (Configuration peerConfig : peers) {
                if (!peerConfig.isAttributeExist(Parameters.PeerName.ordinal())) continue;
                String uri = peerConfig.getStringValue(Parameters.PeerName.ordinal(), null);
                int rating = peerConfig.getIntValue(Parameters.PeerRating.ordinal(), 0);
                String ip = peerConfig.getStringValue(Parameters.PeerIp.ordinal(), null);
                String portRange = peerConfig.getStringValue(Parameters.PeerLocalPortRange.ordinal(), null);
                try {
                    IPeer peer = (IPeer)this.createPeer(rating, uri, ip, portRange, metaData, globalConfig, peerConfig, fsmFactory, transportFactory, statisticFactory, concurrentFactory, parser);
                    if (peer == null) continue;
                    peer.setRealm(router.getRealmTable().getRealmForPeer(peer.getUri().getFQDN()));
                    this.peerTable.put(peer.getUri().getFQDN(), peer);
                    logger.debug("Appended peer [{}] to peer table", (Object)peer);
                }
                catch (Exception e) {
                    logger.warn("Unable to create peer [" + uri + "]", (Throwable)e);
                }
            }
        }
    }

    protected Peer createPeer(int rating, String uri, String ip, String portRange, MetaData metaData, Configuration config, Configuration peerConfig, IFsmFactory fsmFactory, ITransportLayerFactory transportFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser) throws InternalException, TransportException, URISyntaxException, UnknownServiceException {
        return new PeerImpl(this, rating, new URI(uri), ip, portRange, (IMetaData)metaData.unwrap(IMetaData.class), config, peerConfig, fsmFactory, transportFactory, statisticFactory, concurrentFactory, parser, this.sessionDatasource);
    }

    public List<Peer> getPeerTable() {
        return new ArrayList<Peer>(this.peerTable.values());
    }

    @Override
    public void sendMessage(IMessage message) throws IllegalDiameterStateException, RouteException, AvpDataException, IOException {
        IPeer peer;
        if (!this.isStarted) {
            throw new IllegalDiameterStateException("Stack is down");
        }
        if (message.isRequest()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Send request {} [destHost={}; destRealm={}]", new Object[]{message, message.getAvps().getAvp(293) != null ? (Object)message.getAvps().getAvp(293).getOctetString() : "", message.getAvps().getAvp(283) != null ? (Object)message.getAvps().getAvp(283).getOctetString() : ""});
            }
            if (this.router.updateRoute(message) && logger.isDebugEnabled()) {
                logger.debug("Updated route on message {} [destHost={}; destRealm={}]", new Object[]{message, message.getAvps().getAvp(293) != null ? (Object)message.getAvps().getAvp(293).getOctetString() : "", message.getAvps().getAvp(283) != null ? (Object)message.getAvps().getAvp(283).getOctetString() : ""});
            }
            peer = this.router.getPeer(message, this);
            logger.debug("Selected peer [{}] for sending message [{}]", (Object)peer, (Object)message);
            if (peer == this.metaData.getLocalPeer()) {
                logger.debug("Request [{}] will be processed by local service", (Object)message);
            } else {
                message.setHopByHopIdentifier(peer.getHopByHopIdentifier());
                peer.addMessage(message);
                message.setPeer(peer);
            }
        } else {
            logger.debug("Message is an answer");
            peer = message.getPeer();
            if (peer == null) {
                logger.debug("Peer is null so we will use router.getPeer to find a peer");
                peer = this.router.getPeer(message, this);
                if (peer == null) {
                    throw new RouteException("Cannot found remote context for sending message");
                }
                logger.debug("Found a peer [{}] and setting it as the peer in the message", (Object)peer);
                message.setPeer(peer);
            }
        }
        try {
            logger.debug("Calling sendMessage on peer [{}]", (Object)peer);
            if (!peer.sendMessage(message)) {
                throw new IOException("Can not send message");
            }
            logger.debug("Message was submitted to be sent, now adding statistics");
            if (message.isRequest()) {
                if (peer.getStatistic().isEnabled()) {
                    peer.getStatistic().getRecordByName(IStatisticRecord.Counters.AppGenRequest.name()).inc();
                }
            } else if (peer.getStatistic().isEnabled()) {
                peer.getStatistic().getRecordByName(IStatisticRecord.Counters.AppGenResponse.name()).inc();
            }
        }
        catch (Exception e) {
            logger.error("Can not send message", (Throwable)e);
            if (message.isRequest()) {
                if (peer.getStatistic().isEnabled()) {
                    peer.getStatistic().getRecordByName(IStatisticRecord.Counters.AppGenRejectedRequest.name()).inc();
                }
            } else if (peer.getStatistic().isEnabled()) {
                peer.getStatistic().getRecordByName(IStatisticRecord.Counters.AppGenRejectedResponse.name()).inc();
            }
            if (e instanceof AvpNotAllowedException) {
                throw (AvpNotAllowedException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void addSessionReqListener(String sessionId, NetworkReqListener listener) {
        logger.debug("Adding sessionId [{}] to sessionDatasource", (Object)sessionId);
        this.sessionDatasource.setSessionListener(sessionId, listener);
    }

    @Override
    public Map<String, NetworkReqListener> getSessionReqListeners() {
        return null;
    }

    @Override
    public IPeer getPeer(String fqdn) {
        logger.debug("In getPeer for peer with FQDN [{}]. Going to find a matching entry in peerTable", (Object)fqdn);
        IPeer peer = (IPeer)this.peerTable.get(fqdn);
        if (peer == null) {
            logger.debug("No peer found in getPeer for peer [{}] will return null", (Object)fqdn);
            return null;
        }
        logger.debug("Found matching peer [{}]. Is connection open ? {}.", (Object)peer.getUri(), (Object)peer.hasValidConnection());
        return peer;
    }

    @Override
    public void removeSessionListener(String sessionId) {
        this.sessionDatasource.removeSessionListener(sessionId);
    }

    @Override
    public void setAssembler(IAssembler assembler) {
        this.assembler = assembler;
    }

    @Override
    public void start() throws IllegalDiameterStateException, IOException {
        logger.debug("Starting PeerTable. Going to call connect on all peers in the peerTable");
        for (Peer peer : this.peerTable.values()) {
            try {
                peer.connect();
            }
            catch (Exception e) {
                logger.warn("Can not start connect procedure to peer [" + peer + "]", (Throwable)e);
            }
        }
        logger.debug("Calling start on the router");
        this.router.start();
        this.isStarted = true;
    }

    @Override
    public void stopped() {
        logger.debug("Calling stopped() on PeerTableImpl");
        for (Peer p : this.peerTable.values()) {
            for (IMessage m : ((IPeer)p).remAllMessage()) {
                try {
                    m.runTimer();
                }
                catch (Exception e) {
                    logger.debug("Unable to stop timer on message", (Throwable)e);
                }
            }
        }
        if (this.concurrentFactory != null) {
            try {
                long remWaitTime = 2000L;
                logger.debug("Stopping thread group and waiting a max of {}ms for all threads to finish", (Object)remWaitTime);
                while (this.concurrentFactory.getThreadGroup().activeCount() > 0 && remWaitTime > 0L) {
                    long waitTime = 250L;
                    Thread.sleep(waitTime);
                    logger.debug("Waited {}ms. Time remaining to wait: {}ms. {} Thread still active.", new Object[]{waitTime, remWaitTime -= waitTime, this.concurrentFactory.getThreadGroup().activeCount()});
                }
            }
            catch (Exception e) {
                logger.warn("Unable to stop executor");
            }
        }
        this.router.stop();
    }

    @Override
    public void stopping(int disconnectCause) {
        logger.debug("In stopping. Going to disconnect all peers in peer table");
        this.isStarted = false;
        for (Peer peer : this.peerTable.values()) {
            try {
                peer.disconnect(disconnectCause);
            }
            catch (Exception e) {
                logger.warn("Failure disconnecting peer [" + peer.getUri().toString() + "]", (Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        logger.debug("In destroy. Going to destroy concurrentFactory's thread group");
        if (this.concurrentFactory != null) {
            // empty if block
        }
        if (this.router != null) {
            logger.debug("Calling destroy on router");
            this.router.destroy();
        }
        this.router = null;
        this.peerTable = null;
        this.assembler = null;
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    protected class PeerTableThreadFactory
    implements ThreadFactory {
        public final AtomicLong sequence = new AtomicLong(0L);
        private int priority = 5;
        private ThreadGroup factoryThreadGroup = new ThreadGroup("JDiameterThreadGroup[" + this.sequence.incrementAndGet() + "]");

        public PeerTableThreadFactory(int priority) {
            this.priority = priority;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.factoryThreadGroup, r);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating new thread in thread group JDiameterThreadGroup. Thread name is [{}]", (Object)t.getName());
            }
            t.setPriority(this.priority);
            return t;
        }
    }
}

