/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.URI;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.parser.AvpImpl;
import org.jdiameter.client.impl.parser.ElementParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AvpSetImpl
implements AvpSet {
    private static final long serialVersionUID = 1L;
    private static final ElementParser parser = new ElementParser();
    List<Avp> avps = new ArrayList<Avp>();

    AvpSetImpl() {
    }

    public Avp getAvp(int avpCode) {
        for (Avp avp : this.avps) {
            if (avp.getCode() != avpCode) continue;
            return avp;
        }
        return null;
    }

    public Avp getAvpByIndex(int avpIndex) {
        return this.avps.get(avpIndex);
    }

    public Avp getAvp(int avpCode, long vendorId) {
        for (Avp avp : this.avps) {
            if (avp.getCode() != avpCode || avp.getVendorId() != vendorId) continue;
            return avp;
        }
        return null;
    }

    public AvpSet getAvps(int avpCode) {
        AvpSetImpl result = new AvpSetImpl();
        for (Avp avp : this.avps) {
            if (avp.getCode() != avpCode) continue;
            result.addAvp(new Avp[]{avp});
        }
        return result;
    }

    public AvpSet getAvps(int avpCode, long vendorId) {
        AvpSetImpl result = new AvpSetImpl();
        for (Avp avp : this.avps) {
            if (avp.getCode() != avpCode || avp.getVendorId() != vendorId) continue;
            result.addAvp(new Avp[]{avp});
        }
        return result;
    }

    public AvpSet removeAvp(int avpCode) {
        return this.removeAvp(avpCode, 0L);
    }

    public AvpSet removeAvp(int avpCode, long vendorId) {
        AvpSetImpl result = new AvpSetImpl();
        Iterator<Avp> it = this.avps.iterator();
        while (it.hasNext()) {
            Avp avp = it.next();
            if (avp.getCode() != avpCode || avp.getVendorId() != vendorId) continue;
            result.addAvp(new Avp[]{avp});
            it.remove();
        }
        return result;
    }

    public Avp removeAvpByIndex(int i) {
        return i >= this.avps.size() ? null : this.avps.remove(i);
    }

    public Avp[] asArray() {
        return this.avps.toArray(new Avp[this.avps.size()]);
    }

    public Avp addAvp(int avpCode, long value, boolean asUnsigned) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, long value, boolean mFlag, boolean pFlag, boolean asUnsigned) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, long value, long vndId, boolean mFlag, boolean pFlag, boolean asUnsigned) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public void insertAvp(int index, Avp ... avps) {
        this.avps.addAll(index, Arrays.asList(avps));
    }

    public void insertAvp(int index, AvpSet avpSet) {
        this.avps.addAll(index, Arrays.asList(avpSet.asArray()));
    }

    public Avp insertAvp(int index, int avpCode, long value, boolean asUnsigned) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, long value, boolean mFlag, boolean pFlag, boolean asUnsigned) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, long value, long vndId, boolean mFlag, boolean pFlag, boolean asUnsigned) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, asUnsigned ? parser.intU32ToBytes(value) : parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public AvpSet insertGroupedAvp(int index, int avpCode) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(index, res);
        return res.groupedData;
    }

    public int size() {
        return this.avps.size();
    }

    public void addAvp(AvpSet avpSet) {
        for (Avp a : avpSet) {
            this.avps.add(a);
        }
    }

    public void addAvp(Avp ... avps) {
        for (Avp a : avps) {
            if (a == null) continue;
            this.avps.add(a);
        }
    }

    public Avp addAvp(int avpCode, byte[] rawData) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, rawData);
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, byte[] rawData, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, rawData);
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, byte[] rawData, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, rawData);
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, int value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.int32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, int value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.int32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, int value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.int32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, long value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, long value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, long value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.int64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, float value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.float32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, float value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.float32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, float value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.float32ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, double value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.float64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, double value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.float64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, double value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.float64ToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, String value, boolean asOctetString) {
        try {
            AvpImpl res = new AvpImpl(avpCode, 0, 0L, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, String value, boolean mFlag, boolean pFlag, boolean asOctetString) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, 0L, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, String value, long vndId, boolean mFlag, boolean pFlag, boolean asOctetString) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, vndId, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, URI value) {
        try {
            AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.octetStringToBytes(value.toString()));
            this.avps.add(res);
            return res;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, URI value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.octetStringToBytes(value.toString()));
            this.avps.add(res);
            return res;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, URI value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.octetStringToBytes(value.toString()));
            this.avps.add(res);
            return res;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp addAvp(int avpCode, InetAddress value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.addressToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, InetAddress value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.addressToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, InetAddress value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.addressToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, Date value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.dateToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, Date value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.dateToBytes(value));
        this.avps.add(res);
        return res;
    }

    public Avp addAvp(int avpCode, Date value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.dateToBytes(value));
        this.avps.add(res);
        return res;
    }

    public AvpSet addGroupedAvp(int avpCode) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(res);
        return res.groupedData;
    }

    public AvpSet addGroupedAvp(int avpCode, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(res);
        return res.groupedData;
    }

    public AvpSet addGroupedAvp(int avpCode, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(res);
        return res.groupedData;
    }

    public Avp insertAvp(int index, int avpCode, byte[] value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, value);
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, byte[] value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, value);
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, byte[] value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, value);
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, int value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.int32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, int value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.int32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, int value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.int32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, long value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.int64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, long value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.int64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, long value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.int64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, float value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.float32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, float value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.float32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, float value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.float32ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, double value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.float64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, double value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.float64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, double value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.float64ToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, String value, boolean asOctetString) {
        try {
            AvpImpl res = new AvpImpl(avpCode, 0, 0L, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, String value, boolean mFlag, boolean pFlag, boolean asOctetString) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, 0L, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, String value, long vndId, boolean mFlag, boolean pFlag, boolean asOctetString) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, vndId, asOctetString ? parser.octetStringToBytes(value) : parser.utf8StringToBytes(value));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, URI value) {
        try {
            AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.octetStringToBytes(value.toString()));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, URI value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.octetStringToBytes(value.toString()));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, URI value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        try {
            AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.octetStringToBytes(value.toString()));
            this.avps.add(index, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Avp insertAvp(int index, int avpCode, InetAddress value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.addressToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, InetAddress value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.addressToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, InetAddress value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.addressToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, Date value) {
        AvpImpl res = new AvpImpl(avpCode, 0, 0L, parser.dateToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, Date value, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, parser.dateToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public Avp insertAvp(int index, int avpCode, Date value, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, parser.dateToBytes(value));
        this.avps.add(index, res);
        return res;
    }

    public AvpSet insertGroupedAvp(int index, int avpCode, boolean mFlag, boolean pFlag) {
        int flags = (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, 0L, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(index, res);
        return res.groupedData;
    }

    public AvpSet insertGroupedAvp(int index, int avpCode, long vndId, boolean mFlag, boolean pFlag) {
        int flags = (vndId != 0L ? 128 : 0) | (mFlag ? 64 : 0) | (pFlag ? 32 : 0);
        AvpImpl res = new AvpImpl(avpCode, flags, vndId, new byte[0]);
        res.groupedData = new AvpSetImpl();
        this.avps.add(index, res);
        return res.groupedData;
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    public Iterator<Avp> iterator() {
        return this.avps.iterator();
    }

    public String toString() {
        return new StringBuffer("AvpSetImpl [avps=").append(this.avps).append("]@").append(super.hashCode()).toString();
    }
}

