/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.client.api.IEventListener;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.impl.parser.AvpSetImpl;
import org.jdiameter.client.impl.parser.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements IMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MessageImpl.class);
    private static final MessageParser parser = new MessageParser();
    int state = 0;
    short version = 1;
    short flags;
    int commandCode;
    long applicationId;
    long hopByHopId;
    boolean notMutableHopByHop;
    long endToEndId;
    AvpSetImpl avpSet;
    boolean isNetworkRequest = false;
    transient IPeer peer;
    transient TimerTask timerTask;
    transient IEventListener listener;
    transient List<ApplicationId> applicationIds;

    MessageImpl(int commandCode, long appId) {
        this.commandCode = commandCode;
        this.applicationId = appId;
        this.avpSet = new AvpSetImpl();
        this.endToEndId = parser.getNextEndToEndId();
    }

    MessageImpl(int commandCode, long applicationId, short flags, long hopByHopId, long endToEndId, AvpSetImpl avpSet) {
        this(commandCode, applicationId);
        this.flags = flags;
        this.hopByHopId = hopByHopId;
        this.endToEndId = endToEndId;
        if (avpSet != null) {
            this.avpSet = avpSet;
        }
    }

    private MessageImpl(MessageImpl request) {
        this(request.getCommandCode(), request.getHeaderApplicationId());
        this.copyHeader(request);
        this.setRequest(false);
        parser.copyBasicAvps(this, request, true);
    }

    public byte getVersion() {
        return (byte)this.version;
    }

    public boolean isRequest() {
        return (this.flags & 0x80) != 0;
    }

    public void setRequest(boolean b) {
        this.flags = b ? (short)(this.flags | 0x80) : (short)(this.flags & 0x7F);
    }

    public boolean isProxiable() {
        return (this.flags & 0x40) != 0;
    }

    public void setProxiable(boolean b) {
        this.flags = b ? (short)(this.flags | 0x40) : (short)(this.flags & 0xBF);
    }

    public boolean isError() {
        return (this.flags & 0x20) != 0;
    }

    public void setError(boolean b) {
        this.flags = b ? (short)(this.flags | 0x20) : (short)(this.flags & 0xDF);
    }

    public boolean isReTransmitted() {
        return (this.flags & 0x10) != 0;
    }

    public void setReTransmitted(boolean b) {
        this.flags = b ? (short)(this.flags | 0x10) : (short)(this.flags & 0xEF);
    }

    public int getCommandCode() {
        return this.commandCode;
    }

    public String getSessionId() {
        try {
            Avp avpSessionId = this.avpSet.getAvp(263);
            return avpSessionId != null ? avpSessionId.getUTF8String() : null;
        }
        catch (AvpDataException ade) {
            logger.error("Failed to fetch Session-Id", (Throwable)ade);
            return null;
        }
    }

    public Answer createAnswer() {
        MessageImpl answer = new MessageImpl(this);
        return answer;
    }

    public Answer createAnswer(long resultCode) {
        MessageImpl answer = new MessageImpl(this);
        try {
            answer.getAvps().addAvp(268, resultCode, true, false, true);
        }
        catch (Exception e) {
            logger.debug("Can not create answer message", (Throwable)e);
        }
        return answer;
    }

    public Answer createAnswer(long vendorId, long experementalResultCode) {
        MessageImpl answer = new MessageImpl(this);
        try {
            AvpSet exp_code = answer.getAvps().addGroupedAvp(297, true, false);
            exp_code.addAvp(266, vendorId, true, false, true);
            exp_code.addAvp(298, experementalResultCode, true, false, true);
        }
        catch (Exception e) {
            logger.debug("Can not create answer message", (Throwable)e);
        }
        answer.setRequest(false);
        return answer;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    @Override
    public ApplicationId getSingleApplicationId() {
        return this.getSingleApplicationId(this.applicationId);
    }

    public List<ApplicationId> getApplicationIdAvps() {
        if (this.applicationIds != null) {
            return this.applicationIds;
        }
        ArrayList<ApplicationId> rc = new ArrayList<ApplicationId>();
        try {
            AvpSet authAppId = this.avpSet.getAvps(258);
            for (Avp anAuthAppId : authAppId) {
                rc.add(ApplicationId.createByAuthAppId((long)anAuthAppId.getInteger32()));
            }
            AvpSet accAppId = this.avpSet.getAvps(259);
            for (Avp anAccAppId : accAppId) {
                rc.add(ApplicationId.createByAccAppId((long)anAccAppId.getInteger32()));
            }
            AvpSet specAppId = this.avpSet.getAvps(260);
            for (Avp aSpecAppId : specAppId) {
                long vendorId = 0L;
                long acctApplicationId = 0L;
                long authApplicationId = 0L;
                AvpSet avps = aSpecAppId.getGrouped();
                for (Avp localAvp : avps) {
                    if (localAvp.getCode() == 266) {
                        vendorId = localAvp.getUnsigned32();
                    }
                    if (localAvp.getCode() == 258) {
                        authApplicationId = localAvp.getUnsigned32();
                    }
                    if (localAvp.getCode() != 259) continue;
                    acctApplicationId = localAvp.getUnsigned32();
                }
                if (authApplicationId != 0L) {
                    rc.add(ApplicationId.createByAuthAppId((long)vendorId, (long)authApplicationId));
                }
                if (acctApplicationId == 0L) continue;
                rc.add(ApplicationId.createByAccAppId((long)vendorId, (long)acctApplicationId));
            }
        }
        catch (Exception exception) {
            return new ArrayList<ApplicationId>();
        }
        this.applicationIds = rc;
        return this.applicationIds;
    }

    @Override
    public ApplicationId getSingleApplicationId(long applicationId) {
        logger.debug("In getSingleApplicationId for application id [{}]", (Object)applicationId);
        List<ApplicationId> appIds = this.getApplicationIdAvps();
        logger.debug("Application Ids in this message are:");
        ApplicationId firstOverall = null;
        ApplicationId firstWithZeroVendor = null;
        ApplicationId firstWithNonZeroVendor = null;
        for (ApplicationId id : appIds) {
            logger.debug("[{}]", (Object)id);
            if (firstOverall == null) {
                firstOverall = id;
            }
            if (applicationId == 0L) continue;
            if (firstWithZeroVendor == null && id.getVendorId() == 0L && (applicationId == id.getAuthAppId() || applicationId == id.getAcctAppId())) {
                firstWithZeroVendor = id;
            }
            if (firstWithNonZeroVendor != null || id.getVendorId() == 0L || applicationId != id.getAuthAppId() && applicationId != id.getAcctAppId()) continue;
            firstWithNonZeroVendor = id;
            break;
        }
        ApplicationId toReturn = null;
        if (firstWithNonZeroVendor != null) {
            toReturn = firstWithNonZeroVendor;
            logger.debug("Returning [{}] as the first application id because its the first vendor specific one found", toReturn);
        } else if (firstWithZeroVendor != null) {
            toReturn = firstWithZeroVendor;
            logger.debug("Returning [{}] as the first application id because there are no vendor specific ones found", (Object)toReturn);
        } else {
            toReturn = firstOverall;
            logger.debug("Returning [{}] as the first application id because none with the requested app ids were found", (Object)toReturn);
        }
        if (toReturn == null) {
            logger.debug("There are no Application-Id AVPs. Using the value in the header and assuming as Auth Application-Id [{}]", (Object)this.applicationId);
            toReturn = ApplicationId.createByAuthAppId((long)this.applicationId);
        }
        return toReturn;
    }

    public long getHopByHopIdentifier() {
        return this.hopByHopId;
    }

    public long getEndToEndIdentifier() {
        return this.endToEndId;
    }

    public AvpSet getAvps() {
        return this.avpSet;
    }

    protected void copyHeader(MessageImpl request) {
        this.endToEndId = request.endToEndId;
        this.hopByHopId = request.hopByHopId;
        this.version = request.version;
        this.flags = request.flags;
        this.peer = request.peer;
    }

    public Avp getResultCode() {
        return this.getAvps().getAvp(268);
    }

    @Override
    public void setNetworkRequest(boolean isNetworkRequest) {
        this.isNetworkRequest = isNetworkRequest;
    }

    public boolean isNetworkRequest() {
        return this.isNetworkRequest;
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public void setHopByHopIdentifier(long hopByHopId) {
        if (hopByHopId < 0L) {
            this.hopByHopId = -hopByHopId;
            this.notMutableHopByHop = true;
        } else if (!this.notMutableHopByHop) {
            this.hopByHopId = hopByHopId;
        }
    }

    @Override
    public void setEndToEndIdentifier(long endByEndId) {
        this.endToEndId = endByEndId;
    }

    @Override
    public IPeer getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(IPeer peer) {
        this.peer = peer;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public long getHeaderApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setHeaderApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setState(int newState) {
        this.state = newState;
    }

    @Override
    public void createTimer(ScheduledExecutorService scheduledFacility, long timeOut, TimeUnit timeUnit) {
        this.timerTask = new TimerTask(this);
        this.timerTask.setTimerHandler(scheduledFacility, scheduledFacility.schedule(this.timerTask, timeOut, timeUnit));
    }

    @Override
    public void runTimer() {
        if (this.timerTask != null && !this.timerTask.isDone() && !this.timerTask.isCancelled()) {
            this.timerTask.run();
        }
    }

    @Override
    public boolean isTimeOut() {
        return this.timerTask != null && this.timerTask.isDone() && !this.timerTask.isCancelled();
    }

    @Override
    public void setListener(IEventListener listener) {
        this.listener = listener;
    }

    @Override
    public IEventListener getEventListener() {
        return this.listener;
    }

    @Override
    public void clearTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    public String toString() {
        return "MessageImpl{commandCode=" + this.commandCode + ", flags=" + this.flags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageImpl message = (MessageImpl)o;
        return this.applicationId == message.applicationId && this.commandCode == message.commandCode && this.endToEndId == message.endToEndId && this.hopByHopId == message.hopByHopId;
    }

    public int hashCode() {
        long result = this.commandCode;
        result = 31L * result + this.applicationId;
        result = 31L * result + this.hopByHopId;
        result = 31L * result + this.endToEndId;
        return new Long(result).hashCode();
    }

    @Override
    public String getDuplicationKey() {
        try {
            return this.getDuplicationKey(this.getAvps().getAvp(264).getDiameterIdentity(), this.getEndToEndIdentifier());
        }
        catch (AvpDataException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getDuplicationKey(String host, long endToEndId) {
        return host + endToEndId;
    }

    @Override
    public Object clone() {
        try {
            return parser.createMessage(parser.encodeMessage(this));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static class TimerTask
    implements Runnable {
        ScheduledFuture timerHandler;
        MessageImpl message;
        ScheduledExecutorService scheduledFacility;

        public TimerTask(MessageImpl message) {
            this.message = message;
        }

        public void setTimerHandler(ScheduledExecutorService scheduledFacility, ScheduledFuture timerHandler) {
            this.scheduledFacility = scheduledFacility;
            this.timerHandler = timerHandler;
        }

        public void run() {
            try {
                if (this.message != null && this.message.state != 3) {
                    IEventListener listener = null;
                    if (this.message.listener instanceof IEventListener) {
                        listener = this.message.listener;
                    }
                    if (listener != null && listener.isValid()) {
                        if (this.message.peer != null) {
                            this.message.peer.remMessage(this.message);
                        }
                        this.message.listener.timeoutExpired((Message)this.message);
                    }
                }
            }
            catch (Throwable e) {
                logger.debug("Can not process timeout", e);
            }
        }

        public void cancel() {
            if (this.timerHandler != null) {
                this.timerHandler.cancel(true);
                if (this.scheduledFacility instanceof ThreadPoolExecutor && this.timerHandler instanceof Runnable) {
                    ((ThreadPoolExecutor)((Object)this.scheduledFacility)).remove((Runnable)((Object)this.timerHandler));
                }
            }
            this.message = null;
        }

        public boolean isDone() {
            return this.timerHandler != null && this.timerHandler.isDone();
        }

        public boolean isCancelled() {
            return this.timerHandler == null || this.timerHandler.isCancelled();
        }
    }
}

