/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Request;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.helpers.UIDGenerator;
import org.jdiameter.client.impl.parser.AvpImpl;
import org.jdiameter.client.impl.parser.AvpSetImpl;
import org.jdiameter.client.impl.parser.ElementParser;
import org.jdiameter.client.impl.parser.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageParser
extends ElementParser
implements IMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(MessageParser.class);
    protected UIDGenerator endToEndGen = new UIDGenerator((int)(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) & 0xFFFL) << 20);

    @Override
    public IMessage createMessage(ByteBuffer data) throws AvpDataException {
        try {
            byte[] message = data.array();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
            long tmp = in.readInt();
            short version = (short)(tmp >> 24);
            if (version != 1) {
                throw new Exception("Illegal value of version " + version);
            }
            if ((long)message.length != (tmp & 0xFFFFFFL)) {
                throw new Exception("Wrong length of data: " + (tmp & 0xFFFFFFL));
            }
            tmp = in.readInt();
            short flags = (short)(tmp >> 24 & 0xFFL);
            int commandCode = (int)(tmp & 0xFFFFFFL);
            long applicationId = (long)in.readInt() << 32 >>> 32;
            long hopByHopId = (long)in.readInt() << 32 >>> 32;
            long endToEndId = (long)in.readInt() << 32 >>> 32;
            AvpSetImpl avpSet = this.decodeAvpSet(message, 20);
            return new MessageImpl(commandCode, applicationId, flags, hopByHopId, endToEndId, avpSet);
        }
        catch (Exception exc) {
            throw new AvpDataException((Throwable)exc);
        }
    }

    @Override
    public <T> T createMessage(Class<?> iface, ByteBuffer data) throws AvpDataException {
        if (iface == IMessage.class) {
            return (T)this.createMessage(data);
        }
        return null;
    }

    @Override
    public <T> T createEmptyMessage(Class<?> iface, IMessage parentMessage) {
        if (iface == Request.class) {
            return (T)this.createEmptyMessage(parentMessage, parentMessage.getCommandCode());
        }
        return null;
    }

    @Override
    public IMessage createEmptyMessage(IMessage prnMessage) {
        return this.createEmptyMessage(prnMessage, prnMessage.getCommandCode());
    }

    @Override
    public IMessage createEmptyMessage(IMessage prnMessage, int commandCode) {
        MessageImpl newMessage = new MessageImpl(commandCode, prnMessage.getHeaderApplicationId(), (short)prnMessage.getFlags(), prnMessage.getHopByHopIdentifier(), this.endToEndGen.nextLong(), null);
        this.copyBasicAvps(newMessage, prnMessage, false);
        return newMessage;
    }

    void copyBasicAvps(IMessage newMessage, IMessage prnMessage, boolean invertPoints) {
        Avp avp = prnMessage.getAvps().getAvp(263);
        if (avp != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(44)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(287)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(50)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(260)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(259)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(258)) != null) {
            newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avp)});
        }
        if ((avp = prnMessage.getAvps().getAvp(284)) != null) {
            try {
                AvpSet avps = avp.getGrouped();
                for (Avp avpp : avps) {
                    newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(avpp)});
                }
            }
            catch (AvpDataException e) {
                logger.debug("Error copying Proxy-Info AVP", (Throwable)e);
            }
        }
        if (newMessage.isRequest()) {
            if (invertPoints) {
                avp = prnMessage.getAvps().getAvp(264);
                if (avp != null) {
                    newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(293, avp)});
                }
                if ((avp = prnMessage.getAvps().getAvp(296)) != null) {
                    newMessage.getAvps().addAvp(new Avp[]{new AvpImpl(283, avp)});
                }
            } else {
                avp = prnMessage.getAvps().getAvp(293);
                if (avp != null) {
                    newMessage.getAvps().addAvp(new Avp[]{avp});
                }
                if ((avp = prnMessage.getAvps().getAvp(283)) != null) {
                    newMessage.getAvps().addAvp(new Avp[]{avp});
                }
            }
        }
    }

    @Override
    public ByteBuffer encodeMessage(IMessage message) throws ParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] rawData = this.encodeAvpSet(message.getAvps());
            DataOutputStream data = new DataOutputStream(out);
            int tmp = 0x1000000;
            data.writeInt(tmp += 20 + rawData.length);
            tmp = message.getFlags() << 24;
            data.writeInt(tmp += message.getCommandCode());
            data.write(this.toBytes(message.getHeaderApplicationId()));
            data.write(this.toBytes(message.getHopByHopIdentifier()));
            data.write(this.toBytes(message.getEndToEndIdentifier()));
            data.write(rawData);
        }
        catch (Exception e) {
            throw new ParseException("Failed to encode message.", e);
        }
        try {
            return this.prepareBuffer(out.toByteArray(), out.size());
        }
        catch (AvpDataException ade) {
            throw new ParseException(ade);
        }
    }

    private byte[] toBytes(long value) {
        byte[] data = new byte[]{(byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return data;
    }

    @Override
    public IMessage createEmptyMessage(int commandCode, long headerAppId) {
        return new MessageImpl(commandCode, headerAppId);
    }

    @Override
    public <T> T createEmptyMessage(Class<?> iface, int commandCode, long headerAppId) {
        if (iface == IRequest.class) {
            return (T)new MessageImpl(commandCode, headerAppId);
        }
        return null;
    }

    public int getNextEndToEndId() {
        return this.endToEndGen.nextInt();
    }
}

