/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.acc;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateMachine;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionData;
import org.jdiameter.common.impl.app.AppSessionImpl;
import org.jdiameter.common.impl.app.acc.AccountAnswerImpl;
import org.jdiameter.common.impl.app.acc.AccountRequestImpl;

public abstract class AppAccSessionImpl
extends AppSessionImpl
implements NetworkReqListener,
StateMachine {
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient List<StateChangeListener> stateListeners = new CopyOnWriteArrayList<StateChangeListener>();

    public AppAccSessionImpl(ISessionFactory sf, IAppSessionData appSessionData) {
        super(sf, appSessionData);
    }

    public void addStateChangeNotification(StateChangeListener listener) {
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public void removeStateChangeNotification(StateChangeListener listener) {
        this.stateListeners.remove(listener);
    }

    protected AccountRequest createAccountRequest(Request request) {
        return new AccountRequestImpl(request);
    }

    protected AccountAnswer createAccountAnswer(Answer answer) {
        return new AccountAnswerImpl(answer);
    }

    public void release() {
        super.release();
    }
}

