/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.auth;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateMachine;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.auth.IAuthSessionData;
import org.jdiameter.common.impl.app.AppSessionImpl;

public abstract class AppAuthSessionImpl
extends AppSessionImpl
implements NetworkReqListener,
StateMachine {
    protected Lock sendAndStateLock = new ReentrantLock();
    protected ApplicationId appId;
    protected transient List<StateChangeListener> stateListeners = new CopyOnWriteArrayList<StateChangeListener>();

    public AppAuthSessionImpl(ISessionFactory sf, IAuthSessionData sessionData) {
        super(sf, sessionData);
    }

    public void addStateChangeNotification(StateChangeListener listener) {
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public void removeStateChangeNotification(StateChangeListener listener) {
        this.stateListeners.remove(listener);
    }

    public void release() {
        super.release();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppAuthSessionImpl other = (AppAuthSessionImpl)obj;
        return !(this.appId == null ? other.appId != null : !this.appId.equals((Object)other.appId));
    }
}

