/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.gx;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.gx.ClientGxSession;
import org.jdiameter.api.gx.ClientGxSessionListener;
import org.jdiameter.api.gx.ServerGxSession;
import org.jdiameter.api.gx.ServerGxSessionListener;
import org.jdiameter.api.gx.events.GxCreditControlAnswer;
import org.jdiameter.api.gx.events.GxCreditControlRequest;
import org.jdiameter.api.gx.events.GxReAuthAnswer;
import org.jdiameter.api.gx.events.GxReAuthRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.gx.ClientGxSessionImpl;
import org.jdiameter.client.impl.app.gx.IClientGxSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.gx.IClientGxSessionContext;
import org.jdiameter.common.api.app.gx.IGxMessageFactory;
import org.jdiameter.common.api.app.gx.IGxSessionData;
import org.jdiameter.common.api.app.gx.IGxSessionFactory;
import org.jdiameter.common.api.app.gx.IServerGxSessionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.gx.AppGxSessionImpl;
import org.jdiameter.common.impl.app.gx.GxCreditControlAnswerImpl;
import org.jdiameter.common.impl.app.gx.GxCreditControlRequestImpl;
import org.jdiameter.common.impl.app.gx.GxReAuthAnswerImpl;
import org.jdiameter.common.impl.app.gx.GxReAuthRequestImpl;
import org.jdiameter.server.impl.app.gx.IServerGxSessionData;
import org.jdiameter.server.impl.app.gx.ServerGxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GxSessionFactoryImpl
implements IGxSessionFactory,
ClientGxSessionListener,
ServerGxSessionListener,
StateChangeListener<AppSession>,
IGxMessageFactory,
IServerGxSessionContext,
IClientGxSessionContext {
    protected int defaultDirectDebitingFailureHandling = 0;
    protected int defaultCreditControlFailureHandling = 0;
    protected long defaultValidityTime = 60L;
    protected long defaultTxTimerValue = 30L;
    protected ClientGxSessionListener clientSessionListener;
    protected ServerGxSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected IServerGxSessionContext serverContextListener;
    protected IClientGxSessionContext clientContextListener;
    protected IGxMessageFactory messageFactory;
    protected Logger logger = LoggerFactory.getLogger(GxSessionFactoryImpl.class);
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected IAppSessionDataFactory<IGxSessionData> sessionDataFactory;

    public GxSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IGxSessionData.class);
    }

    public GxSessionFactoryImpl(SessionFactory sessionFactory, int defaultDirectDebitingFailureHandling, int defaultCreditControlFailureHandling, long defaultValidityTime, long defaultTxTimerValue) {
        this(sessionFactory);
        this.defaultDirectDebitingFailureHandling = defaultDirectDebitingFailureHandling;
        this.defaultCreditControlFailureHandling = defaultCreditControlFailureHandling;
        this.defaultValidityTime = defaultValidityTime;
        this.defaultTxTimerValue = defaultTxTimerValue;
    }

    @Override
    public ClientGxSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientGxSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ServerGxSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerGxSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public IServerGxSessionContext getServerContextListener() {
        return this.serverContextListener != null ? this.serverContextListener : this;
    }

    @Override
    public void setServerContextListener(IServerGxSessionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public IClientGxSessionContext getClientContextListener() {
        return this.clientContextListener != null ? this.clientContextListener : this;
    }

    @Override
    public IGxMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(IGxMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public void setClientContextListener(IClientGxSessionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppGxSessionImpl appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ClientGxSession.class) {
                    IClientGxSessionData sessionData = (IClientGxSessionData)this.sessionDataFactory.getAppSessionData(ClientGxSession.class, sessionId);
                    ClientGxSessionImpl clientSession = new ClientGxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerGxSession.class) {
                    IServerGxSessionData sessionData = (IServerGxSessionData)this.sessionDataFactory.getAppSessionData(ServerGxSession.class, sessionId);
                    ServerGxSessionImpl serverSession = new ServerGxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientGxSession.class + "," + ServerGxSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Gx Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppGxSessionImpl appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ClientGxSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientGxSessionData sessionData = (IClientGxSessionData)this.sessionDataFactory.getAppSessionData(ClientGxSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    ClientGxSessionImpl clientSession = new ClientGxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                if (aClass == ServerGxSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerGxSessionData sessionData = (IServerGxSessionData)this.sessionDataFactory.getAppSessionData(ServerGxSession.class, sessionId);
                    sessionData.setApplicationId(applicationId);
                    ServerGxSessionImpl serverSession = new ServerGxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientGxSession.class + "," + ServerGxSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Gx Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void doCreditControlRequest(ServerGxSession session, GxCreditControlRequest request) throws InternalException {
    }

    public void doCreditControlAnswer(ClientGxSession session, GxCreditControlRequest request, GxCreditControlAnswer answer) throws InternalException {
    }

    public void doGxReAuthRequest(ClientGxSession session, GxReAuthRequest request) throws InternalException {
    }

    public void doGxReAuthAnswer(ServerGxSession session, GxReAuthRequest request, GxReAuthAnswer answer) throws InternalException {
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
    }

    @Override
    public GxCreditControlAnswer createCreditControlAnswer(Answer answer) {
        return new GxCreditControlAnswerImpl(answer);
    }

    @Override
    public GxCreditControlRequest createCreditControlRequest(Request req) {
        return new GxCreditControlRequestImpl(req);
    }

    @Override
    public GxReAuthAnswer createGxReAuthAnswer(Answer answer) {
        return new GxReAuthAnswerImpl(answer);
    }

    @Override
    public GxReAuthRequest createGxReAuthRequest(Request req) {
        return new GxReAuthRequestImpl(req);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter Gx SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter Gx SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public void sessionSupervisionTimerExpired(ServerGxSession session) {
        session.release();
    }

    @Override
    public void sessionSupervisionTimerReStarted(ServerGxSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStarted(ServerGxSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStopped(ServerGxSession session, ScheduledFuture future) {
    }

    @Override
    public void timeoutExpired(Request request) {
    }

    @Override
    public void denyAccessOnDeliverFailure(ClientGxSession clientGxSessionImpl, Message request) {
    }

    @Override
    public void denyAccessOnFailureMessage(ClientGxSession clientGxSessionImpl) {
    }

    @Override
    public void denyAccessOnTxExpire(ClientGxSession clientGxSessionImpl) {
        clientGxSessionImpl.release();
    }

    @Override
    public int getDefaultCCFHValue() {
        return this.defaultCreditControlFailureHandling;
    }

    @Override
    public int getDefaultDDFHValue() {
        return this.defaultDirectDebitingFailureHandling;
    }

    @Override
    public long getDefaultTxTimerValue() {
        return this.defaultTxTimerValue;
    }

    @Override
    public void grantAccessOnDeliverFailure(ClientGxSession clientGxSessionImpl, Message request) {
    }

    @Override
    public void grantAccessOnFailureMessage(ClientGxSession clientGxSessionImpl) {
    }

    @Override
    public void grantAccessOnTxExpire(ClientGxSession clientGxSessionImpl) {
    }

    @Override
    public void indicateServiceError(ClientGxSession clientGxSessionImpl) {
    }

    @Override
    public void txTimerExpired(ClientGxSession session) {
        session.release();
    }

    @Override
    public long[] getApplicationIds() {
        return new long[]{0x1000016L, 0x1000016L};
    }

    @Override
    public long getDefaultValidityTime() {
        return this.defaultValidityTime;
    }
}

