/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.rf;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rf.ClientRfSession;
import org.jdiameter.api.rf.ClientRfSessionListener;
import org.jdiameter.api.rf.ServerRfSession;
import org.jdiameter.api.rf.ServerRfSessionListener;
import org.jdiameter.api.rf.events.RfAccountingAnswer;
import org.jdiameter.api.rf.events.RfAccountingRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.rf.ClientRfSessionImpl;
import org.jdiameter.client.impl.app.rf.IClientRfSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.rf.IClientRfActionContext;
import org.jdiameter.common.api.app.rf.IRfSessionData;
import org.jdiameter.common.api.app.rf.IRfSessionFactory;
import org.jdiameter.common.api.app.rf.IServerRfActionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.rf.AppRfSessionImpl;
import org.jdiameter.server.impl.app.rf.IServerRfSessionData;
import org.jdiameter.server.impl.app.rf.ServerRfSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RfSessionFactoryImpl
implements IRfSessionFactory,
ServerRfSessionListener,
ClientRfSessionListener,
IClientRfActionContext,
IServerRfActionContext,
StateChangeListener<AppSession> {
    protected Logger logger = LoggerFactory.getLogger(RfSessionFactoryImpl.class);
    protected ServerRfSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected ClientRfSessionListener clientSessionListener;
    protected IClientRfActionContext clientContextListener;
    protected IServerRfActionContext serverContextListener;
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected long messageTimeout = 5000L;
    protected ApplicationId applicationId;
    protected IAppSessionDataFactory<IRfSessionData> sessionDataFactory;

    protected RfSessionFactoryImpl() {
    }

    public RfSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IRfSessionData.class);
    }

    @Override
    public ServerRfSessionListener getServerSessionListener() {
        if (this.serverSessionListener != null) {
            return this.serverSessionListener;
        }
        return this;
    }

    @Override
    public void setServerSessionListener(ServerRfSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        if (this.stateListener != null) {
            return this.stateListener;
        }
        return this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public ClientRfSessionListener getClientSessionListener() {
        if (this.clientSessionListener != null) {
            return this.clientSessionListener;
        }
        return this;
    }

    @Override
    public void setClientSessionListener(ClientRfSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public IClientRfActionContext getClientContextListener() {
        if (this.clientContextListener != null) {
            return this.clientContextListener;
        }
        return this;
    }

    @Override
    public void setClientContextListener(IClientRfActionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    @Override
    public IServerRfActionContext getServerContextListener() {
        if (this.serverContextListener != null) {
            return this.serverContextListener;
        }
        return this;
    }

    @Override
    public void setServerContextListener(IServerRfActionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    @Override
    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public ISessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ISessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        if (this.iss == null) {
            this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        }
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(ApplicationId id) {
        this.applicationId = id;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppRfSessionImpl appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerRfSession.class) {
                    IServerRfSessionData sessionData = (IServerRfSessionData)this.sessionDataFactory.getAppSessionData(ServerRfSession.class, sessionId);
                    ServerRfSessionImpl session = new ServerRfSessionImpl(sessionData, this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener(), this.messageTimeout, true);
                    session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                    appSession = session;
                    break block6;
                }
                if (aClass == ClientRfSession.class) {
                    IClientRfSessionData sessionData = (IClientRfSessionData)this.sessionDataFactory.getAppSessionData(ClientRfSession.class, sessionId);
                    ClientRfSessionImpl session = new ClientRfSessionImpl(sessionData, this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener(), this.getApplicationId());
                    session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                    appSession = session;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRfSession.class + "," + ServerRfSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Rf Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        try {
            if (aClass == ServerRfSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IServerRfSessionData sessionData = (IServerRfSessionData)this.sessionDataFactory.getAppSessionData(ServerRfSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                ServerRfSessionImpl session = new ServerRfSessionImpl(sessionData, this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener(), this.messageTimeout, true);
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
            if (aClass == ClientRfSession.class) {
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IClientRfSessionData sessionData = (IClientRfSessionData)this.sessionDataFactory.getAppSessionData(ClientRfSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                ClientRfSessionImpl session = new ClientRfSessionImpl(sessionData, this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener(), this.getApplicationId());
                this.iss.addSession((BaseSession)session);
                session.getSessions().get(0).setRequestListener((NetworkReqListener)session);
                return session;
            }
            throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRfSession.class + "," + ServerRfSession.class + "]");
        }
        catch (Exception e) {
            this.logger.error("Failure to obtain new Rf Session.", (Throwable)e);
            return null;
        }
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter ACC SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter Rf SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    public void doRfAccountingRequestEvent(ServerRfSession appSession, RfAccountingRequest acr) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("Diameter Base RfSessionFactory :: doAccRequestEvent :: appSession[" + appSession + "], Request[" + acr + "]");
    }

    public void doRfAccountingAnswerEvent(ClientRfSession appSession, RfAccountingRequest acr, RfAccountingAnswer aca) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("doRfAnswerEvent :: appSession[" + appSession + "], Request[" + acr + "], Answer[" + aca + "]");
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.logger.info("Diameter Base RfountingSessionFactory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]");
    }

    @Override
    public void disconnectUserOrDev(ClientRfSession appSession, Request sessionTermRequest) throws InternalException {
        this.logger.info("disconnectUserOrDev :: appSession[" + appSession + "], Request[" + sessionTermRequest + "]");
    }

    @Override
    public boolean failedSendRecord(ClientRfSession appSession, Request rfRequest) throws InternalException {
        this.logger.info("failedSendRecord :: appSession[" + appSession + "], Request[" + rfRequest + "]");
        return false;
    }

    @Override
    public void interimIntervalElapses(ClientRfSession appSession, Request interimRequest) throws InternalException {
        this.logger.info("interimIntervalElapses :: appSession[" + appSession + "], Request[" + interimRequest + "]");
    }

    @Override
    public void sessionTimeoutElapses(ServerRfSession appSession) throws InternalException {
        this.logger.info("sessionTimeoutElapses :: appSession[" + appSession + "]");
    }

    @Override
    public void sessionTimerStarted(ServerRfSession appSession, ScheduledFuture timer) throws InternalException {
        this.logger.info("sessionTimerStarted :: appSession[" + appSession + "]");
    }

    @Override
    public void sessionTimerCanceled(ServerRfSession appSession, ScheduledFuture timer) throws InternalException {
        this.logger.info("sessionTimerCanceled :: appSession[" + appSession + "]");
    }
}

