/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.controller;

import java.util.ArrayList;
import java.util.List;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.URI;
import org.jdiameter.client.impl.helpers.UIDGenerator;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPeer
implements Comparable<Peer> {
    public static final int INT_COMMON_APP_ID = -1;
    protected static UIDGenerator uid = new UIDGenerator();
    protected IStatistic statistic;
    protected List<IStatisticRecord> perSecondRecords = new ArrayList<IStatisticRecord>();
    protected URI uri;
    protected IStatisticManager statisticFactory;

    public AbstractPeer(URI uri, IStatisticManager statisticFactory) {
        this.uri = uri;
        this.statisticFactory = statisticFactory;
    }

    protected void createPeerStatistics() {
        if (this.statistic != null) {
            return;
        }
        String uriString = this.uri == null ? "local" : this.uri.toString();
        IStatisticRecord appGenRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRequest);
        IStatisticRecord appGenCPSRequestCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.AppGenRequestPerSecond, appGenRequestCounter);
        IStatisticRecord appGenRejectedRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRejectedRequest);
        this.perSecondRecords.add(appGenCPSRequestCounter);
        IStatisticRecord appGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenResponse);
        IStatisticRecord appGenCPSResponseCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.AppGenResponsePerSecond, appGenResponseCounter);
        IStatisticRecord appGenRejectedResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.AppGenRejectedResponse);
        this.perSecondRecords.add(appGenCPSResponseCounter);
        IStatisticRecord netGenRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRequest);
        IStatisticRecord netGenCPSRequestCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.NetGenRequestPerSecond, netGenRequestCounter);
        IStatisticRecord netGenRejectedRequestCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRejectedRequest);
        this.perSecondRecords.add(netGenCPSRequestCounter);
        IStatisticRecord netGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenResponse);
        IStatisticRecord netGenCPSResponseCounter = this.statisticFactory.newPerSecondCounterRecord(uriString, IStatisticRecord.Counters.NetGenResponsePerSecond, netGenResponseCounter);
        IStatisticRecord netGenRejectedResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.NetGenRejectedResponse);
        this.perSecondRecords.add(netGenCPSResponseCounter);
        IStatisticRecord sysGenResponseCounter = this.statisticFactory.newCounterRecord(IStatisticRecord.Counters.SysGenResponse);
        this.statistic = this.statisticFactory.newStatistic(uriString, IStatistic.Groups.Peer, appGenRequestCounter, appGenCPSRequestCounter, appGenRejectedRequestCounter, appGenResponseCounter, appGenCPSResponseCounter, appGenRejectedResponseCounter, netGenRequestCounter, netGenCPSRequestCounter, netGenRejectedRequestCounter, netGenResponseCounter, netGenCPSResponseCounter, netGenRejectedResponseCounter, sysGenResponseCounter);
    }

    protected void removePeerStatistics() {
        if (this.statistic != null) {
            for (IStatisticRecord rec : this.perSecondRecords) {
                this.statisticFactory.removePerSecondCounterRecord(rec);
            }
            this.statisticFactory.removeStatistic(this.statistic);
            this.perSecondRecords.clear();
            this.statistic = null;
        }
    }

    @Override
    public int compareTo(Peer o) {
        return this.uri.compareTo((Object)o.getUri());
    }

    protected void disconnect(int disconnectCause) throws InternalException, IllegalDiameterStateException {
    }
}

