/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.Message;
import org.jdiameter.api.Network;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.StackType;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.impl.MetaDataImpl;
import org.jdiameter.client.impl.helpers.IPConverter;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.IMutablePeerTable;
import org.jdiameter.server.api.INetwork;
import org.jdiameter.server.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataImpl
extends org.jdiameter.client.impl.MetaDataImpl
implements IMetaData {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataImpl.class);
    private final Object lock = new Object();

    public MetaDataImpl(IContainer s) {
        super(s);
    }

    public MetaDataImpl(IContainer s, IStatisticManager factory) {
        super(s, factory);
    }

    public StackType getStackType() {
        return StackType.TYPE_SERVER;
    }

    protected IPeer newLocalPeer(IStatisticManager statisticFactory) {
        return new ServerLocalPeer(statisticFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationId(ApplicationId applicationId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.appIds.contains(applicationId)) {
                return;
            }
            this.appIds.add(applicationId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding application id of auth [{}] acct [{}] vendor [{}]", new Object[]{applicationId.getAuthAppId(), applicationId.getAcctAppId(), applicationId.getVendorId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remApplicationId(ApplicationId applicationId) {
        Object object = this.lock;
        synchronized (object) {
            this.appIds.remove(applicationId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Removing application id of auth [{}] acct [{}] vendor [{}]", new Object[]{applicationId.getAuthAppId(), applicationId.getAcctAppId(), applicationId.getVendorId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            this.appIds.clear();
            logger.debug("Clearing out application ids");
            this.getLocalPeer().getCommonApplications();
            ((ServerLocalPeer)this.peer).resetAddresses();
            this.peer.getIPAddresses();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ServerLocalPeer
    extends MetaDataImpl.ClientLocalPeer {
        protected INetwork net;
        protected IMutablePeerTable manager;
        protected ISessionFactory factory;
        Map<Long, IMessage> peerRequests;

        public ServerLocalPeer(IStatisticManager statisticFactory) {
            super(statisticFactory);
            this.net = null;
            this.manager = null;
            this.factory = null;
            this.peerRequests = new ConcurrentHashMap<Long, IMessage>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ApplicationId> getCommonApplications() {
            Set<ApplicationId> set;
            Object object = MetaDataImpl.this.lock;
            synchronized (object) {
                set = super.getCommonApplications();
            }
            return set;
        }

        @Override
        public InetAddress[] getIPAddresses() {
            if (this.addresses.length == 0) {
                Configuration[] ipAddresses = MetaDataImpl.this.stack.getConfiguration().getChildren(Parameters.OwnIPAddresses.ordinal());
                ArrayList<InetAddress> list = new ArrayList<InetAddress>();
                if (ipAddresses != null) {
                    for (Configuration address : ipAddresses) {
                        InetAddress iaddress;
                        if (address == null || (iaddress = this.getAddress(address)) == null) continue;
                        list.add(iaddress);
                    }
                } else {
                    InetAddress address = this.getDefaultIpAddress();
                    if (address != null) {
                        list.add(address);
                    }
                }
                this.addresses = list.toArray(new InetAddress[list.size()]);
            }
            return this.addresses;
        }

        private InetAddress getAddress(Configuration configuration) {
            InetAddress rc;
            block5: {
                String address = configuration.getStringValue(org.jdiameter.client.impl.helpers.Parameters.OwnIPAddress.ordinal(), null);
                if (address == null || address.length() == 0) {
                    rc = this.getDefaultIpAddress();
                } else {
                    try {
                        rc = InetAddress.getByName(address);
                    }
                    catch (UnknownHostException e) {
                        logger.debug("Unable to retrieve IP by Address [{}]", (Object)address, (Object)e);
                        rc = IPConverter.InetAddressByIPv4(address);
                        if (rc == null) {
                            rc = IPConverter.InetAddressByIPv6(address);
                        }
                        if (rc != null) break block5;
                        rc = this.getDefaultIpAddress();
                    }
                }
            }
            return rc;
        }

        private InetAddress getDefaultIpAddress() {
            try {
                return InetAddress.getByName(MetaDataImpl.this.getLocalPeer().getUri().getFQDN());
            }
            catch (Exception e1) {
                logger.debug("Unable to retrieve IP by URI [{}]", (Object)MetaDataImpl.this.getLocalPeer().getUri().getFQDN(), (Object)e1);
                try {
                    return InetAddress.getLocalHost();
                }
                catch (Exception e2) {
                    logger.debug("Unable to retrieve IP for localhost", (Throwable)e2);
                    return null;
                }
            }
        }

        @Override
        public boolean sendMessage(IMessage message) throws TransportException, OverloadException {
            logger.debug("Sending Message in Server Local Peer");
            try {
                if (this.net == null || this.manager == null) {
                    try {
                        logger.debug("Unwrapping network and manager");
                        this.net = (INetwork)MetaDataImpl.this.stack.unwrap(Network.class);
                        this.manager = (IMutablePeerTable)MetaDataImpl.this.stack.unwrap(PeerTable.class);
                        this.factory = this.manager.getSessionFactory();
                    }
                    catch (Exception e) {
                        logger.warn("Error initialising for message send", (Throwable)e);
                    }
                }
                IMessage answer = null;
                if (message.isRequest()) {
                    logger.debug("Message is a request");
                    message.setHopByHopIdentifier(MetaDataImpl.this.peer.getHopByHopIdentifier());
                    this.peerRequests.put(message.getHopByHopIdentifier(), message);
                    NetworkReqListener listener = this.net.getListener(message);
                    if (listener != null) {
                        answer = this.manager.isDuplicate(message);
                        if (answer != null) {
                            logger.debug("Found message in duplicates. No need to invoke listener, will send previous answer.");
                            answer.setProxiable(message.isProxiable());
                            answer.getAvps().removeAvp(284);
                            for (Avp avp : message.getAvps().getAvps(284)) {
                                answer.getAvps().addAvp(new Avp[]{avp});
                            }
                            answer.setHopByHopIdentifier(message.getHopByHopIdentifier());
                        } else {
                            String avpSessionId = message.getSessionId();
                            if (avpSessionId != null) {
                                NetworkReqListener sessionListener = MetaDataImpl.this.sessionDataSource.getSessionListener(avpSessionId);
                                if (sessionListener != null) {
                                    logger.debug("Giving message to sessionListener to process as Session-Id AVP existed in message and was used to get a session from Session DataSource");
                                    answer = (IMessage)sessionListener.processRequest((Request)message);
                                } else {
                                    try {
                                        logger.debug("Giving message to listener to process. Listener was retrieved from net");
                                        answer = (IMessage)listener.processRequest((Request)message);
                                        if (answer != null) {
                                            this.manager.saveToDuplicate(message.getDuplicationKey(), answer);
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.debug("Error during processing message by listener", (Throwable)e);
                                    }
                                }
                            }
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Unable to find handler {} for message {}", (Object)message.getSingleApplicationId(), (Object)message);
                    }
                    if (answer != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Removing message with HbH Identifier [{}] from Peer Requests Map", (Object)message.getHopByHopIdentifier());
                        }
                        this.peerRequests.remove(message.getHopByHopIdentifier());
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Message is an answer. Setting answer to the message and fetching message from Peer Requests Map using HbH Identifier [{}]", (Object)message.getHopByHopIdentifier());
                    }
                    answer = message;
                    message = this.peerRequests.get(answer.getHopByHopIdentifier());
                }
                if (message != null && !message.isTimeOut() && answer != null) {
                    logger.debug("Clearing timer on message and notifying event listeners of receiving success message");
                    message.clearTimer();
                    message.setState(3);
                    message.getEventListener().receivedSuccessMessage((Message)message, (Message)answer);
                }
                return true;
            }
            catch (Exception e) {
                logger.warn("Unable to process message {}", (Object)message, (Object)e);
                return false;
            }
        }
    }
}

