/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.sh;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.ServerShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.sh.ShSession;
import org.jdiameter.server.impl.app.sh.Event;
import org.jdiameter.server.impl.app.sh.IShServerSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShServerSessionImpl
extends ShSession
implements ServerShSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private Logger logger = LoggerFactory.getLogger(ShServerSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IShMessageFactory factory = null;
    protected transient ServerShSessionListener listener;
    protected IShServerSessionData sessionData;
    protected long appId;

    public ShServerSessionImpl(IShServerSessionData sessionData, IShMessageFactory fct, ISessionFactory sf, ServerShSessionListener lst) {
        super(sf, sessionData);
        if (sessionData == null) {
            throw new NullPointerException("SessionData must not be null");
        }
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.sessionData = sessionData;
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.factory = fct;
    }

    public void sendProfileUpdateAnswer(ProfileUpdateAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PROFILE_UPDATE_ANSWER, null, (AppEvent)answer);
    }

    public void sendPushNotificationRequest(PushNotificationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_PUSH_NOTIFICATION_REQUEST, (AppEvent)request, null);
    }

    public void sendSubscribeNotificationsAnswer(SubscribeNotificationsAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_SUBSCRIBE_NOTIFICATIONS_ANSWER, null, (AppEvent)answer);
    }

    public void sendUserDataAnswer(UserDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_USER_DATA_ANSWER, null, (AppEvent)answer);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutExpired(Request request) {
        try {
            try {
                this.sendAndStateLock.lock();
                if (request.getApplicationId() == this.appId && request.getCommandCode() == 309) {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, (AppEvent)this.factory.createPushNotificationRequest(request), null));
                    Object var4_2 = null;
                    this.sendAndStateLock.unlock();
                    return;
                }
                Object var4_3 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Exception e) {
                this.logger.debug("Failed to process timeout message", (Throwable)e);
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public <E> E getState(Class<E> stateType) {
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            try {
                this.sendAndStateLock.lock();
                localEvent = (Event)event;
                switch (1.$SwitchMap$org$jdiameter$server$impl$app$sh$Event$Type[((Event.Type)localEvent.getType()).ordinal()]) {
                    case 1: {
                        this.listener.doProfileUpdateRequestEvent((ServerShSession)this, (ProfileUpdateRequest)localEvent.getRequest());
                        ** break;
                    }
                    case 2: {
                        this.listener.doPushNotificationAnswerEvent((ServerShSession)this, (PushNotificationRequest)localEvent.getRequest(), (PushNotificationAnswer)localEvent.getAnswer());
                        ** break;
                    }
                    case 3: {
                        this.listener.doSubscribeNotificationsRequestEvent((ServerShSession)this, (SubscribeNotificationsRequest)localEvent.getRequest());
                        ** break;
                    }
                    case 4: {
                        this.listener.doUserDataRequestEvent((ServerShSession)this, (UserDataRequest)localEvent.getRequest());
                        ** break;
                    }
                    case 5: {
                        this.dispatchEvent(localEvent.getAnswer());
                        ** break;
                    }
                    case 6: {
                        this.dispatchEvent(localEvent.getRequest());
                        ** break;
                    }
                    case 7: {
                        this.dispatchEvent(localEvent.getAnswer());
                        ** break;
                    }
                    case 8: {
                        this.dispatchEvent(localEvent.getAnswer());
                        ** break;
                    }
                    case 9: {
                        ** break;
                    }
                }
                this.logger.error("Wrong message type = {} req = {} ans = {}", new Object[]{localEvent.getType(), localEvent.getRequest(), localEvent.getAnswer()});
            }
            catch (IllegalDiameterStateException idse) {
                throw new InternalException((Throwable)idse);
            }
            catch (RouteException re) {
                throw new InternalException((Throwable)re);
            }
lbl38:
            // 10 sources

            var4_5 = null;
            this.sendAndStateLock.unlock();
            return true;
        }
        catch (Throwable var3_7) {
            var4_6 = null;
            this.sendAndStateLock.unlock();
            throw var3_7;
        }
    }

    public boolean isStateless() {
        return true;
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            block4: {
                try {
                    this.sendAndStateLock.lock();
                    if (type == null) break block4;
                    this.handleEvent(new Event(type, request, answer));
                }
                catch (Exception exc) {
                    throw new InternalException((Throwable)exc);
                }
            }
            Object var6_4 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            this.logger.debug("Failed to dispatch event", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    this.logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            this.logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected long extractExpiryTime(Message answer) {
        try {
            Avp expiryTimeAvp = answer.getAvps().getAvp(709);
            return expiryTimeAvp != null ? expiryTimeAvp.getTime().getTime() : -1L;
        }
        catch (AvpDataException ade) {
            this.logger.debug("Failure trying to extract Expiry-Time AVP value", (Throwable)ade);
            return -1L;
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShServerSessionImpl other = (ShServerSessionImpl)obj;
        if (this.appId != other.appId) {
            return false;
        }
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    @Override
    public void onTimer(String timerName) {
        this.logger.trace("onTimer({})", (Object)timerName);
    }

    private class AnswerDelivery
    implements Runnable {
        ServerShSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    ShServerSessionImpl.this.sendAndStateLock.lock();
                    if (this.request.getApplicationId() == ShServerSessionImpl.this.appId) {
                        if (this.request.getCommandCode() == 309) {
                            ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PUSH_NOTIFICATION_ANSWER, (AppEvent)ShServerSessionImpl.this.factory.createPushNotificationRequest(this.request), (AppEvent)ShServerSessionImpl.this.factory.createPushNotificationAnswer(this.answer)));
                            Object var3_1 = null;
                            ShServerSessionImpl.this.sendAndStateLock.unlock();
                            return;
                        }
                        ShServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                    } else {
                        ShServerSessionImpl.this.logger.warn("Message with Application-Id {} reached Application Session with Application-Id {}. Skipping.", (Object)this.request.getApplicationId(), (Object)ShServerSessionImpl.this.appId);
                    }
                }
                catch (Exception e) {
                    ShServerSessionImpl.this.logger.debug("Failed to process success message", (Throwable)e);
                    Object var3_3 = null;
                    ShServerSessionImpl.this.sendAndStateLock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ShServerSessionImpl.this.sendAndStateLock.unlock();
                throw throwable;
            }
            Object var3_2 = null;
            ShServerSessionImpl.this.sendAndStateLock.unlock();
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerShSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                if (this.request.getApplicationId() == ShServerSessionImpl.this.appId) {
                    if (this.request.getCommandCode() == 308) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_SUBSCRIBE_NOTIFICATIONS_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createSubscribeNotificationsRequest(this.request), null));
                    } else if (this.request.getCommandCode() == 306) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_USER_DATA_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createUserDataRequest(this.request), null));
                    } else if (this.request.getCommandCode() == 307) {
                        ShServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PROFILE_UPDATE_REQUEST, (AppEvent)ShServerSessionImpl.this.factory.createProfileUpdateRequest(this.request), null));
                    } else {
                        ShServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                    }
                }
            }
            catch (Exception e) {
                ShServerSessionImpl.this.logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

