/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.helpers;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.AppConfiguration;
import org.jdiameter.client.impl.helpers.Ordinal;
import org.jdiameter.server.impl.helpers.EmptyConfiguration;
import org.jdiameter.server.impl.helpers.ExtensionPoint;
import org.jdiameter.server.impl.helpers.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends EmptyConfiguration {
    public XMLConfiguration(InputStream in) throws Exception {
        this(in, null, null, false);
    }

    public XMLConfiguration(InputStream in, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features) throws Exception {
        this(in, attributes, features, false);
    }

    public XMLConfiguration(String filename) throws Exception {
        this(filename, null, null, false);
    }

    public XMLConfiguration(String filename, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features) throws Exception {
        this(filename, attributes, features, false);
    }

    protected XMLConfiguration(Object in, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features, boolean nop) throws Exception {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                factory.setAttribute(key, attributes.get(key));
            }
        }
        if (features != null) {
            for (String key : features.keySet()) {
                factory.setFeature(key, features.get(key));
            }
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (in instanceof InputStream) {
            document = builder.parse((InputStream)in);
        } else if (in instanceof String) {
            document = builder.parse(new File((String)in));
        } else {
            throw new Exception("Unknown type of input data");
        }
        this.validate(document);
        this.processing(document);
    }

    protected void validate(Document document) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(this.getClass().getResourceAsStream("/META-INF/jdiameter-server.xsd"));
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    protected void processing(Document document) {
        Element element = document.getDocumentElement();
        NodeList c = element.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("LocalPeer")) {
                this.addLocalPeer(c.item(i));
                continue;
            }
            if (nodeName.equals("Parameters")) {
                this.addParameters(c.item(i));
                continue;
            }
            if (nodeName.equals("Security")) {
                this.addSecurity(c.item(i));
                continue;
            }
            if (nodeName.equals("Network")) {
                this.addNetwork(c.item(i));
                continue;
            }
            if (!nodeName.equals("Extensions")) continue;
            this.addExtensions(c.item(i));
        }
    }

    protected void addApplications(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            Configuration m;
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("ApplicationID") || (m = this.addApplicationID(c.item(i))) == null) continue;
            items.add(m);
        }
        this.add((Ordinal)Parameters.ApplicationId, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addApplicationID(NodeList node) {
        for (int i = 0; i < node.getLength(); ++i) {
            String nodeName = node.item(i).getNodeName();
            if (!nodeName.equals("ApplicationID")) continue;
            return this.addApplicationID(node.item(i));
        }
        return null;
    }

    protected Configuration addApplicationID(Node node) {
        NodeList c = node.getChildNodes();
        AppConfiguration e = XMLConfiguration.getInstance();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("VendorId")) {
                e.add((Ordinal)Parameters.VendorId, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AuthApplId")) {
                e.add((Ordinal)Parameters.AuthApplId, this.getLongValue(c.item(i)));
                continue;
            }
            if (!nodeName.equals("AcctApplId")) continue;
            e.add((Ordinal)Parameters.AcctApplId, this.getLongValue(c.item(i)));
        }
        return e;
    }

    protected void addParameters(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("UseUriAsFqdn")) {
                this.add((Ordinal)Parameters.UseUriAsFqdn, Boolean.valueOf(this.getValue(c.item(i))));
                continue;
            }
            if (nodeName.equals("QueueSize")) {
                this.add((Ordinal)Parameters.QueueSize, this.getIntValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("MessageTimeOut")) {
                this.add((Ordinal)Parameters.MessageTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StopTimeOut")) {
                this.add((Ordinal)Parameters.StopTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("CeaTimeOut")) {
                this.add((Ordinal)Parameters.CeaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("IacTimeOut")) {
                this.add((Ordinal)Parameters.IacTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("DwaTimeOut")) {
                this.add((Ordinal)Parameters.DwaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("DpaTimeOut")) {
                this.add((Ordinal)Parameters.DpaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RecTimeOut")) {
                this.add((Ordinal)Parameters.RecTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ThreadPool")) {
                this.addThreadPool(c.item(i));
                continue;
            }
            if (nodeName.equals("PeerFSMThreadCount")) {
                this.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.PeerFSMThreadCount, this.getIntValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("Statistics")) {
                this.addStatisticLogger(Parameters.Statistics, c.item(i));
                continue;
            }
            if (nodeName.equals("Concurrent")) {
                this.addConcurrent(Parameters.Concurrent, c.item(i));
                continue;
            }
            if (nodeName.equals("Dictionary")) {
                this.addDictionary(Parameters.Dictionary, c.item(i));
                continue;
            }
            if (nodeName.equals("RequestTable")) {
                this.addRequestTable(Parameters.RequestTable, c.item(i));
                continue;
            }
            this.appendOtherParameter(c.item(i));
        }
    }

    protected void addThreadPool(Node item) {
        AppConfiguration threadPoolConfiguration = EmptyConfiguration.getInstance();
        NamedNodeMap attributes = item.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node n = attributes.item(index);
            int v = Integer.parseInt(n.getNodeValue());
            if (n.getNodeName().equals("size")) {
                threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolSize, v);
                continue;
            }
            if (!n.getNodeName().equals("priority")) continue;
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolPriority, v);
        }
        if (!threadPoolConfiguration.isAttributeExist(Parameters.ThreadPoolSize.ordinal())) {
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolSize, Parameters.ThreadPoolSize.defValue());
        }
        if (!threadPoolConfiguration.isAttributeExist(Parameters.ThreadPoolPriority.ordinal())) {
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolPriority, Parameters.ThreadPoolPriority.defValue());
        }
        this.add((Ordinal)Parameters.ThreadPool, (Object)threadPoolConfiguration);
    }

    protected void addConcurrent(org.jdiameter.client.impl.helpers.Parameters name, Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Entity")) continue;
            this.addConcurrentEntity(items, c.item(i));
        }
        this.add((Ordinal)name, items.toArray(new Configuration[items.size()]));
    }

    protected void addConcurrentEntity(List<Configuration> items, Node node) {
        AppConfiguration cfg = XMLConfiguration.getInstance();
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        cfg.add((Ordinal)Parameters.ConcurrentEntityName, name);
        if (node.getAttributes().getNamedItem("description") != null) {
            String descr = node.getAttributes().getNamedItem("description").getNodeValue();
            cfg.add((Ordinal)Parameters.ConcurrentEntityDescription, descr);
        }
        if (node.getAttributes().getNamedItem("size") != null) {
            String size = node.getAttributes().getNamedItem("size").getNodeValue();
            cfg.add((Ordinal)Parameters.ConcurrentEntityPoolSize, Integer.parseInt(size));
        }
        items.add(cfg);
    }

    protected void addStatisticLogger(org.jdiameter.client.impl.helpers.Parameters name, Node node) {
        String pause = node.getAttributes().getNamedItem("pause").getNodeValue();
        String delay = node.getAttributes().getNamedItem("delay").getNodeValue();
        String enabled = node.getAttributes().getNamedItem("enabled").getNodeValue();
        String active_records = node.getAttributes().getNamedItem("active_records") != null ? node.getAttributes().getNamedItem("active_records").getNodeValue() : (String)org.jdiameter.client.impl.helpers.Parameters.StatisticsActiveList.defValue();
        this.add((Ordinal)name, (Object)XMLConfiguration.getInstance().add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.StatisticsLoggerPause, Long.parseLong(pause)).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.StatisticsLoggerDelay, Long.parseLong(delay)).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.StatisticsEnabled, Boolean.parseBoolean(enabled)).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.StatisticsActiveList, active_records));
    }

    protected void addDictionary(org.jdiameter.client.impl.helpers.Parameters name, Node node) {
        AppConfiguration dicConfiguration = XMLConfiguration.getInstance();
        Node param = node.getAttributes().getNamedItem("class");
        if (param != null) {
            String clazz = param.getNodeValue();
            dicConfiguration.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.DictionaryClass, clazz);
        }
        if ((param = node.getAttributes().getNamedItem("enabled")) != null) {
            String enabled = param.getNodeValue();
            dicConfiguration.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.DictionaryEnabled, Boolean.valueOf(enabled));
        }
        if ((param = node.getAttributes().getNamedItem("sendLevel")) != null) {
            String sendLevel = param.getNodeValue();
            dicConfiguration.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.DictionarySendLevel, sendLevel);
        }
        if ((param = node.getAttributes().getNamedItem("receiveLevel")) != null) {
            String receiveLevel = param.getNodeValue();
            dicConfiguration.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.DictionaryReceiveLevel, receiveLevel);
        }
        this.add((Ordinal)name, (Object)dicConfiguration);
    }

    protected void addRequestTable(org.jdiameter.client.impl.helpers.Parameters name, Node node) {
        String size;
        AppConfiguration tableConfiguration = XMLConfiguration.getInstance();
        Node param = node.getAttributes().getNamedItem("size");
        if (param != null) {
            size = param.getNodeValue();
            tableConfiguration.add((Ordinal)Parameters.RequestTableSize, Integer.parseInt(size));
        }
        if ((param = node.getAttributes().getNamedItem("clear_size")) != null) {
            size = param.getNodeValue();
            tableConfiguration.add((Ordinal)Parameters.RequestTableClearSize, Integer.parseInt(size));
        }
        this.add((Ordinal)name, (Object)tableConfiguration);
    }

    protected void addSecurity(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("SecurityData")) continue;
            items.add(this.addSecurityData(c.item(i)));
        }
        this.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.Security, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addSecurityData(Node node) {
        AppConfiguration sd = XMLConfiguration.getInstance().add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SDName, node.getAttributes().getNamedItem("name").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SDProtocol, node.getAttributes().getNamedItem("protocol").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SDEnableSessionCreation, Boolean.valueOf(node.getAttributes().getNamedItem("enable_session_creation").getNodeValue())).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SDUseClientMode, Boolean.valueOf(node.getAttributes().getNamedItem("use_client_mode").getNodeValue()));
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Node cnode = c.item(i);
            String nodeName = cnode.getNodeName();
            if (nodeName.equals("CipherSuites")) {
                sd.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.CipherSuites, cnode.getTextContent().trim());
            }
            if (nodeName.equals("KeyData")) {
                sd.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.KeyData, (Object)XMLConfiguration.getInstance().add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.KDManager, cnode.getAttributes().getNamedItem("manager").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.KDStore, cnode.getAttributes().getNamedItem("store").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.KDFile, cnode.getAttributes().getNamedItem("file").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.KDPwd, cnode.getAttributes().getNamedItem("pwd").getNodeValue()));
            }
            if (!nodeName.equals("TrustData")) continue;
            sd.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.TrustData, (Object)XMLConfiguration.getInstance().add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.TDManager, cnode.getAttributes().getNamedItem("manager").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.TDStore, cnode.getAttributes().getNamedItem("store").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.TDFile, cnode.getAttributes().getNamedItem("file").getNodeValue()).add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.TDPwd, cnode.getAttributes().getNamedItem("pwd").getNodeValue()));
        }
        return sd;
    }

    protected void addNetwork(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("Peers")) {
                this.addPeers(c.item(i));
                continue;
            }
            if (!nodeName.equals("Realms")) continue;
            this.addRealms(c.item(i));
        }
    }

    protected void addPeers(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Peer")) continue;
            items.add(this.addPeer(c.item(i)));
        }
        this.add((Ordinal)Parameters.PeerTable, items.toArray(this.EMPTY_ARRAY));
    }

    protected void addRealms(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Realm")) continue;
            items.add(this.addRealm(c.item(i)));
        }
        this.add((Ordinal)Parameters.RealmTable, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addPeer(Node node) {
        String rating = node.getAttributes().getNamedItem("rating").getNodeValue();
        String connecting = node.getAttributes().getNamedItem("attempt_connect").getNodeValue();
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        AppConfiguration c = XMLConfiguration.getInstance();
        c.add((Ordinal)Parameters.PeerRating, Integer.parseInt(rating));
        c.add((Ordinal)Parameters.PeerAttemptConnection, Boolean.valueOf(connecting));
        c.add((Ordinal)Parameters.PeerName, name);
        if (node.getAttributes().getNamedItem("ip") != null) {
            c.add((Ordinal)Parameters.PeerIp, node.getAttributes().getNamedItem("ip").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("portRange") != null) {
            c.add((Ordinal)Parameters.PeerLocalPortRange, node.getAttributes().getNamedItem("portRange").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("security_ref") != null) {
            c.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SecurityRef, node.getAttributes().getNamedItem("security_ref").getNodeValue());
        }
        return c;
    }

    protected void addLocalPeer(Node node) {
        NodeList c = node.getChildNodes();
        if (node.getAttributes().getNamedItem("security_ref") != null) {
            this.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.SecurityRef, node.getAttributes().getNamedItem("security_ref").getNodeValue());
        }
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("URI")) {
                this.add((Ordinal)Parameters.OwnDiameterURI, this.getValue(c.item(i)));
            }
            this.addIPAddress(c.item(i));
            if (nodeName.equals("Realm")) {
                this.add((Ordinal)Parameters.OwnRealm, this.getValue(c.item(i)));
            }
            if (nodeName.equals("VendorID")) {
                this.add((Ordinal)Parameters.OwnVendorID, this.getLongValue(c.item(i)));
            }
            if (nodeName.equals("ProductName")) {
                this.add((Ordinal)Parameters.OwnProductName, this.getValue(c.item(i)));
            }
            if (nodeName.equals("FirmwareRevision")) {
                this.add((Ordinal)Parameters.OwnFirmwareRevision, this.getLongValue(c.item(i)));
            }
            if (nodeName.equals("Applications")) {
                this.addApplications(c.item(i));
            }
            if (!nodeName.equals("OverloadMonitor")) continue;
            this.addOverloadMonitor(c.item(i));
        }
    }

    private void addOverloadMonitor(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Entry")) continue;
            items.add(this.addOverloadMonitorItem(c.item(i)));
        }
        this.add((Ordinal)Parameters.OverloadMonitor, items.toArray(this.EMPTY_ARRAY));
    }

    private Configuration addOverloadMonitorItem(Node node) {
        return XMLConfiguration.getInstance().add((Ordinal)Parameters.OverloadEntryIndex, Integer.valueOf(this.getAttrValue(node, "index"))).add((Ordinal)Parameters.OverloadEntrylowThreshold, Double.valueOf(this.getAttrValue(node, "lowThreshold"))).add((Ordinal)Parameters.OverloadEntryhighThreshold, Double.valueOf(this.getAttrValue(node, "highThreshold"))).add((Ordinal)Parameters.ApplicationId, (Object)this.addApplicationID(node.getChildNodes()));
    }

    protected void addIPAddress(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals("IPAddresses")) {
            this.addIPAddresses(node);
        }
    }

    private void addIPAddresses(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("IPAddress")) continue;
            items.add(this.addIPAddressItem(c.item(i)));
        }
        this.add((Ordinal)Parameters.OwnIPAddresses, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addIPAddressItem(Node node) {
        return XMLConfiguration.getInstance().add((Ordinal)Parameters.OwnIPAddress, this.getValue(node));
    }

    protected Configuration addRealm(Node node) {
        AppConfiguration realmEntry = XMLConfiguration.getInstance();
        realmEntry.add((Ordinal)Parameters.ApplicationId, this.addApplicationID(node.getChildNodes())).add((Ordinal)Parameters.RealmName, this.getAttrValue(node, "name")).add((Ordinal)Parameters.RealmHosts, this.getAttrValue(node, "peers")).add((Ordinal)Parameters.RealmLocalAction, this.getAttrValue(node, "local_action")).add((Ordinal)Parameters.RealmEntryIsDynamic, Boolean.valueOf(this.getAttrValue(node, "dynamic"))).add((Ordinal)Parameters.RealmEntryExpTime, Long.valueOf(this.getAttrValue(node, "exp_time")));
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName = childNodes.item(i).getNodeName();
            if (!nodeName.equals("Agent")) continue;
            realmEntry.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.Agent, (Object)this.addAgent(childNodes.item(i)));
        }
        return XMLConfiguration.getInstance().add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.RealmEntry, (Object)realmEntry);
    }

    protected Configuration addAgent(Node node) {
        AppConfiguration agentConf = XMLConfiguration.getInstance();
        NodeList agentChildren = node.getChildNodes();
        for (int index = 0; index < agentChildren.getLength(); ++index) {
            Node n = agentChildren.item(index);
            if (!n.getNodeName().equals("Properties")) continue;
            agentConf.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.Properties, this.getProperties(n).toArray(this.EMPTY_ARRAY));
        }
        return agentConf;
    }

    protected List<Configuration> getProperties(Node node) {
        ArrayList<Configuration> props = new ArrayList<Configuration>();
        NodeList propertiesChildren = node.getChildNodes();
        for (int index = 0; index < propertiesChildren.getLength(); ++index) {
            Node n = propertiesChildren.item(index);
            if (!n.getNodeName().equals("Property")) continue;
            AppConfiguration property = XMLConfiguration.getInstance();
            property.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.PropertyName, n.getAttributes().getNamedItem(org.jdiameter.client.impl.helpers.Parameters.PropertyName.name()).getNodeValue());
            property.add((Ordinal)org.jdiameter.client.impl.helpers.Parameters.PropertyValue, n.getAttributes().getNamedItem(org.jdiameter.client.impl.helpers.Parameters.PropertyValue.name()).getNodeValue());
            props.add(property);
        }
        return props;
    }

    protected void appendOtherParameter(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals("DuplicateProtection")) {
            this.add((Ordinal)Parameters.DuplicateProtection, Boolean.valueOf(this.getValue(node)));
        }
        if (nodeName.equals("DuplicateTimer")) {
            this.add((Ordinal)Parameters.DuplicateTimer, this.getLongValue(node));
        }
        if (nodeName.equals("DuplicateSize")) {
            this.add((Ordinal)Parameters.DuplicateSize, this.getIntValue(node));
        }
        if (nodeName.equals("AcceptUndefinedPeer")) {
            this.add((Ordinal)Parameters.AcceptUndefinedPeer, Boolean.valueOf(this.getValue(node)));
        }
    }

    protected void addExtensions(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("MetaData")) {
                this.addInternalExtension(ExtensionPoint.InternalMetaData, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("MessageParser")) {
                this.addInternalExtension(ExtensionPoint.InternalMessageParser, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ElementParser")) {
                this.addInternalExtension(ExtensionPoint.InternalElementParser, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RouterEngine")) {
                this.addInternalExtension(ExtensionPoint.InternalRouterEngine, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("PeerController")) {
                this.addInternalExtension(ExtensionPoint.InternalPeerController, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RealmController")) {
                this.addInternalExtension(ExtensionPoint.InternalRealmController, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("SessionFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalSessionFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("TransportFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalTransportFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("Connection")) {
                this.addInternalExtension(ExtensionPoint.InternalConnectionClass, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("NetworkGuard")) {
                this.addInternalExtension(ExtensionPoint.InternalNetworkGuard, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("PeerFsmFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalPeerFsmFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StatisticFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalStatisticFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ConcurrentFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalConcurrentFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ConcurrentEntityFactory")) {
                this.addInternalExtension(ExtensionPoint.InternalConcurrentEntityFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StatisticProcessor")) {
                this.addInternalExtension(ExtensionPoint.InternalStatisticProcessor, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("NetWork")) {
                this.addInternalExtension(ExtensionPoint.InternalNetWork, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("SessionDatasource")) {
                this.addInternalExtension(ExtensionPoint.InternalSessionDatasource, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("TimerFacility")) {
                this.addInternalExtension(ExtensionPoint.InternalTimerFacility, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AgentRedirect")) {
                this.addInternalExtension(ExtensionPoint.InternalAgentRedirect, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AgentConfiguration")) {
                this.add((Ordinal)ExtensionPoint.InternalAgentConfiguration, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AgentProxy")) {
                this.addInternalExtension(ExtensionPoint.InternalAgentProxy, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("OverloadManager")) {
                this.addInternalExtension(ExtensionPoint.InternalOverloadManager, this.getValue(c.item(i)));
                continue;
            }
            this.appendOtherExtension(c.item(i));
        }
    }

    protected void addInternalExtension(Ordinal ep, String value) {
        Configuration[] extensionConfs = this.getChildren(Parameters.Extensions.ordinal());
        AppConfiguration internalExtensions = (AppConfiguration)extensionConfs[ExtensionPoint.Internal.id()];
        internalExtensions.add(ep, value);
    }

    private void appendOtherExtension(Node item) {
    }

    protected Long getLongValue(Node node) {
        return new Long(this.getValue(node));
    }

    protected Integer getIntValue(Node node) {
        return new Integer(this.getValue(node));
    }

    protected String getValue(Node node) {
        return node.getAttributes().getNamedItem("value").getNodeValue();
    }

    protected String getAttrValue(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }
}

