/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.sctp;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.Selector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.common.api.concurrent.DummyConcurrentFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.jdiameter.server.impl.io.sctp.SCTPServerConnection;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    protected IMessageParser parser;
    protected IConcurrentFactory concurrentFactory;
    protected int port;
    protected CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    protected boolean isWork = false;
    protected Selector selector;
    protected ServerSocket serverSocket;
    SCTPServerConnection server;
    private Thread thread;
    protected InetAddress localAddress;

    @Deprecated
    public NetworkGuard(InetAddress inetAddress, int port, IMessageParser parser) throws Exception {
        this(inetAddress, port, null, parser, null);
    }

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.port = port;
        this.localAddress = inetAddress;
        this.parser = parser;
        this.concurrentFactory = concurrentFactory == null ? new DummyConcurrentFactory() : concurrentFactory;
        this.thread = this.concurrentFactory.getThread("NetworkGuard", this);
        try {
            this.server = new SCTPServerConnection(null, this.localAddress, port, parser, null, this);
            this.isWork = true;
            this.thread.start();
        }
        catch (Exception exc) {
            this.destroy();
            throw new Exception(exc);
        }
    }

    public void run() {
        try {
            while (this.isWork) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception exc) {
            logger.warn("Server socket stopped", (Throwable)exc);
        }
    }

    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "NetworkGuard:" + (this.serverSocket != null ? this.serverSocket.toString() : "closed");
    }

    public void onNewRemoteConnection(Server globalServer, Association association) {
        logger.debug("New remote connection");
        try {
            String peerAddress = association.getPeerAddress();
            int peerPort = association.getPeerPort();
            SCTPServerConnection remoteClientConnection = new SCTPServerConnection(null, InetAddress.getByName(peerAddress), peerPort, this.localAddress, this.port, this.parser, null, this, globalServer, association, this.server.getManagement());
            this.notifyListeners(remoteClientConnection);
        }
        catch (Exception exc) {
            logger.error("Error creating new remote connection");
        }
    }

    public void destroy() {
        logger.debug("Destroying");
        try {
            this.isWork = false;
            try {
                if (this.thread != null) {
                    this.thread.join(2000L);
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                logger.debug("Can not stop thread", (Throwable)e);
            }
            if (this.server != null && this.server.isConnected()) {
                this.server.disconnect();
                this.server.destroy();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void notifyListeners(SCTPServerConnection server) {
        for (INetworkConnectionListener listener : this.listeners) {
            try {
                listener.newNetworkConnection(server);
            }
            catch (Exception e) {
                logger.debug("Connection listener threw exception!", (Throwable)e);
            }
        }
    }
}

