/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.TCPClientConnection;
import org.jdiameter.common.api.concurrent.DummyConcurrentFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    protected IMessageParser parser;
    protected IConcurrentFactory concurrentFactory;
    protected int port;
    protected CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    protected boolean isWork = false;
    protected Selector selector;
    protected ServerSocket serverSocket;
    private Thread thread;

    @Deprecated
    public NetworkGuard(InetAddress inetAddress, int port, IMessageParser parser) throws Exception {
        this(inetAddress, port, null, parser, null);
    }

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.port = port;
        this.parser = parser;
        this.concurrentFactory = concurrentFactory == null ? new DummyConcurrentFactory() : concurrentFactory;
        this.thread = this.concurrentFactory.getThread("NetworkGuard", this);
        try {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            this.serverSocket = ssc.socket();
            this.serverSocket.bind(new InetSocketAddress(inetAddress, port));
            this.selector = Selector.open();
            ssc.register(this.selector, 16);
            this.isWork = true;
            logger.info("Open server socket {} ", (Object)this.serverSocket);
            this.thread.start();
        }
        catch (Exception exc) {
            this.destroy();
            throw new Exception(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        block8: while (true) {
            try {
                while (this.isWork) {
                    Object var11_13;
                    int num = this.selector.select(200L);
                    if (num == 0) continue;
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    try {
                        try {
                            for (SelectionKey key1 : keys) {
                                SelectionKey key = key1;
                                if ((key.readyOps() & 0x10) != 16) continue;
                                try {
                                    Socket s = this.serverSocket.accept();
                                    logger.info("Open incomming connection {}", (Object)s);
                                    TCPClientConnection client = new TCPClientConnection(null, this.concurrentFactory, s, this.parser, null);
                                    logger.debug("Finished initialising TCPClientConnection for {}", (Object)s);
                                    for (INetworkConnectionListener listener : this.listeners) {
                                        listener.newNetworkConnection(client);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Can not create incoming connection", (Throwable)e);
                                }
                            }
                            var11_13 = null;
                            keys.clear();
                        }
                        catch (Exception e) {
                            logger.debug("Failed to accept connection,", (Throwable)e);
                            var11_13 = null;
                            keys.clear();
                        }
                        continue block8;
                    }
                    catch (Throwable throwable) {
                        var11_13 = null;
                        keys.clear();
                        throw throwable;
                        return;
                    }
                }
            }
            catch (Exception exc) {
                logger.warn("Server socket stopped", (Throwable)exc);
                return;
            }
        }
    }

    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "NetworkGuard:" + (this.serverSocket != null ? this.serverSocket.toString() : "closed");
    }

    public void destroy() {
        try {
            this.isWork = false;
            try {
                if (this.thread != null) {
                    this.thread.join(2000L);
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                logger.debug("Can not stop thread", (Throwable)e);
            }
            if (this.selector != null) {
                this.selector.close();
                this.selector = null;
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }
}

