/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.common;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.RequestEvent;
import javax.sip.address.AddressFactory;
import javax.sip.header.CallIdHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.FacilityException;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import org.apache.log4j.Logger;
import org.mobicents.slee.examples.callcontrol.profile.CallControlProfileCMP;
import org.mobicents.slee.examples.callcontrol.profile.ProfileCreator;
import org.mobicents.slee.resource.sip.SipFactoryProvider;

public abstract class SubscriptionProfileSbb
implements Sbb {
    protected static Logger log = Logger.getLogger(SubscriptionProfileSbb.class);
    private SbbContext sbbContext;
    private SipFactoryProvider fp;
    private AddressFactory addressFactory;
    private MessageFactory messageFactory;
    private ProfileFacility profileFacility;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.fp = (SipFactoryProvider)myEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.fp.getAddressFactory();
            this.messageFactory = this.fp.getMessageFactory();
            this.profileFacility = (ProfileFacility)myEnv.lookup("slee/facilities/profile");
        }
        catch (NamingException ne) {
            log.error((Object)"COULD NOT LOCATE RESOURCE IN JNDI: Check JNDI TREE or entity-binding for proper path!!!", (Throwable)ne);
        }
    }

    protected CallControlProfileCMP lookup(Address address) {
        String profileTableName = new String();
        ProfileID profileID = null;
        CallControlProfileCMP profile = null;
        try {
            profileTableName = "CallControl";
            profileID = this.getProfileFacility().getProfileByIndexedAttribute(profileTableName, "userAddress", (Object)address);
            if (profileID != null) {
                profile = this.getCallControlProfileCMP(profileID);
            }
        }
        catch (NullPointerException e) {
            log.error((Object)"Exception using the getProfileByIndexedAttribute method", (Throwable)e);
        }
        catch (UnrecognizedProfileTableNameException e) {
            log.error((Object)"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):The ProfileID object does not identify a Profile Table created from the Profile Specification", (Throwable)e);
        }
        catch (UnrecognizedProfileNameException e) {
            log.error((Object)"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):The ProfileID object does not identify a Profile within the Profile Table", (Throwable)e);
        }
        catch (TransactionRolledbackLocalException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FacilityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnrecognizedAttributeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotIndexedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeTypeMismatchException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return profile;
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
        ProfileCreator.createProfiles();
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbPassivate() {
    }

    public void sbbActivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected final SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected final ProfileFacility getProfileFacility() {
        return this.profileFacility;
    }

    protected final SbbLocalObject getSbbLocalObject() {
        return this.sbbContext.getSbbLocalObject();
    }

    protected final SipFactoryProvider getSipFactoryProvider() {
        return this.fp;
    }

    protected final AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    protected final MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public abstract CallControlProfileCMP getCallControlProfileCMP(ProfileID var1) throws UnrecognizedProfileNameException, UnrecognizedProfileTableNameException;

    public InitialEventSelector callIDSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        String callID = null;
        if (event instanceof RequestEvent) {
            Request request = ((RequestEvent)event).getRequest();
            callID = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        }
        ies.setCustomName(callID);
        return ies;
    }
}

