/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.profile;

import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.Address;
import javax.slee.AddressPlan;
import org.apache.log4j.Logger;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class ProfileCreator {
    private static boolean createdProfiles = false;
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static Logger log = Logger.getLogger(ProfileCreator.class);

    public static void createProfiles() {
        try {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ProfileCreator._createProfiles();
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static void _createProfiles() {
        if (!createdProfiles) {
            log.info((Object)"Creating profiles ------------------------------------");
            try {
                String jbossBindAddress = System.getProperty("jboss.bind.address");
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                env.put("java.naming.provider.url", "jnp://" + jbossBindAddress);
                env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                RMIAdaptor adaptor = (RMIAdaptor)new InitialContext(env).lookup("jmx/rmi/RMIAdaptor");
                SleeCommandInterface sci = new SleeCommandInterface("jnp://" + System.getProperty("jboss.bind.address") + ":1099", null, null);
                String controllerProfileSpecID = "ProfileSpecificationID[name=CallControlProfileCMP,vendor=org.mobicents,version=0.1]";
                String profileTableName = "CallControl";
                String domain = System.getProperty("jboss.bind.address", "127.0.0.1");
                try {
                    sci.invokeOperation("-removeProfileTable", controllerProfileSpecID, profileTableName, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                sci.invokeOperation("-createProfileTable", controllerProfileSpecID, profileTableName, null);
                log.info((Object)("*** AddressProfileTable " + profileTableName + " created."));
                Address[] blockedAddresses = new Address[]{new Address(AddressPlan.SIP, "sip:mobicents@" + domain), new Address(AddressPlan.SIP, "sip:hugo@" + domain)};
                ProfileCreator.newProfile(adaptor, sci, profileTableName, "torosvi", "sip:torosvi@" + domain, blockedAddresses, null, true);
                log.info((Object)"********** CREATED PROFILE: torosvi **********");
                ProfileCreator.newProfile(adaptor, sci, profileTableName, "mobicents", "sip:mobicents@" + domain, null, null, false);
                log.info((Object)"********** CREATED PROFILE: mobicents **********");
                Address backupAddress = new Address(AddressPlan.SIP, "sip:torosvi@" + domain);
                ProfileCreator.newProfile(adaptor, sci, profileTableName, "victor", "sip:victor@" + domain, null, backupAddress, false);
                log.info((Object)"********** CREATED PROFILE: victor **********");
                ProfileCreator.newProfile(adaptor, sci, profileTableName, "vhros2", "sip:vhros2@" + domain, null, null, true);
                log.info((Object)"********** CREATED PROFILE: vhros2 **********");
                ProfileCreator.newProfile(adaptor, sci, profileTableName, "vmail", "sip:vmail@" + domain, null, null, true);
                log.info((Object)"********** CREATED PROFILE: vmail **********");
                log.info((Object)"Finished creation of call-controller2 Profiles!");
            }
            catch (Exception exception) {
                // empty catch block
            }
            createdProfiles = true;
        }
    }

    private static void newProfile(RMIAdaptor adaptor, SleeCommandInterface sci, String profileTableName, String profileName, String callee, Address[] block, Address backup, boolean state) throws Exception {
        ObjectName profileObjectName = (ObjectName)sci.invokeOperation("-createProfile", profileTableName, profileName, null);
        log.info((Object)("*** AddressProfile " + profileName + " created: " + profileObjectName));
        if (!((Boolean)adaptor.getAttribute(profileObjectName, "ProfileWriteable")).booleanValue()) {
            Object[] o = new Object[]{};
            adaptor.invoke(profileObjectName, "editProfile", o, new String[0]);
            log.info((Object)"*** Setting profile editable.");
        } else {
            log.info((Object)"********* Profile is editable.");
        }
        Address userAddress = new Address(AddressPlan.SIP, callee);
        Attribute userAttr = new Attribute("UserAddress", userAddress);
        Attribute blockedAttr = new Attribute("BlockedAddresses", block);
        Attribute backupAttr = new Attribute("BackupAddress", backup);
        Attribute voicemailAttr = new Attribute("VoicemailState", state);
        adaptor.setAttribute(profileObjectName, userAttr);
        adaptor.setAttribute(profileObjectName, blockedAttr);
        adaptor.setAttribute(profileObjectName, backupAttr);
        adaptor.setAttribute(profileObjectName, voicemailAttr);
        log.info((Object)"*** Profile modifications are not committed yet.");
        adaptor.invoke(profileObjectName, "commitProfile", new Object[0], new String[0]);
        log.info((Object)"*** Profile modifications are committed.");
    }
}

