/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.profile;

import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.Address;
import javax.slee.AddressPlan;
import org.apache.log4j.Logger;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class ProfileCreator {
    private static final String CONF = "credential.properties";
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static Logger log = Logger.getLogger(ProfileCreator.class);
    public static final String CC2_TABLE = "CallControl";
    public static final String CC2_ProfileSpecID = "ProfileSpecificationID[name=CallControlProfileCMP,vendor=org.mobicents,version=0.1]";

    public static void createProfiles() {
        try {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ProfileCreator._createProfiles();
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void removeProfiles() {
        log.info((Object)"Removing profiles for CallControl2 example");
        try {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ProfileCreator._removeProfiles();
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static void setCallPrincipials(String user, String password) {
        if (user != null) {
            SecurityAssociation.setPrincipal((Principal)new SimplePrincipal(user));
            SecurityAssociation.setCredential((Object)password);
        }
    }

    private static void _removeProfiles() {
        try {
            ObjectName name = new ObjectName("javax.slee.management:name=ProfileProvisioning");
            MBeanServer mBeanServer = SleeContainer.lookupFromJndi().getMBeanServer();
            Object[] params = new Object[]{CC2_TABLE};
            String[] signature = new String[]{"java.lang.String"};
            mBeanServer.invoke(name, "removeProfileTable", params, signature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void _createProfiles() {
        log.info((Object)"Creating profiles for CallControl2 example");
        try {
            String domain;
            String profileTableName;
            String controllerProfileSpecID;
            SleeCommandInterface sci;
            RMIAdaptor adaptor;
            String password;
            String user;
            block5: {
                user = null;
                password = null;
                Properties props = new Properties();
                props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(CONF));
                Iterator<Object> credentialsKeys = props.keySet().iterator();
                if (credentialsKeys.hasNext()) {
                    user = (String)credentialsKeys.next();
                    password = props.getProperty(user);
                }
                String jbossBindAddress = System.getProperty("jboss.bind.address");
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                env.put("java.naming.provider.url", "jnp://" + jbossBindAddress);
                env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                env.put("java.naming.security.credentials", password);
                env.put("java.naming.security.principal", user);
                adaptor = (RMIAdaptor)new InitialContext(env).lookup("jmx/rmi/RMIAdaptor");
                sci = new SleeCommandInterface(adaptor, user, password);
                controllerProfileSpecID = CC2_ProfileSpecID;
                profileTableName = CC2_TABLE;
                domain = System.getProperty("jboss.bind.address", "127.0.0.1");
                try {
                    ProfileCreator.setCallPrincipials(user, password);
                    sci.invokeOperation("-removeProfileTable", profileTableName, null, null);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
            sci.invokeOperation("-createProfileTable", controllerProfileSpecID, profileTableName, null);
            log.info((Object)("*** AddressProfileTable " + profileTableName + " created."));
            Address[] blockedAddresses = new Address[]{new Address(AddressPlan.SIP, "sip:restcomm@" + domain), new Address(AddressPlan.SIP, "sip:hugo@" + domain)};
            ProfileCreator.newProfile(adaptor, sci, profileTableName, "torosvi", "sip:torosvi@" + domain, blockedAddresses, null, true, user, password);
            log.info((Object)"********** CREATED PROFILE: torosvi **********");
            ProfileCreator.newProfile(adaptor, sci, profileTableName, "mobicents", "sip:restcomm@" + domain, null, null, false, user, password);
            log.info((Object)"********** CREATED PROFILE: mobicents **********");
            Address backupAddress = new Address(AddressPlan.SIP, "sip:torosvi@" + domain);
            ProfileCreator.newProfile(adaptor, sci, profileTableName, "victor", "sip:victor@" + domain, null, backupAddress, false, user, password);
            log.info((Object)"********** CREATED PROFILE: victor **********");
            ProfileCreator.newProfile(adaptor, sci, profileTableName, "vhros2", "sip:vhros2@" + domain, null, null, true, user, password);
            log.info((Object)"********** CREATED PROFILE: vhros2 **********");
            ProfileCreator.newProfile(adaptor, sci, profileTableName, "vmail", "sip:vmail@" + domain, null, null, true, user, password);
            log.info((Object)"********** CREATED PROFILE: vmail **********");
            log.info((Object)"Finished creation of call-controller2 Profiles!");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Failed to create call-controller2 Profiles!", (Throwable)e);
        }
    }

    private static void newProfile(RMIAdaptor adaptor, SleeCommandInterface sci, String profileTableName, String profileName, String callee, Address[] block, Address backup, boolean state, String user, String password) throws Exception {
        ObjectName profileObjectName = (ObjectName)sci.invokeOperation("-createProfile", profileTableName, profileName, null);
        log.info((Object)("*** AddressProfile " + profileName + " created: " + profileObjectName));
        ProfileCreator.setCallPrincipials(user, password);
        if (!((Boolean)adaptor.getAttribute(profileObjectName, "ProfileWriteable")).booleanValue()) {
            Object[] o = new Object[]{};
            ProfileCreator.setCallPrincipials(user, password);
            adaptor.invoke(profileObjectName, "editProfile", o, new String[0]);
            log.info((Object)"*** Setting profile editable.");
        } else {
            log.info((Object)"********* Profile is editable.");
        }
        Address userAddress = new Address(AddressPlan.SIP, callee);
        Attribute userAttr = new Attribute("UserAddress", userAddress);
        Attribute blockedAttr = new Attribute("BlockedAddresses", block);
        Attribute backupAttr = new Attribute("BackupAddress", backup);
        Attribute voicemailAttr = new Attribute("VoicemailState", state);
        ProfileCreator.setCallPrincipials(user, password);
        adaptor.setAttribute(profileObjectName, userAttr);
        ProfileCreator.setCallPrincipials(user, password);
        adaptor.setAttribute(profileObjectName, blockedAttr);
        ProfileCreator.setCallPrincipials(user, password);
        adaptor.setAttribute(profileObjectName, backupAttr);
        ProfileCreator.setCallPrincipials(user, password);
        adaptor.setAttribute(profileObjectName, voicemailAttr);
        log.info((Object)"*** Profile modifications are not committed yet.");
        ProfileCreator.setCallPrincipials(user, password);
        adaptor.invoke(profileObjectName, "commitProfile", new Object[0], new String[0]);
        log.info((Object)"*** Profile modifications are committed.");
    }
}

