/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.voicemail;

import java.net.URL;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.AddressPlan;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import org.mobicents.media.server.impl.common.events.EventCause;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSignalDetector;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.slee.examples.callcontrol.common.SubscriptionProfileSbb;
import org.mobicents.slee.examples.callcontrol.profile.CallControlProfileCMP;
import org.mobicents.slee.examples.callcontrol.voicemail.VoiceMailSbbActivityContextInterface;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;

public abstract class VoiceMailSbb
extends SubscriptionProfileSbb
implements Sbb {
    private HeaderFactory headerFactory;
    private SipActivityContextInterfaceFactory sipACIF;
    private TimerFacility timerFacility;
    private final String recordAfterTone = "audiofiles/RecordAfterTone.wav";
    private final String waitingDTMF = "audiofiles/WaitingDTMF.wav";
    private final String dtmf1 = "audiofiles/DTMF1.wav";
    private final String dtmf7 = "audiofiles/DTMF7.wav";
    private final String dtmf9 = "audiofiles/DTMF9.wav";
    private final String tryAgain = "audiofiles/TryAgain.wav";
    private final String USER = "vmail";
    private final String HOST = "nist.gov";
    private final String NON_DIGIT = "NULL";
    private final String WAV_EXT = ".wav";
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory msActivityFactory;
    public static final String ENDPOINT_NAME = "media/trunk/IVR/$";

    public void onInvite(RequestEvent event, VoiceMailSbbActivityContextInterface localAci) {
        block16: {
            log.info((Object)"########## VOICE MAIL SBB: INVITE ##########");
            Request request = event.getRequest();
            this.setInviteRequest(request);
            ServerTransaction st = event.getServerTransaction();
            this.setServerTransaction(st);
            try {
                URI uri;
                localAci.detach(this.getSbbLocalObject());
                if (localAci.getFilteredByAncestor()) {
                    log.info((Object)"########## VOICE MAIL SBB: FILTERED BY ANCESTOR ##########");
                    return;
                }
                boolean sameUser = this.sameUser(event);
                if (sameUser) {
                    FromHeader fromHeader = (FromHeader)request.getHeader("From");
                    uri = fromHeader.getAddress().getURI();
                } else {
                    ToHeader toHeader = (ToHeader)request.getHeader("To");
                    uri = toHeader.getAddress().getURI();
                }
                ((SipURI)uri).removePort();
                boolean isSubscriber = this.isSubscriber(uri.toString());
                if (isSubscriber) {
                    String fileRoute = null;
                    InitialContext initCtx = new InitialContext();
                    Context myEnv = (Context)initCtx.lookup("java:comp/env");
                    if (!sameUser) {
                        ToHeader toHeader = (ToHeader)request.getHeader("To");
                        String fileName = ((SipURI)toHeader.getAddress().getURI()).getUser() + ".wav";
                        String route = (String)myEnv.lookup("filesRoute");
                        fileRoute = fileName;
                    }
                    String sdp = new String(request.getRawContent());
                    MsSession mediaSession = this.msProvider.createSession();
                    this.setMediaSession(mediaSession);
                    MsConnection msConnection = mediaSession.createNetworkConnection(ENDPOINT_NAME);
                    ActivityContextInterface msAci = null;
                    try {
                        msAci = this.msActivityFactory.getActivityContextInterface(msConnection);
                        msAci.attach(this.getSbbLocalObject());
                    }
                    catch (Exception ex) {
                        log.error((Object)"Internal server error", (Throwable)ex);
                        this.getMessageFactory().createResponse(500, request);
                        return;
                    }
                    Dialog dial = this.getSipFactoryProvider().getSipProvider().getNewDialog((Transaction)st);
                    ActivityContextInterface dialogAci = this.sipACIF.getActivityContextInterface(dial);
                    dialogAci.attach(this.getSbbLocalObject());
                    Response response = this.getMessageFactory().createResponse(100, request);
                    st.sendResponse(response);
                    response = this.getMessageFactory().createResponse(180, request);
                    st.sendResponse(response);
                    log.info((Object)"Creating RTP connection [media/trunk/IVR/$]");
                    msConnection.modify("$", sdp);
                    break block16;
                }
                Response response = this.getMessageFactory().createResponse(480, request);
                log.info((Object)("########## NO VOICE MAIL AVAILABLE FOR USER: " + uri.toString()));
                st.sendResponse(response);
            }
            catch (TransactionRequiredLocalException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SLEEException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (ParseException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SipException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UnrecognizedActivityException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onByeEvent(RequestEvent event, ActivityContextInterface aci) {
        log.info((Object)"########## VOICE MAIL SBB: BYE ##########");
        try {
            TimerID timerID = this.getTimerID();
            if (timerID != null) {
                this.timerFacility.cancelTimer(timerID);
            }
            this.releaseMediaConnectionAndDialog();
            this.byeRequestOkResponse(event);
        }
        catch (FactoryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
    }

    public void onConnectionCreated(MsConnectionEvent evt, ActivityContextInterface aci) {
        MsConnection connection = evt.getConnection();
        log.info((Object)("Created RTP connection [" + connection.getEndpoint() + "]"));
        MsConnection msConnection = evt.getConnection();
        String sdp = msConnection.getLocalDescriptor();
        ServerTransaction txn = this.getServerTransaction();
        if (txn == null) {
            log.error((Object)"SIP activity lost, close RTP connection");
            msConnection.release();
            return;
        }
        Request request = txn.getRequest();
        ContentTypeHeader contentType = null;
        try {
            contentType = this.getHeaderFactory().createContentTypeHeader("application", "sdp");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        String localAddress = this.getSipFactoryProvider().getSipProvider().getListeningPoints()[0].getIPAddress();
        int localPort = this.getSipFactoryProvider().getSipProvider().getListeningPoints()[0].getPort();
        Address contactAddress = null;
        try {
            contactAddress = this.getAddressFactory().createAddress("sip:" + localAddress + ":" + localPort);
        }
        catch (ParseException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        ContactHeader contact = this.getHeaderFactory().createContactHeader(contactAddress);
        Response response = null;
        try {
            response = this.getMessageFactory().createResponse(200, request, contentType, sdp.getBytes());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        response.setHeader((Header)contact);
        try {
            txn.sendResponse(response);
        }
        catch (InvalidArgumentException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (SipException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        String endpointName = evt.getConnection().getEndpoint();
        this.setUserEndpoint(endpointName);
        if (this.getSameUser()) {
            log.debug((Object)"same user, lets play the voice mail");
            System.out.println("same user, lets play the voice mail");
            MsSignalGenerator generator = this.msProvider.getSignalGenerator(endpointName);
            try {
                ActivityContextInterface generatorActivity = this.msActivityFactory.getActivityContextInterface((MsResource)generator);
                generatorActivity.attach(this.getSbbLocalObject());
                URL audioFileURL = ((Object)((Object)this)).getClass().getResource("audiofiles/WaitingDTMF.wav");
                generator.apply(EventID.PLAY, new String[]{audioFileURL.toString()});
                this.initDtmfDetector(evt.getConnection(), endpointName);
            }
            catch (UnrecognizedActivityException e) {
                e.printStackTrace();
            }
        } else {
            log.debug((Object)"not the same user, start recording after announcement");
            System.out.println("not the same user, start recording after announcement");
            URL audioFileURL = ((Object)((Object)this)).getClass().getResource("audiofiles/RecordAfterTone.wav");
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String fileName = ((SipURI)toHeader.getAddress().getURI()).getUser() + ".wav";
            String route = null;
            String recordFilePath = null;
            try {
                InitialContext initCtx = new InitialContext();
                Context myEnv = (Context)initCtx.lookup("java:comp/env");
                route = (String)myEnv.lookup("filesRoute");
            }
            catch (NamingException nEx) {
                log.warn((Object)"Lookup of filesRoute env Variable failed", (Throwable)nEx);
            }
            recordFilePath = fileName;
            String[] params = new String[]{audioFileURL.toString(), recordFilePath};
            MsSignalGenerator signalGenerator = this.msProvider.getSignalGenerator(endpointName);
            try {
                ActivityContextInterface dtmfAci = this.msActivityFactory.getActivityContextInterface((MsResource)signalGenerator);
                dtmfAci.attach(this.getSbbLocalObject());
                signalGenerator.apply(EventID.PLAY_RECORD, params);
            }
            catch (UnrecognizedActivityException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initDtmfDetector(MsConnection connection, String userEndPoint) {
        MsSignalDetector dtmfDetector = this.msProvider.getSignalDetector(userEndPoint);
        try {
            ActivityContextInterface dtmfAci = this.msActivityFactory.getActivityContextInterface((MsResource)dtmfDetector);
            dtmfAci.attach(this.getSbbLocalObject());
            dtmfDetector.receive(EventID.DTMF, connection, new String[0]);
        }
        catch (UnrecognizedActivityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void releaseMediaConnectionAndDialog() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        SbbLocalObject sbbLocalObject = this.getSbbContext().getSbbLocalObject();
        MsConnection msConnection = null;
        for (ActivityContextInterface attachedAci : activities) {
            if (attachedAci.getActivity() instanceof Dialog) {
                attachedAci.detach(sbbLocalObject);
            }
            if (!(attachedAci.getActivity() instanceof MsConnection)) continue;
            attachedAci.detach(sbbLocalObject);
            msConnection = (MsConnection)attachedAci.getActivity();
        }
        if (msConnection != null) {
            msConnection.release();
        }
    }

    private void sendServerInternalError() {
        try {
            Response response = this.getMessageFactory().createResponse(500, this.getInviteRequest());
            this.getServerTransaction().sendResponse(response);
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SipException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onDtmf(MsNotifyEvent evt, ActivityContextInterface aci) {
        log.info((Object)"########## VOICE MAIL SBB: onDTMFEvent ##########");
        EventCause cause = evt.getCause();
        this.checkDtmfDigit(cause);
        this.initDtmfDetector(this.getConnection(), this.getUserEndpoint());
    }

    private MsConnection getConnection() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsConnection)) continue;
            return (MsConnection)activities[i].getActivity();
        }
        return null;
    }

    private void sendByeRequest() {
        log.info((Object)"########## VOICE MAIL SBB: sendByRequest ##########");
        try {
            SipProvider sipProvider = this.getSipFactoryProvider().getSipProvider();
            Dialog dialog = this.getServerTransaction().getDialog();
            Request request = dialog.createRequest("BYE");
            ClientTransaction ct = sipProvider.getNewClientTransaction(request);
            dialog.sendRequest(ct);
        }
        catch (TransactionUnavailableException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SipException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void byeRequestOkResponse(RequestEvent byeEvent) {
        log.info((Object)"########## VOICE MAIL SBB: byeRequestOkResponse ##########");
        Request request = byeEvent.getRequest();
        ServerTransaction tx = byeEvent.getServerTransaction();
        try {
            Response response = this.getMessageFactory().createResponse(200, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkDtmfDigit(EventCause dtmf) {
        URL audioFileURL = dtmf.equals((Object)EventCause.DTMF_DIGIT_1) ? ((Object)((Object)this)).getClass().getResource("audiofiles/DTMF1.wav") : (dtmf.equals((Object)EventCause.DTMF_DIGIT_7) ? ((Object)((Object)this)).getClass().getResource("audiofiles/DTMF7.wav") : (dtmf.equals((Object)EventCause.DTMF_DIGIT_9) ? ((Object)((Object)this)).getClass().getResource("audiofiles/DTMF9.wav") : ((Object)((Object)this)).getClass().getResource("audiofiles/TryAgain.wav")));
        MsSignalGenerator generator = this.msProvider.getSignalGenerator(this.getUserEndpoint());
        try {
            ActivityContextInterface generatorActivity = this.msActivityFactory.getActivityContextInterface((MsResource)generator);
            generatorActivity.attach(this.getSbbContext().getSbbLocalObject());
            generator.apply(EventID.PLAY, new String[]{audioFileURL.toString()});
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    private boolean isSubscriber(String sipAddress) {
        boolean state = false;
        CallControlProfileCMP profile = this.lookup(new javax.slee.Address(AddressPlan.SIP, sipAddress));
        if (profile != null) {
            state = profile.getVoicemailState();
        }
        return state;
    }

    private boolean sameUser(RequestEvent event) {
        boolean sameUser = false;
        Request inviteRequest = event.getRequest();
        ToHeader toHeader = (ToHeader)inviteRequest.getHeader("To");
        SipURI toURI = (SipURI)toHeader.getAddress().getURI();
        if (toURI.getUser().equals("vmail") && toURI.getHost().equals("nist.gov")) {
            sameUser = true;
        }
        this.setSameUser(sameUser);
        return sameUser;
    }

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        this.headerFactory = this.getSipFactoryProvider().getHeaderFactory();
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.msProvider = (MsProvider)myEnv.lookup("slee/resources/media/1.0/provider");
            this.msActivityFactory = (MediaRaActivityContextInterfaceFactory)myEnv.lookup("slee/resources/media/1.0/acifactory");
            this.sipACIF = (SipActivityContextInterfaceFactory)myEnv.lookup("slee/resources/jainsip/1.2/acifactory");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void sbbPostCreate() throws CreateException {
        this.setDtmf("NULL");
    }

    public abstract CallControlProfileCMP getCallControlProfileCMP(ProfileID var1) throws UnrecognizedProfileNameException, UnrecognizedProfileTableNameException;

    public abstract VoiceMailSbbActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    private final HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public abstract void setMediaSession(MsSession var1);

    public abstract MsSession getMediaSession();

    public abstract void setInviteRequest(Request var1);

    public abstract Request getInviteRequest();

    public abstract void setServerTransaction(ServerTransaction var1);

    public abstract ServerTransaction getServerTransaction();

    public abstract void setOk(boolean var1);

    public abstract boolean getOk();

    public abstract void setSameUser(boolean var1);

    public abstract boolean getSameUser();

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setDtmf(String var1);

    public abstract String getDtmf();

    public abstract String getUserEndpoint();

    public abstract void setUserEndpoint(String var1);
}

