/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.user.ship;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import org.apache.log4j.Logger;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;
import org.mobicents.slee.resource.persistence.ratype.PersistenceResourceAdaptorSbbInterface;
import org.mobicents.slee.resource.tts.ratype.TTSSession;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class OrderShipDateSbb
extends CommonSbb {
    private Logger logger = Logger.getLogger(OrderShipDateSbb.class);
    private PersistenceResourceAdaptorSbbInterface persistenceResourceAdaptorSbbInterface = null;
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory mediaAcif;
    String audioFilePath = null;
    String callerSip = null;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.audioFilePath = System.getProperty("jboss.server.data.dir");
            this.callerSip = (String)myEnv.lookup("callerSip");
            this.persistenceResourceAdaptorSbbInterface = (PersistenceResourceAdaptorSbbInterface)myEnv.lookup("slee/resources/pra/0.1/provider");
            this.msProvider = (MsProvider)myEnv.lookup("slee/resources/media/1.0/provider");
            this.mediaAcif = (MediaRaActivityContextInterfaceFactory)myEnv.lookup("slee/resources/media/1.0/acifactory");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public void onOrderShipped(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)"======== OrderShipDateSbb ORDER_SHIPPED ========");
        this.makeCall(event, ac);
    }

    private void makeCall(CustomEvent event, ActivityContextInterface ac) {
        EntityManager mgr = null;
        Order order = null;
        this.setCustomEvent(event);
        this.setDateAndTime("");
        mgr = this.persistenceResourceAdaptorSbbInterface.createEntityManager(new HashMap(), "custom-pu");
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        Timestamp orderDate = order.getDeliveryDate();
        mgr.close();
        StringBuffer audioPath = new StringBuffer(this.audioFilePath);
        audioPath.append("/");
        audioPath.append(event.getUserName());
        audioPath.append(".wav");
        TTSSession ttsSession = this.getTTSProvider().getNewTTSSession(audioPath.toString(), "kevin");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome ");
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(". This is a reminedr call for your order number ");
        stringBuffer.append(event.getOrderId());
        stringBuffer.append(". The shippment will be at your door step on .");
        stringBuffer.append(orderDate.getDate());
        stringBuffer.append(" of ");
        String month = null;
        switch (orderDate.getMonth()) {
            case 0: {
                month = "January";
                break;
            }
            case 1: {
                month = "February";
                break;
            }
            case 2: {
                month = "March";
                break;
            }
            case 3: {
                month = "April";
                break;
            }
            case 4: {
                month = "May";
                break;
            }
            case 5: {
                month = "June";
                break;
            }
            case 6: {
                month = "July";
                break;
            }
            case 7: {
                month = "August";
                break;
            }
            case 8: {
                month = "September";
                break;
            }
            case 9: {
                month = "October";
                break;
            }
            case 10: {
                month = "November";
                break;
            }
            case 11: {
                month = "December";
                break;
            }
        }
        stringBuffer.append(month);
        stringBuffer.append(" ");
        stringBuffer.append(1900 + orderDate.getYear());
        stringBuffer.append(" at ");
        stringBuffer.append(orderDate.getHours());
        stringBuffer.append(" hour and ");
        stringBuffer.append(orderDate.getMinutes());
        stringBuffer.append(" minute. Thank you. Bye.");
        ttsSession.textToAudioFile(stringBuffer.toString());
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(event.getCustomerPhone());
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error getting dialog", (Throwable)e);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Obtained dialog in onThirdPCCTriggerEvent : callId = " + dialog.getCallId().getCallId()));
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, (Object)sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            ct.sendRequest();
        }
        catch (ParseException parExc) {
            this.logger.error((Object)"Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.error((Object)"InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.error((Object)"TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.error((Object)"UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.error((Object)"CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.error((Object)"SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onLinkReleased(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"-----onLinkReleased-----");
        this.getChildSbbLocalObject().sendBye();
    }

    public void onAnnouncementComplete(MsNotifyEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"Announcement complete: ");
        MsLink link = this.getLink();
        link.release();
    }

    public void onLinkCreated(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"--------onLinkCreated------------");
        MsLink link = evt.getSource();
        String announcementEndpoint = link.getEndpoints()[1];
        String endpointName = link.getEndpoints()[0];
        this.logger.info((Object)("endpoint name: " + endpointName));
        this.logger.info((Object)("Announcement endpoint: " + announcementEndpoint));
        MsSignalGenerator generator = this.msProvider.getSignalGenerator(announcementEndpoint);
        try {
            ActivityContextInterface generatorActivity = this.mediaAcif.getActivityContextInterface((MsResource)generator);
            generatorActivity.attach(this.getSbbContext().getSbbLocalObject());
            StringBuffer audioPath = new StringBuffer("file:");
            audioPath.append(this.audioFilePath);
            audioPath.append("/");
            audioPath.append(this.getCustomEvent().getUserName());
            audioPath.append(".wav");
            generator.apply(EventID.PLAY, new String[]{audioPath.toString()});
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public MsLink getLink() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsLink)) continue;
            return (MsLink)activities[i].getActivity();
        }
        return null;
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setSendBye(boolean var1);

    public abstract boolean getSendBye();

    public abstract void setDateAndTime(String var1);

    public abstract String getDateAndTime();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();
}

