/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import javax.slee.connection.SleeConnectionFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.bpm.CreateProcess;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.mobicents.examples.convergeddemo.seam.action.Checkout;
import org.mobicents.examples.convergeddemo.seam.action.InsufficientQuantityException;
import org.mobicents.examples.convergeddemo.seam.action.ShoppingCart;
import org.mobicents.examples.convergeddemo.seam.model.Customer;
import org.mobicents.examples.convergeddemo.seam.model.Inventory;
import org.mobicents.examples.convergeddemo.seam.model.Order;
import org.mobicents.examples.convergeddemo.seam.model.OrderLine;
import org.mobicents.examples.convergeddemo.seam.model.Product;
import org.mobicents.slee.service.events.CustomEvent;

@Stateful
@Name(value="checkout")
public class CheckoutAction
implements Checkout,
Serializable {
    private static final long serialVersionUID = -4651884454184474207L;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;
    @In(value="currentUser", required=false)
    Customer customer;
    @In(create=true)
    ShoppingCart cart;
    @Out(scope=ScopeType.CONVERSATION, required=false)
    Order currentOrder;
    @Out(scope=ScopeType.CONVERSATION, required=false)
    Order completedOrder;
    @Out(scope=ScopeType.BUSINESS_PROCESS, required=false)
    long orderId;
    @Out(scope=ScopeType.BUSINESS_PROCESS, required=false)
    BigDecimal amount = BigDecimal.ZERO;
    @Out(value="userName", scope=ScopeType.BUSINESS_PROCESS, required=false)
    String userName;
    @Out(value="customerfullname", scope=ScopeType.BUSINESS_PROCESS, required=false)
    String customerFullName;
    @Out(value="cutomerphone", scope=ScopeType.BUSINESS_PROCESS, required=false)
    String customerPhone;

    @Begin(nested=true, pageflow="checkout")
    public void createOrder() {
        this.currentOrder = new Order();
        for (OrderLine line : this.cart.getCart()) {
            this.currentOrder.addProduct((Product)this.em.find(Product.class, (Object)line.getProduct().getProductId()), line.getQuantity());
        }
        this.currentOrder.calculateTotals();
        this.cart.resetCart();
    }

    @End
    @CreateProcess(definition="OrderManagement", processKey="#{completedOrder.orderId}")
    @Restrict(value="#{identity.loggedIn}")
    public void submitOrder() {
        try {
            this.completedOrder = this.purchase(this.customer, this.currentOrder);
            this.orderId = this.completedOrder.getOrderId();
            this.amount = this.completedOrder.getNetAmount();
            this.userName = this.completedOrder.getCustomer().getUserName();
            this.customerFullName = this.completedOrder.getCustomer().getFirstName() + " " + this.completedOrder.getCustomer().getLastName();
            this.customerPhone = this.completedOrder.getCustomer().getPhone();
            this.fireEvent(this.orderId, this.amount, this.customerFullName, this.customerPhone, this.userName);
        }
        catch (InsufficientQuantityException e) {
            for (Product product : e.getProducts()) {
                Contexts.getEventContext().set("prod", (Object)product);
                FacesMessages.instance().addFromResourceBundle("checkoutInsufficientQuantity", new Object[0]);
            }
        }
    }

    private Order purchase(Customer customer, Order order) throws InsufficientQuantityException {
        order.setCustomer(customer);
        order.setOrderDate(new Date());
        ArrayList<Product> errorProducts = new ArrayList<Product>();
        for (OrderLine line : order.getOrderLines()) {
            Inventory inv = line.getProduct().getInventory();
            if (inv.order(line.getQuantity())) continue;
            errorProducts.add(line.getProduct());
        }
        if (errorProducts.size() > 0) {
            throw new InsufficientQuantityException(errorProducts);
        }
        order.calculateTotals();
        this.em.persist((Object)order);
        return order;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private void fireEvent(long orderId, BigDecimal ammount, String customerFullName, String customerPhone, String userName) {
        try {
            InitialContext ic = new InitialContext();
            SleeConnectionFactory factory = (SleeConnectionFactory)ic.lookup("java:/MobicentsConnectionFactory");
            SleeConnection conn1 = null;
            conn1 = factory.getConnection();
            ExternalActivityHandle handle = conn1.createActivityHandle();
            EventTypeID requestType = conn1.getEventTypeID("org.mobicents.slee.service.dvddemo.ORDER_PLACED", "org.mobicents", "1.0");
            CustomEvent customEvent = new CustomEvent(orderId, ammount, customerFullName, customerPhone, userName);
            conn1.fireEvent((Object)customEvent, requestType, handle, null);
            conn1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Remove
    public void destroy() {
    }
}

