/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.math.BigDecimal;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import javax.slee.connection.SleeConnectionFactory;
import org.mobicents.slee.service.events.CustomEvent;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/A"), @ActivationConfigProperty(propertyName="DLQMaxResent", propertyValue="10")})
public class EJB3MDBExample
implements MessageListener {
    public void onMessage(Message m) {
        this.businessLogic(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void businessLogic(Message m) {
        Object conn = null;
        Object session = null;
        Object service = null;
        try {
            TextMessage tm = (TextMessage)m;
            String text = tm.getText();
            System.out.println("message " + text + " received");
            String[] mssArr = text.split(",");
            for (int i = 0; i < mssArr.length; ++i) {
                System.out.println(mssArr[i]);
            }
            System.out.println("************************** EJB3MDBExample -> Start **************************");
            InitialContext ctx = new InitialContext();
            SleeConnectionFactory factory = (SleeConnectionFactory)ctx.lookup("java:/MobicentsConnectionFactory");
            SleeConnection conn1 = null;
            conn1 = factory.getConnection();
            long orderId = Long.parseLong(mssArr[0]);
            BigDecimal amount = new BigDecimal(mssArr[1]);
            CustomEvent customEvent = new CustomEvent(orderId, amount, mssArr[2], mssArr[3], mssArr[4]);
            EventTypeID requestType = conn1.getEventTypeID("org.mobicents.slee.service.sfdemo.ORDER_PLACED", "org.mobicents", "1.0");
            ExternalActivityHandle handle = conn1.createActivityHandle();
            conn1.fireEvent((Object)customEvent, requestType, handle, null);
            System.out.println("************************** MDBExample -> End **************************");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("The Message Driven Bean failed!");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("Could not close the connection!" + e);
                }
            }
        }
    }
}

